/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.standard.imgobj;

import java.util.HashMap;
import java.util.Map;
import org.sikuli.script.Region;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.appdriver.SmartAppDriver;
import org.uitnet.testing.smartfwk.ui.core.commons.LocatorType;
import org.uitnet.testing.smartfwk.ui.core.config.AppConfig;
import org.uitnet.testing.smartfwk.ui.core.config.ApplicationType;
import org.uitnet.testing.smartfwk.ui.core.config.PlatformType;
import org.uitnet.testing.smartfwk.ui.core.config.WebBrowserType;
import org.uitnet.testing.smartfwk.ui.core.objects.ObjectLocation;
import org.uitnet.testing.smartfwk.ui.core.objects.button.Button;
import org.uitnet.testing.smartfwk.ui.core.utils.LocatorUtil;
import org.uitnet.testing.smartfwk.ui.standard.imgobj.ButtonValidatorSI;

public class ButtonSI
extends Button {
    protected Map<String, String> platformImages = new HashMap<String, String>();
    protected ObjectLocation buttonImgLocation;

    public ButtonSI(String displayName, String buttonImg, ObjectLocation buttonImgLocation) {
        super(LocatorType.IMAGE, displayName);
        this.platformImages.put("default-image", buttonImg);
        this.buttonImgLocation = buttonImgLocation;
    }

    public ButtonSI addPlatformImageForNativeApp(PlatformType platform, String buttonImg) {
        LocatorUtil.setPlatformImageForNativeApp(this.platformImages, platform, buttonImg);
        return this;
    }

    public ButtonSI addPlatformImageForWebApp(PlatformType platform, WebBrowserType browserType, String buttonImg) {
        LocatorUtil.setPlatformImageForWebApp(this.platformImages, platform, browserType, buttonImg);
        return this;
    }

    public String getButtonImage(PlatformType platform, ApplicationType appType, WebBrowserType browserType) {
        return LocatorUtil.findImage(this.platformImages, platform, appType, browserType);
    }

    public ObjectLocation getButtonImageLocation() {
        return this.buttonImgLocation;
    }

    @Override
    public ButtonValidatorSI getValidator(SmartAppDriver appDriver, Region region) {
        return new ButtonValidatorSI(appDriver, this, region);
    }

    @Override
    public ButtonSI clone() {
        return null;
    }

    @Override
    public ButtonSI updateLocatorParameterWithValue(AppConfig appConfig, String paramName, String paramValue) {
        Assert.fail((String)"updateLocatorParameterWithValue() API is not implemented.");
        return this;
    }
}

