/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.standard.imgobj;

import java.util.List;
import org.openqa.selenium.Keys;
import org.openqa.selenium.interactions.Actions;
import org.sikuli.script.Button;
import org.sikuli.script.Location;
import org.sikuli.script.Match;
import org.sikuli.script.Region;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.appdriver.SmartAppDriver;
import org.uitnet.testing.smartfwk.ui.core.commons.ImageSection;
import org.uitnet.testing.smartfwk.ui.core.commons.UIObjectType;
import org.uitnet.testing.smartfwk.ui.core.objects.ImageObject;
import org.uitnet.testing.smartfwk.ui.core.objects.NewTextLocation;
import org.uitnet.testing.smartfwk.ui.core.objects.checkbox.CheckBoxValidator;
import org.uitnet.testing.smartfwk.ui.core.objects.scrollbar.Scrollbar;
import org.uitnet.testing.smartfwk.ui.standard.imgobj.CheckBoxSI;

public class CheckBoxValidatorSI
extends CheckBoxValidator {
    protected CheckBoxSI cbObject;

    public CheckBoxValidatorSI(SmartAppDriver appDriver, CheckBoxSI uiObject, Region region) {
        super(appDriver, uiObject, region);
        this.cbObject = uiObject;
    }

    @Override
    public boolean isPresent(int maxIterationsToLocateElements) {
        Match m = this.findElementNoException(maxIterationsToLocateElements);
        return m != null;
    }

    @Override
    public boolean isVisible(int maxIterationsToLocateElements) {
        return this.isPresent(maxIterationsToLocateElements);
    }

    @Override
    public void click(int maxIterationsToLocateElements) {
        try {
            Match match = this.findElement(maxIterationsToLocateElements);
            match.click();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse click on CheckBox '" + this.cbObject.getDisplayName() + "'."), (Throwable)th);
        }
    }

    public void click(ImageSection imageSection, int maxIterationsToLocateElements) {
        try {
            Match match = this.findElement(maxIterationsToLocateElements);
            this.getImageSection(match, imageSection).click();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse click on CheckBox '" + this.cbObject.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void doubleClick(int maxIterationsToLocateElements) {
        try {
            Match match = this.findElement(maxIterationsToLocateElements);
            match.doubleClick();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse double click on CheckBox '" + this.cbObject.getDisplayName() + "'."), (Throwable)th);
        }
    }

    public void doubleClick(ImageSection imageSection, int maxIterationsToLocateElements) {
        try {
            Match match = this.findElement(maxIterationsToLocateElements);
            this.getImageSection(match, imageSection).doubleClick();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse double click on CheckBox '" + this.cbObject.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void rightClick(int maxIterationsToLocateElements) {
        try {
            Match match = this.findElement(maxIterationsToLocateElements);
            match.rightClick();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse right click on CheckBox '" + this.cbObject.getDisplayName() + "'."), (Throwable)th);
        }
    }

    public void rightClick(ImageSection imageSection, int maxIterationsToLocateElements) {
        try {
            Match match = this.findElement(maxIterationsToLocateElements);
            this.getImageSection(match, imageSection).rightClick();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse right click on CheckBox '" + this.cbObject.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void clickAndHold(int maxIterationsToLocateElements) {
        try {
            Match match = this.findElement(maxIterationsToLocateElements);
            match.mouseDown(Button.LEFT);
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse clickAndHold on CheckBox '" + this.cbObject.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void release(int maxIterationsToLocateElements) {
        try {
            Match match = this.findElement(maxIterationsToLocateElements);
            match.mouseDown(Button.LEFT);
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse clickAndHold on CheckBox '" + this.cbObject.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void performKeyDown(Keys keys, int maxIterationsToLocateElements) {
        try {
            Match match = this.findElement(maxIterationsToLocateElements);
            match.click();
            match.keyDown(this.seleniumToSikuliKeyConverter(keys));
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform keyDown on CheckBox '" + this.cbObject.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void performKeyUp(Keys keys, int maxIterationsToLocateElements) {
        try {
            Match match = this.findElement(maxIterationsToLocateElements);
            match.click();
            match.keyUp(this.seleniumToSikuliKeyConverter(keys));
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform keyUp ('" + this.seleniumToSikuliKeyConverter(keys) + "') on CheckBox '" + this.cbObject.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void performKeyPressed(Keys keys, int maxIterationsToLocateElements) {
        try {
            Match match = this.findElement(maxIterationsToLocateElements);
            match.click();
            match.keyDown(this.seleniumToSikuliKeyConverter(keys));
            match.keyUp(this.seleniumToSikuliKeyConverter(keys));
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform keyPressed ('" + this.seleniumToSikuliKeyConverter(keys) + "') on CheckBox '" + this.cbObject.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    @Deprecated
    public void typeText(String text, NewTextLocation location, int maxIterationsToLocateElements) {
        Assert.fail((String)"typeText() API is not supported for CheckBox element.");
    }

    @Override
    public CheckBoxValidatorSI scrollElementOnViewport(Scrollbar scrollbar) {
        return this;
    }

    public Match findElement(int maxIterationsToLocateElements) {
        Match match = null;
        for (int i = 0; i <= maxIterationsToLocateElements; ++i) {
            try {
                Region region = this.cbObject.getCheckBoxImageLocation().getRegionOfImageObject(this.appDriver, this.cbObject.getCheckBoxImage(this.appDriver.getAppConfig().getTestPlatformType(), this.appDriver.getAppConfig().getAppType(), this.appDriver.getAppConfig().getAppWebBrowser()));
                Assert.assertNotNull((Object)region, (String)("Failed to find CheckBox '" + this.cbObject.getDisplayName() + "'."));
                match = new Match(region, 1.0);
                break;
            }
            catch (Throwable th) {
                if (i == maxIterationsToLocateElements) {
                    Assert.fail((String)("Unable to find CheckBox '" + this.cbObject.getDisplayName() + "'. Reason timeout(waited for " + maxIterationsToLocateElements * 2 + " seconds)."), (Throwable)th);
                    break;
                }
                this.appDriver.waitForSeconds(2);
                continue;
            }
        }
        return match;
    }

    public Match findElementNoException(int maxIterationsToLocateElements) {
        Match match = null;
        try {
            match = this.findElement(maxIterationsToLocateElements);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return match;
    }

    @Override
    public List<Match> findElements(int maxIterationsToLocateElements) {
        Region r = this.cbObject.getCheckBoxImageLocation().getRegion(this.appDriver);
        return new ImageObject(UIObjectType.checkBox, this.cbObject.getDisplayName(), this.cbObject.getCheckBoxImage(this.appDriver.getAppConfig().getTestPlatformType(), this.appDriver.getAppConfig().getAppType(), this.appDriver.getAppConfig().getAppWebBrowser())).getValidator(this.appDriver, r).findElements(maxIterationsToLocateElements);
    }

    public void dragAndDrop(ImageObject target, Region targetRegion, int maxIterationsToLocateElements) {
        try {
            Match sourceElem = this.findElement(maxIterationsToLocateElements);
            Match targetElem = target.getValidator(this.appDriver, targetRegion).findElement(maxIterationsToLocateElements);
            Assert.assertNotNull((Object)sourceElem, (String)("Failed to find CheckBox '" + this.cbObject.getDisplayName() + "'."));
            Assert.assertNotNull((Object)targetElem, (String)("Failed to find element '" + target.getDisplayName() + "'."));
            sourceElem.drag((Object)targetElem);
            sourceElem.dropAt((Object)targetElem);
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform dragAndDrop from source '" + this.cbObject.getDisplayName() + "' to target '" + target.getDisplayName() + "'."), (Throwable)th);
        }
    }

    protected Location getImageSection(Match imageMatch, ImageSection imageSection) {
        switch (imageSection) {
            case topLeft: {
                return imageMatch.getTopLeft();
            }
            case topRight: {
                return imageMatch.getTopRight();
            }
            case bottomLeft: {
                return imageMatch.getBottomLeft();
            }
            case bottomRight: {
                return imageMatch.getBottomRight();
            }
            case center: {
                return imageMatch.getCenter();
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public boolean isCheckBoxChecked(int maxIterationsToLocateElements) {
        Assert.fail((String)"isCheckBoxChecked() is not supported for image components.");
        return false;
    }

    @Override
    @Deprecated
    public void validateCheckBoxChecked(int maxIterationsToLocateElements) {
        Assert.fail((String)"validateCheckBoxChecked() is not supported for CheckBox component.");
    }

    @Override
    @Deprecated
    public void validateCheckBoxUnchecked(int maxIterationsToLocateElements) {
        Assert.fail((String)"validateCheckBoxUnchecked() is not supported for CheckBox component.");
    }

    @Override
    @Deprecated
    public void checkAndValidateChecked(int maxIterationsToLocateElements) {
        Assert.fail((String)"checkAndValidateChecked() is not supported for CheckBox component.");
    }

    @Override
    @Deprecated
    public void uncheckAndValidateUnchecked(int maxIterationsToLocateElements) {
        Assert.fail((String)"uncheckAndValidateUnchecked() is not supported for CheckBox component.");
    }

    @Override
    @Deprecated
    public boolean isDisabled(int maxIterationsToLocateElements) {
        Assert.fail((String)"isDisabled() is not supported for CheckBox component.");
        return false;
    }

    @Override
    @Deprecated
    public void validateDisabled(int maxIterationsToLocateElements) {
        Assert.fail((String)"validateDisabled() is not supported for CheckBox component.");
    }

    @Override
    @Deprecated
    public void validateEnabled(int maxIterationsToLocateElements) {
        Assert.fail((String)"validateEnabled() is not supported for CheckBox component.");
    }

    @Override
    @Deprecated
    public Actions getNewSeleniumActions() {
        Assert.fail((String)"getNewSeleniumActions() API is not supported by Button component.");
        return null;
    }

    @Override
    public boolean isDisabledButNotReadonly(int maxIterationsToLocateElements) {
        Assert.fail((String)"validateDisabledButNotReadonly() API is not supported by Button component.");
        return false;
    }

    @Override
    public void validateDisabledButNotReadonly(int maxIterationsToLocateElements) {
        Assert.fail((String)"validateDisabledButNotReadonly() API is not supported by Button component.");
    }

    @Override
    public void validateEnabledButNotReadonly(int maxIterationsToLocateElements) {
        Assert.fail((String)"validateDisabledButNotReadonly() API is not supported by Button component.");
    }
}

