/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.standard.imgobj;

import java.util.HashMap;
import java.util.Map;
import org.sikuli.script.Region;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.appdriver.SmartAppDriver;
import org.uitnet.testing.smartfwk.ui.core.commons.LocatorType;
import org.uitnet.testing.smartfwk.ui.core.config.AppConfig;
import org.uitnet.testing.smartfwk.ui.core.config.ApplicationType;
import org.uitnet.testing.smartfwk.ui.core.config.PlatformType;
import org.uitnet.testing.smartfwk.ui.core.config.WebBrowserType;
import org.uitnet.testing.smartfwk.ui.core.objects.ObjectLocation;
import org.uitnet.testing.smartfwk.ui.core.objects.image.Image;
import org.uitnet.testing.smartfwk.ui.core.utils.LocatorUtil;
import org.uitnet.testing.smartfwk.ui.standard.imgobj.ImageValidatorSI;

public class ImageSI
extends Image {
    protected Map<String, String> platformImages = new HashMap<String, String>();
    protected ObjectLocation imageLocation;

    public ImageSI(String displayName, String image, ObjectLocation imageLocation) {
        super(LocatorType.IMAGE, displayName);
        this.platformImages.put("default-image", image);
        this.imageLocation = imageLocation;
    }

    public ImageSI addPlatformImageForNativeApp(PlatformType platform, String image) {
        LocatorUtil.setPlatformImageForNativeApp(this.platformImages, platform, image);
        return this;
    }

    public ImageSI addPlatformImageForWebApp(PlatformType platform, WebBrowserType browserType, String image) {
        LocatorUtil.setPlatformImageForWebApp(this.platformImages, platform, browserType, image);
        return this;
    }

    public String getImage(PlatformType platform, ApplicationType appType, WebBrowserType browserType) {
        return LocatorUtil.findImage(this.platformImages, platform, appType, browserType);
    }

    public ObjectLocation getImageLocation() {
        return this.imageLocation;
    }

    @Override
    public ImageValidatorSI getValidator(SmartAppDriver appDriver, Region region) {
        return new ImageValidatorSI(appDriver, this, region);
    }

    @Override
    public ImageSI clone() {
        return null;
    }

    @Override
    public ImageSI updateLocatorParameterWithValue(AppConfig appConfig, String paramName, String paramValue) {
        Assert.fail((String)"updateLocatorParameterWithValue() API is not implemented.");
        return this;
    }
}

