/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.standard.imgobj;

import java.util.HashMap;
import java.util.Map;
import org.sikuli.script.Region;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.appdriver.SmartAppDriver;
import org.uitnet.testing.smartfwk.ui.core.commons.LocatorType;
import org.uitnet.testing.smartfwk.ui.core.config.AppConfig;
import org.uitnet.testing.smartfwk.ui.core.config.ApplicationType;
import org.uitnet.testing.smartfwk.ui.core.config.PlatformType;
import org.uitnet.testing.smartfwk.ui.core.config.WebBrowserType;
import org.uitnet.testing.smartfwk.ui.core.objects.ObjectLocation;
import org.uitnet.testing.smartfwk.ui.core.objects.radio.RadioButton;
import org.uitnet.testing.smartfwk.ui.core.utils.LocatorUtil;
import org.uitnet.testing.smartfwk.ui.standard.imgobj.RadioButtonValidatorSI;

public class RadioButtonSI
extends RadioButton {
    protected Map<String, String> platformImages = new HashMap<String, String>();
    protected ObjectLocation radioButtonImgLocation;

    public RadioButtonSI(String displayName, String radioButtonImg, ObjectLocation radioButtonImgLocation) {
        super(LocatorType.IMAGE, displayName);
        this.platformImages.put("default-image", radioButtonImg);
        this.radioButtonImgLocation = radioButtonImgLocation;
    }

    public RadioButtonSI addPlatformImageForNativeApp(PlatformType platform, String radioButtonImg) {
        LocatorUtil.setPlatformImageForNativeApp(this.platformImages, platform, radioButtonImg);
        return this;
    }

    public RadioButtonSI addPlatformImageForWebApp(PlatformType platform, WebBrowserType browserType, String radioButtonImg) {
        LocatorUtil.setPlatformImageForWebApp(this.platformImages, platform, browserType, radioButtonImg);
        return this;
    }

    public String getRadioButtonImage(PlatformType platform, ApplicationType appType, WebBrowserType browserType) {
        return LocatorUtil.findImage(this.platformImages, platform, appType, browserType);
    }

    public ObjectLocation getRadioButtonImageLocation() {
        return this.radioButtonImgLocation;
    }

    @Override
    public RadioButtonValidatorSI getValidator(SmartAppDriver appDriver, Region region) {
        return new RadioButtonValidatorSI(appDriver, this, region);
    }

    @Override
    public RadioButtonSI clone() {
        return null;
    }

    @Override
    public RadioButtonSI updateLocatorParameterWithValue(AppConfig appConfig, String paramName, String paramValue) {
        Assert.fail((String)"updateLocatorParameterWithValue() API is not implemented.");
        return this;
    }
}

