/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.api.core.defaults;

import java.util.HashMap;
import java.util.Map;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.api.core.AbstractApiTestHelper;

public class SmartApiTestManager {
    private static SmartApiTestManager instance;
    private Map<String, AbstractApiTestHelper> appTestHelpers = new HashMap<String, AbstractApiTestHelper>();

    private SmartApiTestManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SmartApiTestManager getInstance() {
        if (instance != null) {
            return instance;
        }
        Class<SmartApiTestManager> clazz = SmartApiTestManager.class;
        synchronized (SmartApiTestManager.class) {
            if (instance == null) {
                instance = new SmartApiTestManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void registerTestHelper(String appName, String targetServerName, AbstractApiTestHelper testHelper) {
        this.appTestHelpers.put(this.prepareKey(appName, targetServerName), testHelper);
    }

    public AbstractApiTestHelper getRegisteredTestHelper(String appName, String targetServerName) {
        AbstractApiTestHelper testHelper = this.appTestHelpers.get(this.prepareKey(appName, targetServerName));
        Assert.assertNotNull((Object)testHelper, (String)("No test helper registered with SmartApiTestManager class for appName = " + appName + " and targetServerName = " + targetServerName + ". This must be registered in cucumber step definition method that is annotated with @BeforeAll."));
        return testHelper.clone();
    }

    private String prepareKey(String appName, String targetServerName) {
        return appName + ":" + targetServerName;
    }
}

