/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.api.core.validator.xml;

import java.io.File;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.api.core.reader.XmlDocumentReader;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class XmlDocumentValidator {
    protected XmlDocumentReader xmlDocReader;
    protected XPath xPath;

    public XmlDocumentValidator(String xmlAsString) {
        this.xmlDocReader = new XmlDocumentReader(xmlAsString);
        this.xPath = XPathFactory.newInstance().newXPath();
    }

    public XmlDocumentValidator(File xmlFilePath) {
        this.xmlDocReader = new XmlDocumentReader(xmlFilePath);
        this.xPath = XPathFactory.newInstance().newXPath();
    }

    public Document getDocument() {
        return this.xmlDocReader.getDocument();
    }

    public NodeList findRecordsFor(String elementName, String xmlPath) throws XPathExpressionException {
        NodeList result = null;
        try {
            result = (NodeList)this.xPath.compile(xmlPath).evaluate(this.xmlDocReader.getDocument(), XPathConstants.NODESET);
        }
        catch (Exception e) {
            Assert.fail((String)("Element '" + elementName + "' has incorrect XML Path '" + xmlPath + "'."), (Throwable)e);
        }
        return result;
    }

    public void validatePathPresent(String elementName, String xmlPath) {
        NodeList result = null;
        try {
            result = (NodeList)this.xPath.compile(xmlPath).evaluate(this.xmlDocReader.getDocument(), XPathConstants.NODESET);
        }
        catch (Exception e) {
            Assert.fail((String)("Element '" + elementName + "' has incorrect XML Path '" + xmlPath + "'."), (Throwable)e);
        }
        Assert.assertNotNull((Object)result, (String)("Element '" + elementName + "' does not exist on XML Path '" + xmlPath + "'."));
        Assert.assertTrue((result.getLength() > 0 ? 1 : 0) != 0, (String)("Element '" + elementName + "' does not exist on XML Path '" + xmlPath + "'."));
    }

    public void validateExpectedNRecordsPresent(String elementName, String xmlPath, int expectedN) {
        NodeList result = null;
        try {
            result = (NodeList)this.xPath.compile(xmlPath).evaluate(this.xmlDocReader.getDocument(), XPathConstants.NODESET);
        }
        catch (Exception e) {
            Assert.fail((String)("Element '" + elementName + "' has incorrect XML Path '" + xmlPath + "'."), (Throwable)e);
        }
        Assert.assertNotNull((Object)result, (String)("Element '" + elementName + "' does not exist on XML Path '" + xmlPath + "'."));
        Assert.assertTrue((result.getLength() == expectedN ? 1 : 0) != 0, (String)("Element '" + elementName + "' does not have exact '" + expectedN + "' records on XML Path '" + xmlPath + "'. Found: " + result.getLength()));
    }

    public void validateAtleastNRecordsPresent(String elementName, String xmlPath, int atleastN) {
        NodeList result = null;
        try {
            result = (NodeList)this.xPath.compile(xmlPath).evaluate(this.xmlDocReader.getDocument(), XPathConstants.NODESET);
        }
        catch (Exception e) {
            Assert.fail((String)("Element '" + elementName + "' has incorrect XML Path '" + xmlPath + "'."), (Throwable)e);
        }
        Assert.assertNotNull((Object)result, (String)("Element '" + elementName + "' does not exist on XML Path '" + xmlPath + "'."));
        Assert.assertTrue((result.getLength() >= atleastN ? 1 : 0) != 0, (String)("Element '" + elementName + "' does not have atleast '" + atleastN + "' records on XML Path '" + xmlPath + "'. Found: " + result.getLength()));
    }

    public void validateAtMaxNRecordsPresent(String elementName, String xmlPath, int atMaxN) {
        NodeList result = null;
        try {
            result = (NodeList)this.xPath.compile(xmlPath).evaluate(this.xmlDocReader.getDocument(), XPathConstants.NODESET);
        }
        catch (Exception e) {
            Assert.fail((String)("Element '" + elementName + "' has incorrect XML Path '" + xmlPath + "'."), (Throwable)e);
        }
        Assert.assertNotNull((Object)result, (String)("Element '" + elementName + "' does not exist on XML Path '" + xmlPath + "'."));
        Assert.assertTrue((result.getLength() <= atMaxN ? 1 : 0) != 0, (String)("Element '" + elementName + "' have more records than expected('" + atMaxN + "') on XML Path '" + xmlPath + "'. Found: " + result.getLength()));
    }
}

