/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.file.reader;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.commons.Locations;
import org.uitnet.testing.smartfwk.ui.core.file.reader.support.Table;

public class CSVFileReader {
    private CSVFileReader() {
    }

    public static Table getData(String filePath) {
        return CSVFileReader.getData(filePath, ',', '\"', true);
    }

    public static Table getData(String filePath, char delimiter, char quoteChar, boolean trimCellData) {
        Assert.assertNotNull((Object)filePath, (String)"CSV file name cannot be empty.");
        filePath = Locations.getProjectRootDir() + File.separator + (String)filePath;
        Table table = new Table(CSVFileReader.extractFileName((String)filePath));
        try (FileReader fileReader = new FileReader((String)filePath);){
            CSVParser records = CSVFormat.DEFAULT.withAllowDuplicateHeaderNames(true).withQuote(quoteChar).withDelimiter(delimiter).withIgnoreEmptyLines(false).withIgnoreSurroundingSpaces().parse((Reader)fileReader);
            int rowCounter = 0;
            for (CSVRecord record : records) {
                ArrayList<String> row = new ArrayList<String>();
                if (record.size() == 1 && (table.getColumnNames().size() < 1 && "".equals(record.get(0).trim()) || table.getColumnNames().size() > 0)) {
                    ++rowCounter;
                    continue;
                }
                for (int i = 0; i < record.size(); ++i) {
                    String colValue = record.get(i);
                    row.add(colValue);
                }
                if (table.getColumnNames().size() == 0) {
                    List<String> dupCols = CSVFileReader.findDuplicates(row);
                    Assert.assertEquals((int)dupCols.size(), (int)0, (String)("Duplicate columns " + dupCols + " found in CSV file '" + (String)filePath + "'. Please remove invalid one."));
                    int emptyColIndex = row.indexOf("");
                    Assert.assertFalse((emptyColIndex >= 0 ? 1 : 0) != 0, (String)("Empty column name found at column number " + (emptyColIndex + 1) + " in CSV file '" + (String)filePath + "'. Please remove empty column name or give a valid name."));
                    table.addColumnNames(row);
                } else {
                    Assert.assertEquals((int)row.size(), (int)table.getColumnNames().size(), (String)("Column count " + table.getColumnNames().size() + " and record column count " + row.size() + " does not match on row " + (rowCounter + 1) + " within CSV file '" + (String)filePath + "'."));
                    table.addRow(row);
                }
                ++rowCounter;
            }
        }
        catch (Exception ex) {
            Assert.fail((String)("Failed to read CSV file '" + (String)filePath + "' data."), (Throwable)ex);
        }
        return table;
    }

    private static String extractFileName(String filePath) {
        String[] arr = new File(filePath).getName().split("[.]");
        return arr[0].trim();
    }

    private static List<String> findDuplicates(List<String> list) {
        return list.stream().distinct().filter(entry -> Collections.frequency(list, entry) > 1).collect(Collectors.toList());
    }
}

