/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.standard.imgobj;

import java.util.HashMap;
import java.util.Map;
import org.sikuli.script.Region;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.SmartCucumberUiScenarioContext;
import org.uitnet.testing.smartfwk.ui.core.appdriver.SmartAppDriver;
import org.uitnet.testing.smartfwk.ui.core.commons.LocatorType;
import org.uitnet.testing.smartfwk.ui.core.config.AppConfig;
import org.uitnet.testing.smartfwk.ui.core.config.ApplicationType;
import org.uitnet.testing.smartfwk.ui.core.config.PlatformType;
import org.uitnet.testing.smartfwk.ui.core.config.WebBrowserType;
import org.uitnet.testing.smartfwk.ui.core.objects.ObjectLocation;
import org.uitnet.testing.smartfwk.ui.core.objects.textbox.TextBox;
import org.uitnet.testing.smartfwk.ui.core.utils.LocatorUtil;
import org.uitnet.testing.smartfwk.ui.standard.imgobj.TextBoxValidatorSI;

public class TextBoxSI
extends TextBox {
    protected Map<String, String> leftSideImgs = new HashMap<String, String>();
    protected Map<String, String> rightSideImgs = new HashMap<String, String>();
    protected ObjectLocation location;
    protected boolean readOnly;
    protected boolean disabled;

    public TextBoxSI(String displayName, String leftSideImg, String rightSideImg, ObjectLocation location) {
        super(LocatorType.IMAGE, displayName);
        this.leftSideImgs.put("default-image", leftSideImg);
        this.rightSideImgs.put("default-image", rightSideImg);
        this.location = location;
        this.readOnly = false;
        this.disabled = false;
    }

    public TextBoxSI addPlatformImageForNativeApp(PlatformType platform, String leftSideImg, String rightSideImg) {
        LocatorUtil.setPlatformImageForNativeApp(this.leftSideImgs, platform, leftSideImg);
        LocatorUtil.setPlatformImageForNativeApp(this.rightSideImgs, platform, rightSideImg);
        return this;
    }

    public TextBoxSI addPlatformImageForWebApp(PlatformType platform, WebBrowserType browserType, String leftSideImg, String rightSideImg) {
        LocatorUtil.setPlatformImageForWebApp(this.leftSideImgs, platform, browserType, leftSideImg);
        LocatorUtil.setPlatformImageForWebApp(this.rightSideImgs, platform, browserType, rightSideImg);
        return this;
    }

    public String getLeftSideImage(PlatformType platform, ApplicationType appType, WebBrowserType browserType) {
        return LocatorUtil.findImage(this.leftSideImgs, platform, appType, browserType);
    }

    public String getRightSideImage(PlatformType platform, ApplicationType appType, WebBrowserType browserType) {
        return LocatorUtil.findImage(this.rightSideImgs, platform, appType, browserType);
    }

    public ObjectLocation getLocation() {
        return this.location;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public TextBoxSI setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public TextBoxSI setDisabled(boolean disabled) {
        this.disabled = disabled;
        return this;
    }

    @Override
    public TextBoxValidatorSI getValidator(SmartAppDriver appDriver, Region region) {
        return new TextBoxValidatorSI(appDriver, this, region);
    }

    @Override
    public TextBoxValidatorSI getValidator(SmartCucumberUiScenarioContext scenarioContext, Region region) {
        return this.getValidator(scenarioContext.getActiveAppDriver(), region);
    }

    @Override
    public TextBoxSI clone() {
        Assert.fail((String)"clone() API is not implemented.");
        return this;
    }

    @Override
    public TextBoxSI updateLocatorParameterWithValue(AppConfig appConfig, String paramName, String paramValue) {
        Assert.fail((String)"updateLocatorParameterWithValue() API is not implemented.");
        return this;
    }
}

