/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.api.core.defaults;

import java.util.HashMap;
import java.util.Map;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.api.core.AbstractApiTestHelper;
import org.uitnet.testing.smartfwk.api.core.ApiAuthenticationProvider;
import org.uitnet.testing.smartfwk.api.core.defaults.ApiTestManager;

public class SmartApiTestManager
implements ApiTestManager {
    private static SmartApiTestManager instance;
    private Map<String, AbstractApiTestHelper> appTestHelpers = new HashMap<String, AbstractApiTestHelper>();
    private Map<String, ApiAuthenticationProvider> appAuthProviders = new HashMap<String, ApiAuthenticationProvider>();

    private SmartApiTestManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SmartApiTestManager getInstance() {
        if (instance != null) {
            return instance;
        }
        Class<SmartApiTestManager> clazz = SmartApiTestManager.class;
        synchronized (SmartApiTestManager.class) {
            if (instance == null) {
                instance = new SmartApiTestManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void registerTestHelper(String appName, String targetServerName, AbstractApiTestHelper testHelper) {
        this.appTestHelpers.put(this.prepareKey(appName, targetServerName), testHelper);
    }

    @Override
    public AbstractApiTestHelper getRegisteredTestHelper(String appName, String targetServerName) {
        AbstractApiTestHelper testHelper = this.appTestHelpers.get(this.prepareKey(appName, targetServerName));
        Assert.assertNotNull((Object)testHelper, (String)("No test helper registered with SmartApiTestManager class for appName = " + appName + " and targetServerName = " + targetServerName + ". This must be registered in cucumber step definition method that is annotated with @BeforeAll."));
        AbstractApiTestHelper newTestHelper = testHelper.clone();
        newTestHelper.setApiTestManager(this);
        newTestHelper.setTargetServerName(targetServerName);
        return newTestHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApiAuthenticationProvider getAuthenticationProvider(String appName, String targetServerName, String userProfileName) {
        String mapKey = this.prepareAuthProviderMapKey(appName, targetServerName, userProfileName);
        ApiAuthenticationProvider authProvider = this.appAuthProviders.get(mapKey);
        if (authProvider != null) {
            return authProvider;
        }
        Class<SmartApiTestManager> clazz = SmartApiTestManager.class;
        synchronized (SmartApiTestManager.class) {
            authProvider = this.appAuthProviders.get(mapKey);
            if (authProvider != null) {
                // ** MonitorExit[var6_6] (shouldn't be in output)
                return authProvider;
            }
            authProvider = this.getRegisteredTestHelper(appName, targetServerName);
            this.appAuthProviders.put(mapKey, authProvider);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return authProvider;
        }
    }

    private String prepareAuthProviderMapKey(String appName, String targetServerName, String userProfileName) {
        return appName + ":" + targetServerName + ":" + userProfileName;
    }

    private String prepareKey(String appName, String targetServerName) {
        return appName + ":" + targetServerName;
    }

    public void close() {
        this.appTestHelpers.clear();
        for (ApiAuthenticationProvider aap : this.appAuthProviders.values()) {
            aap.logout();
        }
        this.appAuthProviders.clear();
    }
}

