/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.api.core.defaults;

import io.cucumber.java.Scenario;
import java.util.HashMap;
import java.util.Map;
import org.uitnet.testing.smartfwk.SmartCucumberScenarioContext;
import org.uitnet.testing.smartfwk.api.core.AbstractApiTestHelper;
import org.uitnet.testing.smartfwk.api.core.defaults.SingletonApiTestHelperMap;
import org.uitnet.testing.smartfwk.api.core.defaults.SmartApiTestManager;
import org.uitnet.testing.smartfwk.ui.core.config.ApiConfig;
import org.uitnet.testing.smartfwk.ui.core.config.AppConfig;
import org.uitnet.testing.smartfwk.ui.core.config.TestConfigManager;

public class SmartCucumberApiScenarioContext
implements SmartCucumberScenarioContext {
    private Map<String, Object> params = new HashMap<String, Object>(8);
    private Scenario scenario = null;
    private Map<String, AbstractApiTestHelper> appTestHelpers = this.getTestConfigManager().isParallelMode() ? new HashMap<String, AbstractApiTestHelper>() : SingletonApiTestHelperMap.getInstance().getMap();
    private String activeAppName = null;
    private String activeTargetServerName = null;

    @Override
    public Scenario getScenario() {
        return this.scenario;
    }

    @Override
    public void setScenario(Scenario scenario) {
        this.scenario = scenario;
    }

    public AbstractApiTestHelper getTestHelper(String appName, String targetServerName) {
        return this.appTestHelpers.get(this.prepareKey(appName, targetServerName));
    }

    public AbstractApiTestHelper switchTargetServer(String appName, String targetServerName, String userProfileName) {
        return this.login(appName, targetServerName, userProfileName);
    }

    public AbstractApiTestHelper login(String appName, String targetServerName, String userProfileName) {
        AbstractApiTestHelper testHelper = this.getTestHelper(appName, targetServerName);
        if (testHelper == null) {
            testHelper = SmartApiTestManager.getInstance().getRegisteredTestHelper(appName, targetServerName);
        }
        testHelper.setActiveProfileName(userProfileName);
        this.activeAppName = appName;
        this.activeTargetServerName = targetServerName;
        this.appTestHelpers.put(this.prepareKey(appName, targetServerName), testHelper);
        return testHelper;
    }

    @Override
    public String getActiveAppName() {
        return this.activeAppName;
    }

    public AbstractApiTestHelper setActiveUserProfile(String appName, String targetServerName, String userProfileName) {
        return this.login(appName, targetServerName, userProfileName);
    }

    public AbstractApiTestHelper setActiveUserProfileOnActiveAppAndTargetServer(String userProfileName) {
        return this.login(this.activeAppName, this.activeTargetServerName, userProfileName);
    }

    public AbstractApiTestHelper getActiveTestHelper() {
        return this.appTestHelpers.get(this.prepareKey(this.activeAppName, this.activeTargetServerName));
    }

    public String getActiveUserProfileNameOfActiveTestHelper() {
        return this.getActiveTestHelper().getActiveProfileName();
    }

    @Override
    public TestConfigManager getTestConfigManager() {
        return TestConfigManager.getInstance();
    }

    @Override
    public AppConfig getActiveAppConfig() {
        return this.getTestConfigManager().getAppConfig(this.activeAppName);
    }

    public ApiConfig getActiveAppApiConfig() {
        return this.getTestConfigManager().getAppConfig(this.activeAppName).getApiConfig();
    }

    @Override
    public AppConfig getAppConfig(String appName) {
        return this.getTestConfigManager().getAppConfig(appName);
    }

    @Override
    public void log(String message) {
        if (this.scenario != null) {
            this.scenario.log(message);
        }
    }

    @Override
    public void close() {
        for (AbstractApiTestHelper testHelpers : this.appTestHelpers.values()) {
            testHelpers.logout();
        }
        this.appTestHelpers.clear();
    }

    @Override
    public void addParamValue(String paramName, Object value) {
        this.params.put(paramName, value);
    }

    @Override
    public Object getParamValue(String paramName) {
        return this.params.get(paramName);
    }

    @Override
    public void removeParam(String paramName) {
        this.params.remove(paramName);
    }

    private String prepareKey(String appName, String targetServerName) {
        return appName + ":" + targetServerName;
    }
}

