/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.database;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.query.NativeQuery;
import org.uitnet.testing.smartfwk.database.AbstractDatabaseActionHandler;
import org.uitnet.testing.smartfwk.database.DatabaseConnection;
import org.uitnet.testing.smartfwk.ui.core.config.DatabaseProfile;
import org.uitnet.testing.smartfwk.ui.core.utils.JsonYamlUtil;

public class SqlDatabaseActionHandler
extends AbstractDatabaseActionHandler {
    public SqlDatabaseActionHandler(String appName, int sessionExpiryDurationInSeconds, DatabaseProfile databaseProfile) {
        super(appName, sessionExpiryDurationInSeconds, databaseProfile);
    }

    @Override
    public DatabaseConnection connect(DatabaseProfile dbProfile) {
        Map<String, Object> dbAdditionalProps = dbProfile.getAdditionalProps();
        Properties dbProps = new Properties();
        dbProps.putAll(dbAdditionalProps);
        Configuration hibernateCfg = new Configuration().addProperties(dbProps);
        SessionFactory hibernateSessionFactory = hibernateCfg.buildSessionFactory();
        DatabaseConnection connection = new DatabaseConnection(hibernateSessionFactory);
        return connection;
    }

    @Override
    public void disconnect(DatabaseConnection connection) {
        if (connection != null && connection.getConnection() != null) {
            try {
                ((SessionFactory)connection.getConnection()).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String getDataAsJsonString(DatabaseConnection connection, String entityName, String searchStatement) {
        try (Session hibSession = null;){
            Thread.sleep(5000L);
            hibSession = ((SessionFactory)connection.getConnection()).openSession();
            NativeQuery sqlQuery = hibSession.createSQLQuery(searchStatement);
            List foundRecords = sqlQuery.list();
            String string = JsonYamlUtil.convertObjectToJsonString(foundRecords);
            return string;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateData(DatabaseConnection connection, String entityName, String updateStatement) {
        Transaction txn = null;
        try (Session hibSession = null;){
            hibSession = ((SessionFactory)connection.getConnection()).openSession();
            txn = hibSession.beginTransaction();
            NativeQuery sqlQuery = hibSession.createSQLQuery(updateStatement);
            sqlQuery.executeUpdate();
            txn.commit();
            txn = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void deleteData(DatabaseConnection connection, String entityName, String deleteStatement) {
        Transaction txn = null;
        try (Session hibSession = null;){
            hibSession = ((SessionFactory)connection.getConnection()).openSession();
            txn = hibSession.beginTransaction();
            NativeQuery sqlQuery = hibSession.createSQLQuery(deleteStatement);
            sqlQuery.executeUpdate();
            txn.commit();
            txn = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void insertData(DatabaseConnection connection, String entityName, String insertStatement) {
        Transaction txn = null;
        try (Session hibSession = null;){
            hibSession = ((SessionFactory)connection.getConnection()).openSession();
            txn = hibSession.beginTransaction();
            NativeQuery sqlQuery = hibSession.createSQLQuery(insertStatement);
            sqlQuery.executeUpdate();
            txn.commit();
            txn = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void insertDataInBatch(DatabaseConnection connection, String entityName, List<String> insertStatements) {
        Transaction txn = null;
        try (Session hibSession = null;){
            hibSession = ((SessionFactory)connection.getConnection()).openSession();
            txn = hibSession.beginTransaction();
            hibSession.setJdbcBatchSize(Integer.valueOf(100));
            NativeQuery sqlQuery = null;
            for (String stmt : insertStatements) {
                sqlQuery = hibSession.createSQLQuery(stmt);
                sqlQuery.executeUpdate();
            }
            txn.commit();
            txn = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void create(DatabaseConnection connection, String entityName, String createStatement) {
        Transaction txn = null;
        try (Session hibSession = null;){
            hibSession = ((SessionFactory)connection.getConnection()).openSession();
            txn = hibSession.beginTransaction();
            hibSession.setJdbcBatchSize(Integer.valueOf(100));
            NativeQuery sqlQuery = null;
            sqlQuery = hibSession.createSQLQuery(createStatement);
            sqlQuery.executeUpdate();
            txn.commit();
            txn = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void drop(DatabaseConnection connection, String entityName, String dropStatement) {
        Transaction txn = null;
        try (Session hibSession = null;){
            hibSession = ((SessionFactory)connection.getConnection()).openSession();
            txn = hibSession.beginTransaction();
            hibSession.setJdbcBatchSize(Integer.valueOf(100));
            NativeQuery sqlQuery = null;
            sqlQuery = hibSession.createSQLQuery(dropStatement);
            sqlQuery.executeUpdate();
            txn.commit();
            txn = null;
        }
    }
}

