/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core;

import io.cucumber.java.Scenario;
import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WindowType;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.SmartCucumberScenarioContext;
import org.uitnet.testing.smartfwk.ui.core.AbstractAppConnector;
import org.uitnet.testing.smartfwk.ui.core.DefaultAppConnector;
import org.uitnet.testing.smartfwk.ui.core.SingletonAppConnectorMap;
import org.uitnet.testing.smartfwk.ui.core.appdriver.SmartAppDriver;
import org.uitnet.testing.smartfwk.ui.core.config.AppConfig;
import org.uitnet.testing.smartfwk.ui.core.config.TestConfigManager;
import org.uitnet.testing.smartfwk.ui.core.objects.UIObject;
import org.uitnet.testing.smartfwk.ui.core.utils.StringUtil;

public class SmartCucumberUiScenarioContext
implements SmartCucumberScenarioContext {
    private Map<String, Object> params = new HashMap<String, Object>(8);
    private Scenario scenario = null;
    private Map<String, AbstractAppConnector> appConnectors;
    private String activeAppName = null;

    public SmartCucumberUiScenarioContext() {
        if (this.getTestConfigManager().isParallelMode()) {
            this.appConnectors = new HashMap<String, AbstractAppConnector>();
        } else {
            this.appConnectors = SingletonAppConnectorMap.getInstance().getMap();
            this.activeAppName = SingletonAppConnectorMap.getInstance().getActiveAppName();
        }
    }

    @Override
    public Scenario getScenario() {
        return this.scenario;
    }

    @Override
    public void setScenario(Scenario scenario) {
        this.scenario = scenario;
    }

    public synchronized AbstractAppConnector connectOrSwitch(String appName) {
        AbstractAppConnector appConnector = this.appConnectors.get(appName);
        if (appConnector == null) {
            appConnector = new DefaultAppConnector(appName);
            appConnector.setActiveUserProfileName("DEFAULT-USER-PROFILE");
            this.appConnectors.put(appName, appConnector);
        }
        this.activeAppName = appName;
        return appConnector;
    }

    public SmartAppDriver connectOrSwitch(String appName, String userProfileName) {
        return this.setActiveUserProfile(appName, userProfileName);
    }

    public SmartAppDriver setActiveUserProfile(String appName, String userProfileName) {
        AbstractAppConnector appConnector = this.connectOrSwitch(appName);
        if (StringUtil.isEmptyAfterTrim(userProfileName)) {
            return appConnector.setActiveUserProfileName("DEFAULT-USER-PROFILE");
        }
        return appConnector.setActiveUserProfileName(userProfileName);
    }

    @Override
    public String getActiveAppName() {
        return this.activeAppName;
    }

    public SmartAppDriver setActiveUserProfileOnActiveApp(String userProfileName) {
        return this.setActiveUserProfile(this.activeAppName, userProfileName);
    }

    public String getActiveUserProfileNameOfActiveApp() {
        return this.getActiveAppConnector().getActiveUserProfileName();
    }

    public String getActiveUserProfileName(String appName) {
        return this.getAppConnector(appName).getActiveUserProfileName();
    }

    public SmartAppDriver getActiveAppDriver() {
        return this.appConnectors.get(this.activeAppName).getAppDriver();
    }

    public SmartAppDriver getAppDriver(String appName) {
        return this.appConnectors.get(appName).getAppDriver();
    }

    public AbstractAppConnector getActiveAppConnector() {
        return this.appConnectors.get(this.activeAppName);
    }

    public AbstractAppConnector getAppConnector(String appName) {
        return this.appConnectors.get(appName);
    }

    public void captureScreenshot() {
        if (this.appConnectors.get(this.activeAppName) != null) {
            this.appConnectors.get(this.activeAppName).captureScreenshot(this.scenario);
        }
    }

    public void captureScreenshot(String fileNameHint) {
        if (this.appConnectors.get(this.activeAppName) != null) {
            this.appConnectors.get(this.activeAppName).captureScreenshot(fileNameHint);
        }
    }

    public void captureScreenshotWithScenarioStatus(String status) {
        if (this.appConnectors.get(this.activeAppName) != null) {
            this.appConnectors.get(this.activeAppName).captureScreenshot(this.scenario, status);
        }
    }

    public void captureScreenshotOfApp(String appName) {
        if (this.appConnectors.get(appName) != null) {
            this.appConnectors.get(appName).captureScreenshot(this.scenario);
        }
    }

    public void captureScreenshotOfAppWithScenarioStatus(String appName, String status) {
        if (this.appConnectors.get(appName) != null) {
            this.appConnectors.get(appName).captureScreenshot(this.scenario, status);
        }
    }

    @Override
    public TestConfigManager getTestConfigManager() {
        return TestConfigManager.getInstance();
    }

    @Override
    public AppConfig getActiveAppConfig() {
        return this.getTestConfigManager().getAppConfig(this.activeAppName);
    }

    @Override
    public AppConfig getAppConfig(String appName) {
        return this.getTestConfigManager().getAppConfig(appName);
    }

    @Override
    public void log(String message) {
        this.scenario.log(message);
    }

    public void switchToDefaultContent() {
        for (AbstractAppConnector connector : this.appConnectors.values()) {
            connector.getAppDriver().getWebDriver().switchTo().defaultContent();
        }
    }

    public void switchToDefaultContent(String appName) {
        try {
            this.appConnectors.get(appName).getAppDriver().getWebDriver().switchTo().defaultContent();
        }
        catch (Error | Exception e) {
            Assert.fail((String)("Failed to switch '" + appName + "' app to default content."), (Throwable)e);
        }
    }

    public void switchToWindow(String nameOrHandle) {
        this.appConnectors.get(this.activeAppName).getAppDriver().getWebDriver().switchTo().window(nameOrHandle);
    }

    public void switchToWindow(String appName, String nameOrHandle) {
        this.appConnectors.get(appName).getAppDriver().getWebDriver().switchTo().window(nameOrHandle);
    }

    public void switchToFrame(String nameOrId) {
        this.appConnectors.get(this.activeAppName).getAppDriver().getWebDriver().switchTo().frame(nameOrId);
    }

    public void switchToFrame(UIObject pageElement) {
        this.appConnectors.get(this.activeAppName).getAppDriver().getWebDriver().switchTo().frame((WebElement)pageElement.getValidator(this.getActiveAppDriver(), null).findElement(2));
    }

    public void switchToFrame(int index) {
        this.appConnectors.get(this.activeAppName).getAppDriver().getWebDriver().switchTo().frame(index);
    }

    public void switchToNewWindow(WindowType typeHint) {
        this.appConnectors.get(this.activeAppName).getAppDriver().getWebDriver().switchTo().newWindow(typeHint);
    }

    public void closeAllChildWindows() {
        for (AbstractAppConnector connector : this.appConnectors.values()) {
            connector.getAppDriver().closeChildWindows();
        }
    }

    public void waitForSeconds(int seconds) {
        SmartAppDriver driver = this.getActiveAppDriver();
        if (driver != null) {
            driver.waitForSeconds(seconds);
        }
    }

    @Override
    public void close() {
        if (this.getTestConfigManager().isParallelMode()) {
            for (AbstractAppConnector connector : this.appConnectors.values()) {
                connector.logoutAndQuit();
            }
            this.appConnectors.clear();
        }
    }

    @Override
    public void addParamValue(String paramName, Object value) {
        this.params.put(paramName, value);
    }

    @Override
    public Object getParamValue(String paramName) {
        return this.params.get(paramName);
    }

    @Override
    public void removeParam(String paramName) {
        this.params.remove(paramName);
    }
}

