/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.objects;

import java.util.HashMap;
import java.util.Map;
import org.sikuli.script.Region;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.SmartCucumberUiScenarioContext;
import org.uitnet.testing.smartfwk.ui.core.appdriver.SmartAppDriver;
import org.uitnet.testing.smartfwk.ui.core.commons.LocatorType;
import org.uitnet.testing.smartfwk.ui.core.commons.UIObjectType;
import org.uitnet.testing.smartfwk.ui.core.config.AppConfig;
import org.uitnet.testing.smartfwk.ui.core.config.ApplicationType;
import org.uitnet.testing.smartfwk.ui.core.config.PlatformType;
import org.uitnet.testing.smartfwk.ui.core.config.WebBrowserType;
import org.uitnet.testing.smartfwk.ui.core.objects.ImageObjectValidator;
import org.uitnet.testing.smartfwk.ui.core.objects.UIObject;
import org.uitnet.testing.smartfwk.ui.core.utils.LocatorUtil;

public class ImageObject
extends UIObject {
    protected Map<String, String> platformImages = new HashMap<String, String>();

    public ImageObject(UIObjectType elemType, String displayName, String image) {
        super(LocatorType.IMAGE, elemType, displayName);
        this.platformImages.put("default-image", image);
    }

    public ImageObject(UIObjectType elemType, String displayName, Map<String, String> platformImages) {
        super(LocatorType.IMAGE, elemType, displayName);
        this.platformImages = platformImages;
    }

    public ImageObject addPlatformImageForNativeApp(PlatformType platform, String image) {
        LocatorUtil.setPlatformImageForNativeApp(this.platformImages, platform, image);
        return this;
    }

    public ImageObject addPlatformImageForWebApp(PlatformType platform, WebBrowserType browserType, String image) {
        LocatorUtil.setPlatformImageForWebApp(this.platformImages, platform, browserType, image);
        return this;
    }

    @Override
    public ImageObjectValidator getValidator(SmartAppDriver appDriver, Region region) {
        return new ImageObjectValidator(appDriver, this, region);
    }

    @Override
    public ImageObjectValidator getValidator(SmartCucumberUiScenarioContext scenarioContext, Region region) {
        return this.getValidator(scenarioContext.getActiveAppDriver(), region);
    }

    public String getImage(PlatformType platform, ApplicationType appType, WebBrowserType browserType) {
        return LocatorUtil.findImage(this.platformImages, platform, appType, browserType);
    }

    @Override
    public UIObject clone() {
        return new ImageObject(this.uiObjectType, this.getDisplayName(), this.platformImages);
    }

    @Override
    public ImageObject updateLocatorParameterWithValue(AppConfig appConfig, String paramName, String paramValue) {
        Assert.fail((String)"updateLocatorParameterWithValue() API is not implemented.");
        return this;
    }
}

