/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.utils;

import java.util.List;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.uitnet.testing.smartfwk.ui.core.appdriver.SmartAppDriver;

public class DragAndDropUtil {
    private DragAndDropUtil() {
    }

    public static void dragAndDropElement(WebElement sourceElement, WebElement targetElement, SmartAppDriver appDriver) {
        Actions action = new Actions(appDriver.getWebDriver());
        action.dragAndDrop(sourceElement, targetElement).build().perform();
    }

    public static void dragAndDropElements(List<WebElement> sourceElements, WebElement targetElement, SmartAppDriver appDriver) {
        for (WebElement webElem : sourceElements) {
            Actions action = new Actions(appDriver.getWebDriver());
            action.dragAndDrop(webElem, targetElement).build().perform();
        }
    }

    public static void dragAndDropFileOnFileInput(String absFilePath, WebElement fileInputElement, SmartAppDriver appDriver) {
        fileInputElement.sendKeys(new CharSequence[]{absFilePath});
    }
}

