/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.testng.Assert;

public class ObjectUtil {
    public static Constructor<?> findClassConstructor(Class<?> clazz, Class<?>[] argTypes) {
        Constructor<?> foundConstructor = null;
        try {
            Constructor<?>[] constructors = clazz.getConstructors();
            if (argTypes == null) {
                argTypes = new Class[]{};
            }
            boolean found = false;
            for (Constructor<?> m : constructors) {
                foundConstructor = null;
                if (m.getParameterCount() != argTypes.length) continue;
                Class<?>[] paramTypes = m.getParameterTypes();
                Class<?> paramType = null;
                found = true;
                for (int i = 0; i < paramTypes.length; ++i) {
                    paramType = paramTypes[i];
                    if (paramType.getTypeName().equals(argTypes[i].getTypeName())) continue;
                    found = false;
                    break;
                }
                if (!found) continue;
                foundConstructor = m;
                break;
            }
        }
        catch (Exception ex) {
            Assert.fail((String)("Failed to find constructor in class '" + clazz.getName() + "'."), (Throwable)ex);
        }
        if (foundConstructor == null) {
            Assert.fail((String)("Failed to find constructor in class '" + clazz.getName() + "'."));
        }
        return foundConstructor;
    }

    public static Method findClassMethod(Class<?> clazz, String methodName, Class<?>[] argTypes) {
        Method foundMethod = null;
        try {
            Method[] methods = clazz.getMethods();
            boolean found = false;
            for (Method m : methods) {
                foundMethod = null;
                if (!m.getName().equals(methodName) || m.getParameterCount() != argTypes.length) continue;
                Class<?>[] paramTypes = m.getParameterTypes();
                Class<?> paramType = null;
                found = true;
                for (int i = 0; i < paramTypes.length; ++i) {
                    paramType = paramTypes[i];
                    if (paramType.getTypeName().equals(argTypes[i].getTypeName())) continue;
                    found = false;
                    break;
                }
                if (!found) continue;
                foundMethod = m;
                break;
            }
        }
        catch (Exception ex) {
            Assert.fail((String)("Failed to find '" + methodName + "' method in class '" + clazz.getName() + "'."), (Throwable)ex);
        }
        if (foundMethod == null) {
            Assert.fail((String)("Failed to find '" + methodName + "' method in class '" + clazz.getName() + "'."));
        }
        return foundMethod;
    }

    public static Object invokeMethod(Object clazzObj, Method m, Object[] argValues) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object out = null;
        out = m.invoke(clazzObj, argValues);
        return out;
    }
}

