/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.api.core.defaults;

import io.cucumber.java.Scenario;
import java.util.HashMap;
import java.util.Map;
import org.uitnet.testing.smartfwk.SmartCucumberScenarioContext;
import org.uitnet.testing.smartfwk.api.core.AbstractApiActionHandler;
import org.uitnet.testing.smartfwk.api.core.defaults.SingletonApiActionHandlerMap;
import org.uitnet.testing.smartfwk.api.core.defaults.SmartApiTestManager;
import org.uitnet.testing.smartfwk.ui.core.config.ApiConfig;
import org.uitnet.testing.smartfwk.ui.core.config.AppConfig;
import org.uitnet.testing.smartfwk.ui.core.config.TestConfigManager;

public class SmartCucumberApiScenarioContext
implements SmartCucumberScenarioContext {
    private Map<String, Object> params = new HashMap<String, Object>(8);
    private Scenario scenario = null;
    private Map<String, AbstractApiActionHandler> appActionHandlers = this.getTestConfigManager().isParallelMode() ? new HashMap<String, AbstractApiActionHandler>() : SingletonApiActionHandlerMap.getInstance().getMap();
    private String activeAppName = null;
    private String activeTargetServerName = null;

    @Override
    public Scenario getScenario() {
        return this.scenario;
    }

    @Override
    public void setScenario(Scenario scenario) {
        this.scenario = scenario;
    }

    public AbstractApiActionHandler getActionHandler(String appName, String targetServerName) {
        return this.appActionHandlers.get(this.prepareKey(appName, targetServerName));
    }

    public AbstractApiActionHandler switchTargetServer(String appName, String targetServerName, String userProfileName) {
        return this.login(appName, targetServerName, userProfileName);
    }

    public AbstractApiActionHandler login(String appName, String targetServerName, String userProfileName) {
        AbstractApiActionHandler actionHandler = this.getActionHandler(appName, targetServerName);
        if (actionHandler == null) {
            actionHandler = SmartApiTestManager.getInstance().getActionHandler(appName, targetServerName);
        }
        actionHandler.setActiveProfileName(userProfileName);
        this.activeAppName = appName;
        this.activeTargetServerName = targetServerName;
        this.appActionHandlers.put(this.prepareKey(appName, targetServerName), actionHandler);
        return actionHandler;
    }

    @Override
    public String getActiveAppName() {
        return this.activeAppName;
    }

    public AbstractApiActionHandler setActiveUserProfile(String appName, String targetServerName, String userProfileName) {
        return this.login(appName, targetServerName, userProfileName);
    }

    public AbstractApiActionHandler setActiveUserProfileOnActiveAppAndTargetServer(String userProfileName) {
        return this.login(this.activeAppName, this.activeTargetServerName, userProfileName);
    }

    public AbstractApiActionHandler getActiveActionHandler() {
        return this.appActionHandlers.get(this.prepareKey(this.activeAppName, this.activeTargetServerName));
    }

    public String getActiveUserProfileNameOfActiveActionHandler() {
        return this.getActiveActionHandler().getActiveProfileName();
    }

    @Override
    public TestConfigManager getTestConfigManager() {
        return TestConfigManager.getInstance();
    }

    @Override
    public AppConfig getActiveAppConfig() {
        return this.getTestConfigManager().getAppConfig(this.activeAppName);
    }

    public ApiConfig getActiveAppApiConfig() {
        return this.getTestConfigManager().getAppConfig(this.activeAppName).getApiConfig();
    }

    @Override
    public AppConfig getAppConfig(String appName) {
        return this.getTestConfigManager().getAppConfig(appName);
    }

    @Override
    public void log(String message) {
        if (this.scenario != null) {
            this.scenario.log(message);
        }
    }

    @Override
    public void close() {
        if (this.getTestConfigManager().isParallelMode()) {
            for (AbstractApiActionHandler actionHandlers : this.appActionHandlers.values()) {
                actionHandlers.logout();
            }
            this.appActionHandlers.clear();
        }
    }

    @Override
    public void addParamValue(String paramName, Object value) {
        this.params.put(paramName, value);
    }

    @Override
    public Object getParamValue(String paramName) {
        return this.params.get(paramName);
    }

    @Override
    public Object getParamValueNullAsParamName(String paramName) {
        Object val = this.params.get(paramName);
        if (val == null) {
            return paramName;
        }
        return val;
    }

    @Override
    public void removeParam(String paramName) {
        this.params.remove(paramName);
    }

    @Override
    public String applyParamsValueOnText(String text) {
        for (Map.Entry<String, Object> e : this.params.entrySet()) {
            text = text.replace(e.getKey(), "" + e.getValue());
        }
        return text;
    }

    private String prepareKey(String appName, String targetServerName) {
        return appName + ":" + targetServerName;
    }
}

