/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.api.core.reader;

import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.core.json.JsonWriteFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.TypeRef;
import com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.io.File;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.testng.Assert;

public class JsonDocumentReader {
    protected DocumentContext jsonDocCtx;

    public JsonDocumentReader(File jsonFilePath) {
        try {
            this.init();
            Assert.assertNotNull((Object)jsonFilePath, (String)"JSON file path cannot be null.");
            ObjectMapper objectMapper = this.createObjectMapper();
            JacksonJsonProvider provider = new JacksonJsonProvider(objectMapper);
            this.jsonDocCtx = JsonPath.using((Configuration)Configuration.builder().jsonProvider((JsonProvider)provider).build()).parse(jsonFilePath);
        }
        catch (Exception ex) {
            Assert.fail((String)"Failed to parse JSON document.", (Throwable)ex);
        }
    }

    public JsonDocumentReader(String jsonAsString) {
        try {
            this.init();
            Assert.assertNotNull((Object)jsonAsString, (String)"JSON document cannot be null.");
            Assert.assertNotEquals((Object)jsonAsString.trim(), (Object)"", (String)"JSON document cannot be empty.");
            ObjectMapper objectMapper = this.createObjectMapper();
            JacksonJsonProvider provider = new JacksonJsonProvider(objectMapper);
            this.jsonDocCtx = JsonPath.using((Configuration)Configuration.builder().jsonProvider((JsonProvider)provider).build()).parse(jsonAsString);
        }
        catch (Exception ex) {
            Assert.fail((String)"Failed to parse JSON document.", (Throwable)ex);
        }
    }

    public DocumentContext prepareDocumentContext(Object obj) {
        try {
            ObjectMapper objectMapper = this.createObjectMapper();
            JacksonJsonProvider provider = new JacksonJsonProvider(objectMapper);
            return JsonPath.using((Configuration)Configuration.builder().jsonProvider((JsonProvider)provider).build()).parse(this.createObjectMapper().writeValueAsString(obj));
        }
        catch (Exception ex) {
            Assert.fail((String)"Failed to covert object into DocumentContext.", (Throwable)ex);
            return null;
        }
    }

    public DocumentContext getDocumentContext() {
        return this.jsonDocCtx;
    }

    public <T> List<T> readValuesAsList(String jsonPath) {
        TypeRef typeRef = new TypeRef<List<T>>(){};
        return (List)this.jsonDocCtx.read(jsonPath, typeRef);
    }

    public <T> Set<T> readValuesAsSet(String jsonPath) {
        TypeRef typeRef = new TypeRef<Set<T>>(){};
        return (Set)this.jsonDocCtx.read(jsonPath, typeRef);
    }

    public <T> T readSingleValue(String jsonPath) {
        TypeRef typeRef = new TypeRef<T>(){};
        return (T)this.jsonDocCtx.read(jsonPath, typeRef);
    }

    public <T> T readValueAsObject(String yamlPath, Class<T> clazz) {
        try {
            Object obj = this.jsonDocCtx.read(yamlPath, Object.class, new Predicate[0]);
            ObjectMapper omapper = this.createObjectMapper();
            String jsonStr = omapper.writeValueAsString(obj);
            omapper = this.createObjectMapper();
            return (T)omapper.readValue(jsonStr, clazz);
        }
        catch (Exception ex) {
            Assert.fail((String)("Failed to read yaml path " + yamlPath + " as class object."), (Throwable)ex);
            return null;
        }
    }

    protected ObjectMapper createObjectMapper() {
        ObjectMapper objectMapper = JsonMapper.builder().enable(new JsonReadFeature[]{JsonReadFeature.ALLOW_SINGLE_QUOTES}).enable(new JsonReadFeature[]{JsonReadFeature.ALLOW_UNQUOTED_FIELD_NAMES}).disable(new JsonWriteFeature[]{JsonWriteFeature.QUOTE_FIELD_NAMES}).build();
        return objectMapper;
    }

    protected void init() {
        Configuration.setDefaults((Configuration.Defaults)new Configuration.Defaults(){
            private ObjectMapper objectMapper;
            {
                this.objectMapper = JsonDocumentReader.this.createObjectMapper();
            }

            public JsonProvider jsonProvider() {
                JacksonJsonProvider jsonProvider = new JacksonJsonProvider(this.objectMapper);
                return jsonProvider;
            }

            public MappingProvider mappingProvider() {
                return new JacksonMappingProvider(this.objectMapper);
            }

            public Set<Option> options() {
                return EnumSet.noneOf(Option.class);
            }
        });
    }
}

