/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.api.core.support;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.TypeRef;
import java.util.HashMap;
import java.util.Map;

public class PageObjectInfo {
    private String poClassName;
    private String poObjectName;
    private DocumentContext jsonParams;

    public PageObjectInfo(String poClassName, String poObjectName, DocumentContext jsonParams) {
        this.poClassName = poClassName;
        this.poObjectName = poObjectName;
        this.jsonParams = jsonParams;
    }

    public String getPoClassName() {
        return this.poClassName;
    }

    public void setPoClassName(String poClassName) {
        this.poClassName = poClassName;
    }

    public String getPoObjectName() {
        return this.poObjectName;
    }

    public void setPoObjectName(String poObjectName) {
        this.poObjectName = poObjectName;
    }

    public DocumentContext getJsonParams() {
        return this.jsonParams;
    }

    public void setJsonParams(DocumentContext jsonParams) {
        this.jsonParams = jsonParams;
    }

    public int getMaxIterationsToLocateElements() {
        Integer maxTimeToWaitInSeconds = 4;
        if (this.jsonParams != null) {
            try {
                maxTimeToWaitInSeconds = (Integer)this.jsonParams.read("$.maxTimeToWaitInSeconds", new Predicate[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (maxTimeToWaitInSeconds == null) {
                maxTimeToWaitInSeconds = 4;
            }
        }
        if (maxTimeToWaitInSeconds < 0) {
            maxTimeToWaitInSeconds = 0;
        }
        return Double.valueOf(Math.floor(maxTimeToWaitInSeconds / 2)).intValue();
    }

    public Map<String, String> getLocatorParams() {
        if (this.jsonParams != null) {
            try {
                Map params = (Map)this.jsonParams.read("$.locatorParams", (TypeRef)new TypeRef<Map<String, String>>(){});
                if (params != null) {
                    return params;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new HashMap<String, String>();
    }
}

