/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.database;

import com.jayway.jsonpath.DocumentContext;
import java.util.Calendar;
import java.util.List;
import org.uitnet.testing.smartfwk.api.core.reader.JsonDocumentReader;
import org.uitnet.testing.smartfwk.common.MethodArg;
import org.uitnet.testing.smartfwk.common.ReturnType;
import org.uitnet.testing.smartfwk.database.DatabaseConnection;
import org.uitnet.testing.smartfwk.database.DatabaseConnectionProvider;
import org.uitnet.testing.smartfwk.ui.core.config.DatabaseProfile;

public abstract class AbstractDatabaseActionHandler
implements DatabaseConnectionProvider {
    protected String appName;
    protected DatabaseProfile activeDatabaseProfile;
    protected int sessionExpiryDurationInSeconds;
    protected long lastRequestAccessTimeInMs;
    protected DatabaseConnection connection;

    public AbstractDatabaseActionHandler(String appName, int sessionExpiryDurationInSeconds, DatabaseProfile databaseProfile) {
        this.appName = appName;
        this.sessionExpiryDurationInSeconds = sessionExpiryDurationInSeconds;
        this.activeDatabaseProfile = databaseProfile;
    }

    private synchronized void verifyDatabaseConnection() {
        if (this.connection == null || this.isSessionExpired()) {
            this.disconnect();
            this.connection = this.connect(this.activeDatabaseProfile);
        } else {
            this.lastRequestAccessTimeInMs = Calendar.getInstance().getTimeInMillis();
        }
    }

    protected boolean isSessionExpired() {
        long currTimeInMs = Calendar.getInstance().getTimeInMillis();
        long durationInSeconds = (currTimeInMs - this.lastRequestAccessTimeInMs) / 1000L;
        return durationInSeconds >= (long)this.sessionExpiryDurationInSeconds;
    }

    public String getDataAsJsonString(String entityName, String searchStatement) {
        this.verifyDatabaseConnection();
        return this.getDataAsJsonString(this.connection, entityName, searchStatement);
    }

    public DocumentContext getDataAsJsonDocument(String entityName, String searchStatement) {
        String jsonData = this.getDataAsJsonString(entityName, searchStatement);
        JsonDocumentReader reader = new JsonDocumentReader(jsonData);
        return reader.getDocumentContext();
    }

    public void updateData(String entityName, String updateStatement) {
        this.verifyDatabaseConnection();
        this.updateData(this.connection, entityName, updateStatement);
    }

    public void deleteData(String entityName, String deleteStatement) {
        this.verifyDatabaseConnection();
        this.deleteData(this.connection, entityName, deleteStatement);
    }

    public void insertData(String entityName, String insertStatement) {
        this.verifyDatabaseConnection();
        this.insertData(this.connection, entityName, insertStatement);
    }

    public void insertDataInBatch(String entityName, List<String> insertStatements) {
        this.verifyDatabaseConnection();
        this.insertDataInBatch(this.connection, entityName, insertStatements);
    }

    public void create(String entityName, String createStatement) {
        this.verifyDatabaseConnection();
        this.create(this.connection, entityName, createStatement);
    }

    public void drop(String entityName, String dropStatement) {
        this.verifyDatabaseConnection();
        this.drop(this.connection, entityName, dropStatement);
    }

    public DocumentContext executeFunction(String functionName, ReturnType returnType, Object ... args) {
        this.verifyDatabaseConnection();
        String jsonData = this.executeFunctionReturnAsJson(functionName, returnType, args);
        JsonDocumentReader reader = new JsonDocumentReader(jsonData);
        return reader.getDocumentContext();
    }

    public DocumentContext executeProcedure(String procedureName, MethodArg<?> ... args) {
        this.verifyDatabaseConnection();
        String jsonData = this.executeProcedureReturnAsJson(procedureName, args);
        JsonDocumentReader reader = new JsonDocumentReader(jsonData);
        return reader.getDocumentContext();
    }

    @Override
    public synchronized void disconnect() {
        if (this.connection != null) {
            this.disconnect(this.connection);
            this.connection = null;
        }
    }

    protected abstract void disconnect(DatabaseConnection var1);

    protected abstract String getDataAsJsonString(DatabaseConnection var1, String var2, String var3);

    protected abstract void updateData(DatabaseConnection var1, String var2, String var3);

    protected abstract void deleteData(DatabaseConnection var1, String var2, String var3);

    protected abstract void insertData(DatabaseConnection var1, String var2, String var3);

    protected abstract void insertDataInBatch(DatabaseConnection var1, String var2, List<String> var3);

    protected abstract String executeFunctionReturnAsJson(String var1, ReturnType var2, Object ... var3);

    protected abstract String executeProcedureReturnAsJson(String var1, MethodArg<?> ... var2);

    protected abstract void create(DatabaseConnection var1, String var2, String var3);

    protected abstract void drop(DatabaseConnection var1, String var2, String var3);
}

