/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.appdriver;

import com.jayway.jsonpath.DocumentContext;
import io.appium.java_client.android.AndroidDriver;
import io.appium.java_client.ios.IOSDriver;
import io.appium.java_client.mac.Mac2Driver;
import io.appium.java_client.windows.WindowsDriver;
import java.io.File;
import java.net.URI;
import java.time.Duration;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.edge.EdgeDriverService;
import org.openqa.selenium.edge.EdgeOptions;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxDriverLogLevel;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.ie.InternetExplorerDriverService;
import org.openqa.selenium.ie.InternetExplorerOptions;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.service.DriverService;
import org.openqa.selenium.safari.SafariDriver;
import org.openqa.selenium.safari.SafariDriverService;
import org.openqa.selenium.safari.SafariOptions;
import org.sikuli.script.Screen;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.appdriver.AppIdGenerator;
import org.uitnet.testing.smartfwk.ui.core.config.AppConfig;
import org.uitnet.testing.smartfwk.ui.core.config.AppDriverConfig;
import org.uitnet.testing.smartfwk.ui.core.config.ApplicationType;
import org.uitnet.testing.smartfwk.ui.core.config.PlatformType;
import org.uitnet.testing.smartfwk.ui.core.config.ProxyConfiguration;
import org.uitnet.testing.smartfwk.ui.core.config.TestConfigManager;
import org.uitnet.testing.smartfwk.ui.core.handler.DefaultScrollElementToViewportHandler;
import org.uitnet.testing.smartfwk.ui.core.handler.ScrollElementToViewportHandler;
import org.uitnet.testing.smartfwk.ui.core.utils.StringUtil;

public class SmartAppDriver {
    private int appId = AppIdGenerator.getInstance().nextValue();
    private String appName;
    private ApplicationType appType;
    private PlatformType testPlatformType;
    private WebDriver webDriver;
    private Screen sikuliDriver;
    private AppConfig appConfig;
    private boolean opened = false;
    private ScrollElementToViewportHandler scrollElemToViewportCallback;
    private String originalWindowHandle;
    private boolean shouldOpenURL = true;
    private DocumentContext overriddenDriverProps = null;

    public SmartAppDriver(String appName, ApplicationType appType, PlatformType testPlatformType) {
        this.appName = appName;
        this.appType = appType;
        this.testPlatformType = testPlatformType;
        this.sikuliDriver = new Screen();
        this.appConfig = TestConfigManager.getInstance().getAppConfig(appName);
    }

    public void setScrollElementToViewportHandler(ScrollElementToViewportHandler handler) {
        this.scrollElemToViewportCallback = handler;
    }

    public ScrollElementToViewportHandler getScrollElementToViewportHandler() {
        return this.scrollElemToViewportCallback;
    }

    public void overrideDriverProps(DocumentContext jsonProps) {
        this.overriddenDriverProps = jsonProps;
    }

    public WebDriver openAppIfNotOpened(String userProfileName) {
        this.shouldOpenURL = !StringUtil.isEmptyAfterTrim(userProfileName) && !userProfileName.equals("DEFAULT-USER-PROFILE");
        if (!this.opened) {
            this.prepareWebDriver();
            this.opened = true;
        } else if (this.appType == ApplicationType.web_app) {
            this.webDriver.get(this.appConfig.getAppLaunchUrl());
        }
        return this.webDriver;
    }

    private void prepareWebDriver() {
        this.scrollElemToViewportCallback = new DefaultScrollElementToViewportHandler();
        if (this.testPlatformType == PlatformType.windows) {
            if (this.appType == ApplicationType.native_app) {
                this.prepareWindowsNativeAppDriver();
            } else if (this.appType == ApplicationType.web_app) {
                this.prepareWebAppDriverForNonMobileApp();
            }
        } else if (this.testPlatformType == PlatformType.linux) {
            if (this.appType == ApplicationType.native_app) {
                Assert.fail((String)"Automation for native app on linux platform is not supported.");
            } else if (this.appType == ApplicationType.web_app) {
                this.prepareWebAppDriverForNonMobileApp();
            }
        } else if (this.testPlatformType == PlatformType.mac) {
            if (this.appType == ApplicationType.native_app) {
                this.prepareMacNativeAppDriver();
            } else if (this.appType == ApplicationType.web_app) {
                this.prepareWebAppDriverForNonMobileApp();
            }
        } else if (this.testPlatformType == PlatformType.android_mobile) {
            if (this.appType == ApplicationType.native_app) {
                this.prepareAndroidMobileAppDriver();
            } else if (this.appType == ApplicationType.web_app) {
                this.prepareAndroidMobileAppDriver();
            }
        } else if (this.testPlatformType == PlatformType.ios_mobile) {
            if (this.appType == ApplicationType.native_app) {
                this.prepareIosMobileAppDriver();
            } else if (this.appType == ApplicationType.web_app) {
                this.prepareIosMobileAppDriver();
            }
        }
        if (this.webDriver != null && this.appType == ApplicationType.web_app) {
            this.originalWindowHandle = this.webDriver.getWindowHandle();
        }
    }

    private void prepareWindowsNativeAppDriver() {
        AppDriverConfig webDriverCfg = this.appConfig.getAppDriverConfig().getUpdatedProperties(this.overriddenDriverProps);
        DesiredCapabilities capabilities = new DesiredCapabilities();
        capabilities.setAcceptInsecureCerts(webDriverCfg.isAcceptInsecureCertificates());
        for (Map.Entry<String, Object> entry : webDriverCfg.getDriverCapabilities().entrySet()) {
            capabilities.setCapability(entry.getKey(), entry.getValue());
        }
        try {
            this.webDriver = new WindowsDriver(new URI(webDriverCfg.getRemoteDriverURL()).toURL(), (Capabilities)capabilities);
        }
        catch (Exception ex) {
            Assert.fail((String)"Failed to initialize windows driver.", (Throwable)ex);
        }
    }

    private void prepareAndroidMobileAppDriver() {
        AppDriverConfig webDriverCfg = this.appConfig.getAppDriverConfig().getUpdatedProperties(this.overriddenDriverProps);
        DesiredCapabilities capabilities = new DesiredCapabilities();
        capabilities.setAcceptInsecureCerts(webDriverCfg.isAcceptInsecureCertificates());
        for (Map.Entry<String, Object> entry : webDriverCfg.getDriverCapabilities().entrySet()) {
            if ("app".equals(entry.getKey()) && !("" + entry.getValue()).startsWith("http:") && !("" + entry.getValue()).startsWith("https:")) {
                capabilities.setCapability(entry.getKey(), this.appConfig.getAppsConfigDir() + File.separator + this.appConfig.getAppName() + File.separator + entry.getValue());
                continue;
            }
            capabilities.setCapability(entry.getKey(), entry.getValue());
        }
        try {
            this.webDriver = new AndroidDriver(new URI(webDriverCfg.getRemoteDriverURL()).toURL(), (Capabilities)capabilities);
        }
        catch (Exception ex) {
            Assert.fail((String)"Failed to initialize android driver.", (Throwable)ex);
        }
    }

    private void prepareIosMobileAppDriver() {
        AppDriverConfig webDriverCfg = this.appConfig.getAppDriverConfig().getUpdatedProperties(this.overriddenDriverProps);
        DesiredCapabilities capabilities = new DesiredCapabilities();
        capabilities.setAcceptInsecureCerts(webDriverCfg.isAcceptInsecureCertificates());
        for (Map.Entry<String, Object> entry : webDriverCfg.getDriverCapabilities().entrySet()) {
            capabilities.setCapability(entry.getKey(), entry.getValue());
        }
        this.webDriver = new IOSDriver((Capabilities)capabilities);
    }

    private void prepareMacNativeAppDriver() {
        AppDriverConfig webDriverCfg = this.appConfig.getAppDriverConfig().getUpdatedProperties(this.overriddenDriverProps);
        DesiredCapabilities capabilities = new DesiredCapabilities();
        capabilities.setAcceptInsecureCerts(webDriverCfg.isAcceptInsecureCertificates());
        for (Map.Entry<String, Object> entry : webDriverCfg.getDriverCapabilities().entrySet()) {
            capabilities.setCapability(entry.getKey(), entry.getValue());
        }
        this.webDriver = new Mac2Driver((Capabilities)capabilities);
    }

    private void prepareWebAppDriverForNonMobileApp() {
        AppDriverConfig webDriverCfg = this.appConfig.getAppDriverConfig().getUpdatedProperties(this.overriddenDriverProps);
        try {
            switch (this.appConfig.getAppWebBrowser()) {
                case firefox: {
                    System.setProperty(webDriverCfg.getDriverSystemPropertyName(), webDriverCfg.getDriverBinaryFilePath());
                    FirefoxProfile firefoxProfile = new FirefoxProfile(new File(webDriverCfg.getProfilePath()));
                    if (this.appConfig.isEnableWebBrowserExtension()) {
                        for (File file : webDriverCfg.getBrowserExtensionFiles()) {
                            firefoxProfile.addExtension(file);
                        }
                    }
                    if (webDriverCfg.isDeleteExtensionsCacheIfItExists()) {
                        firefoxProfile.deleteExtensionsCacheIfItExists(new File(webDriverCfg.getProfilePath()));
                    }
                    firefoxProfile.setAlwaysLoadNoFocusLib(webDriverCfg.isAlwaysLoadNoFocusLib());
                    firefoxProfile.setAcceptUntrustedCertificates(webDriverCfg.isAcceptUntrustedCertificates());
                    firefoxProfile.setAssumeUntrustedCertificateIssuer(webDriverCfg.isAssumeUntrustedCertificateIssuer());
                    FirefoxOptions options = new FirefoxOptions().setProfile(firefoxProfile).setBinary(new FirefoxBinary());
                    options.setHeadless(webDriverCfg.isHeadless());
                    options.setPageLoadStrategy(webDriverCfg.getPageLoadStrategy());
                    options.setUnhandledPromptBehaviour(webDriverCfg.getUnexpectedAlertBehaviour());
                    options.setLogLevel(FirefoxDriverLogLevel.fromLevel((Level)webDriverCfg.getLogLevel()));
                    options.addArguments(webDriverCfg.getArguments());
                    for (Map.Entry<String, Object> entry : webDriverCfg.getDriverCapabilities().entrySet()) {
                        options.setCapability(entry.getKey(), entry.getValue());
                    }
                    for (Map.Entry<String, Object> entry : webDriverCfg.getBrowserPreferences().entrySet()) {
                        if (entry.getValue() instanceof String) {
                            options.addPreference(entry.getKey(), (Object)((String)entry.getValue()));
                            continue;
                        }
                        if (entry.getValue() instanceof Boolean) {
                            options.addPreference(entry.getKey(), (Object)((Boolean)entry.getValue()));
                            continue;
                        }
                        if (!(entry.getValue() instanceof Integer)) continue;
                        options.addPreference(entry.getKey(), (Object)((Integer)entry.getValue()));
                    }
                    options.setAcceptInsecureCerts(webDriverCfg.isAcceptInsecureCertificates());
                    Proxy proxy = this.getProxyInfo(this.appConfig);
                    if (proxy != null) {
                        options.setCapability("proxy", (Object)proxy);
                    }
                    FirefoxDriver firefoxDriver = new FirefoxDriver(options);
                    firefoxDriver.setLogLevel(webDriverCfg.getLogLevel());
                    firefoxDriver.manage().timeouts().scriptTimeout(Duration.ofSeconds(webDriverCfg.getScriptTimeoutInSecs().intValue()));
                    firefoxDriver.manage().timeouts().pageLoadTimeout(Duration.ofSeconds(webDriverCfg.getPageLoadTimeoutInSecs().intValue()));
                    firefoxDriver.manage().window().setSize(new Dimension(Double.valueOf(this.appConfig.getBrowserWindowSize().getWidth()).intValue(), Double.valueOf(this.appConfig.getBrowserWindowSize().getHeight()).intValue()));
                    firefoxDriver.manage().window().setPosition(new Point(0, 0));
                    if (this.shouldOpenURL) {
                        firefoxDriver.navigate().to(this.appConfig.getAppLaunchUrl());
                    }
                    this.webDriver = firefoxDriver;
                    break;
                }
                case chrome: {
                    System.setProperty(webDriverCfg.getDriverSystemPropertyName(), webDriverCfg.getDriverBinaryFilePath());
                    ChromeOptions options = new ChromeOptions();
                    options.setHeadless(webDriverCfg.isHeadless());
                    options.setPageLoadStrategy(webDriverCfg.getPageLoadStrategy());
                    options.setUnhandledPromptBehaviour(webDriverCfg.getUnexpectedAlertBehaviour());
                    options.addArguments(webDriverCfg.getArguments());
                    if (this.appConfig.isEnableWebBrowserExtension()) {
                        options.addExtensions(webDriverCfg.getBrowserExtensionFiles());
                    }
                    for (Map.Entry<String, Object> entry : webDriverCfg.getDriverCapabilities().entrySet()) {
                        options.setCapability(entry.getKey(), entry.getValue());
                    }
                    for (Map.Entry<String, Object> entry : webDriverCfg.getExperimentalOptions().entrySet()) {
                        options.setExperimentalOption(entry.getKey(), entry.getValue());
                    }
                    options.setAcceptInsecureCerts(webDriverCfg.isAcceptInsecureCertificates());
                    Proxy proxy = this.getProxyInfo(this.appConfig);
                    if (proxy != null) {
                        options.setCapability("proxy", (Object)proxy);
                    }
                    ChromeDriver wdriver = new ChromeDriver(options);
                    wdriver.setLogLevel(webDriverCfg.getLogLevel());
                    wdriver.manage().timeouts().scriptTimeout(Duration.ofSeconds(webDriverCfg.getScriptTimeoutInSecs().intValue()));
                    wdriver.manage().timeouts().pageLoadTimeout(Duration.ofSeconds(webDriverCfg.getPageLoadTimeoutInSecs().intValue()));
                    wdriver.manage().window().setSize(new Dimension(Double.valueOf(this.appConfig.getBrowserWindowSize().getWidth()).intValue(), Double.valueOf(this.appConfig.getBrowserWindowSize().getHeight()).intValue()));
                    wdriver.manage().window().setPosition(new Point(0, 0));
                    if (this.shouldOpenURL) {
                        wdriver.navigate().to(this.appConfig.getAppLaunchUrl());
                    }
                    this.webDriver = wdriver;
                    break;
                }
                case safari: {
                    System.setProperty("webdriver.safari.driver", webDriverCfg.getDriverBinaryFilePath());
                    SafariDriverService service = SafariDriverService.createDefaultService();
                    SafariOptions options = new SafariOptions();
                    options.setPageLoadStrategy(webDriverCfg.getPageLoadStrategy());
                    options.setUnhandledPromptBehaviour(webDriverCfg.getUnexpectedAlertBehaviour());
                    options.setAcceptInsecureCerts(webDriverCfg.isAcceptInsecureCertificates());
                    for (Map.Entry<String, Object> entry : webDriverCfg.getDriverCapabilities().entrySet()) {
                        options.setCapability(entry.getKey(), entry.getValue());
                    }
                    Proxy proxy = this.getProxyInfo(this.appConfig);
                    if (proxy != null) {
                        options.setCapability("proxy", (Object)proxy);
                    }
                    SafariDriver safariDriver = new SafariDriver((DriverService)service, options);
                    safariDriver.setLogLevel(webDriverCfg.getLogLevel());
                    safariDriver.manage().timeouts().scriptTimeout(Duration.ofSeconds(webDriverCfg.getScriptTimeoutInSecs().intValue()));
                    safariDriver.manage().timeouts().pageLoadTimeout(Duration.ofSeconds(webDriverCfg.getPageLoadTimeoutInSecs().intValue()));
                    safariDriver.manage().window().setSize(new Dimension(Double.valueOf(this.appConfig.getBrowserWindowSize().getWidth()).intValue(), Double.valueOf(this.appConfig.getBrowserWindowSize().getHeight()).intValue()));
                    safariDriver.manage().window().setPosition(new Point(0, 0));
                    if (this.shouldOpenURL) {
                        safariDriver.navigate().to(this.appConfig.getAppLaunchUrl());
                    }
                    this.webDriver = safariDriver;
                    break;
                }
                case edge: {
                    System.setProperty(webDriverCfg.getDriverSystemPropertyName(), webDriverCfg.getDriverBinaryFilePath());
                    System.setProperty("webdriver.edge.verboseLogging", String.valueOf("OFF".equals(webDriverCfg.getLogLevel())));
                    EdgeDriverService service = EdgeDriverService.createDefaultService();
                    EdgeOptions options = new EdgeOptions();
                    options.setHeadless(webDriverCfg.isHeadless());
                    options.setPageLoadStrategy(webDriverCfg.getPageLoadStrategy());
                    options.setUnhandledPromptBehaviour(webDriverCfg.getUnexpectedAlertBehaviour());
                    options.addArguments(webDriverCfg.getArguments());
                    options.setAcceptInsecureCerts(webDriverCfg.isAcceptInsecureCertificates());
                    if (this.appConfig.isEnableWebBrowserExtension()) {
                        options.addExtensions(webDriverCfg.getBrowserExtensionFiles());
                    }
                    for (Map.Entry<String, Object> entry : webDriverCfg.getDriverCapabilities().entrySet()) {
                        options.setCapability(entry.getKey(), entry.getValue());
                    }
                    for (Map.Entry<String, Object> entry : webDriverCfg.getExperimentalOptions().entrySet()) {
                        options.setExperimentalOption(entry.getKey(), entry.getValue());
                    }
                    Proxy proxy = this.getProxyInfo(this.appConfig);
                    if (proxy != null) {
                        options.setCapability("proxy", (Object)proxy);
                    }
                    EdgeDriver edgeDriver = new EdgeDriver(service, options);
                    edgeDriver.setLogLevel(webDriverCfg.getLogLevel());
                    edgeDriver.manage().timeouts().scriptTimeout(Duration.ofSeconds(webDriverCfg.getScriptTimeoutInSecs().intValue()));
                    edgeDriver.manage().timeouts().pageLoadTimeout(Duration.ofSeconds(webDriverCfg.getPageLoadTimeoutInSecs().intValue()));
                    edgeDriver.manage().window().setSize(new Dimension(Double.valueOf(this.appConfig.getBrowserWindowSize().getWidth()).intValue(), Double.valueOf(this.appConfig.getBrowserWindowSize().getHeight()).intValue()));
                    edgeDriver.manage().window().setPosition(new Point(0, 0));
                    if (this.shouldOpenURL) {
                        edgeDriver.navigate().to(this.appConfig.getAppLaunchUrl());
                    }
                    this.webDriver = edgeDriver;
                    break;
                }
                case opera: {
                    System.setProperty(webDriverCfg.getDriverSystemPropertyName(), webDriverCfg.getDriverBinaryFilePath());
                    ChromeOptions options = new ChromeOptions();
                    options.setHeadless(webDriverCfg.isHeadless());
                    options.setPageLoadStrategy(webDriverCfg.getPageLoadStrategy());
                    options.setUnhandledPromptBehaviour(webDriverCfg.getUnexpectedAlertBehaviour());
                    options.addArguments(webDriverCfg.getArguments());
                    if (this.appConfig.isEnableWebBrowserExtension()) {
                        options.addExtensions(webDriverCfg.getBrowserExtensionFiles());
                    }
                    for (Map.Entry<String, Object> entry : webDriverCfg.getDriverCapabilities().entrySet()) {
                        options.setCapability(entry.getKey(), entry.getValue());
                    }
                    for (Map.Entry<String, Object> entry : webDriverCfg.getExperimentalOptions().entrySet()) {
                        options.setExperimentalOption(entry.getKey(), entry.getValue());
                    }
                    options.setAcceptInsecureCerts(webDriverCfg.isAcceptInsecureCertificates());
                    Proxy proxy = this.getProxyInfo(this.appConfig);
                    if (proxy != null) {
                        options.setCapability("proxy", (Object)proxy);
                    }
                    ChromeDriver wdriver = new ChromeDriver(options);
                    wdriver.setLogLevel(webDriverCfg.getLogLevel());
                    wdriver.manage().timeouts().scriptTimeout(Duration.ofSeconds(webDriverCfg.getScriptTimeoutInSecs().intValue()));
                    wdriver.manage().timeouts().pageLoadTimeout(Duration.ofSeconds(webDriverCfg.getPageLoadTimeoutInSecs().intValue()));
                    wdriver.manage().window().setSize(new Dimension(Double.valueOf(this.appConfig.getBrowserWindowSize().getWidth()).intValue(), Double.valueOf(this.appConfig.getBrowserWindowSize().getHeight()).intValue()));
                    wdriver.manage().window().setPosition(new Point(0, 0));
                    if (this.shouldOpenURL) {
                        wdriver.navigate().to(this.appConfig.getAppLaunchUrl());
                    }
                    this.webDriver = wdriver;
                    break;
                }
                case internetExplorer: {
                    System.setProperty(webDriverCfg.getDriverSystemPropertyName(), webDriverCfg.getDriverBinaryFilePath());
                    System.setProperty("webdriver.ie.driver.loglevel", "OFF".equals(webDriverCfg.getLogLevel()) ? "FATAL" : ("INFO".equals(webDriverCfg.getLogLevel()) ? "INFO" : "DEBUG"));
                    InternetExplorerDriverService service = InternetExplorerDriverService.createDefaultService();
                    InternetExplorerOptions options = new InternetExplorerOptions();
                    options.setPageLoadStrategy(webDriverCfg.getPageLoadStrategy());
                    options.ignoreZoomSettings();
                    options.setUnhandledPromptBehaviour(webDriverCfg.getUnexpectedAlertBehaviour());
                    options.setCapability("initialBrowserUrl", this.appConfig.getAppLaunchUrl());
                    for (Map.Entry<String, Object> entry : webDriverCfg.getDriverCapabilities().entrySet()) {
                        options.setCapability(entry.getKey(), entry.getValue());
                    }
                    Proxy proxy = this.getProxyInfo(this.appConfig);
                    if (proxy != null) {
                        options.setCapability("proxy", (Object)proxy);
                    }
                    options.setAcceptInsecureCerts(webDriverCfg.isAcceptInsecureCertificates());
                    InternetExplorerDriver internetExplorerDriver = new InternetExplorerDriver(service, options);
                    internetExplorerDriver.setLogLevel(webDriverCfg.getLogLevel());
                    internetExplorerDriver.manage().timeouts().scriptTimeout(Duration.ofSeconds(webDriverCfg.getScriptTimeoutInSecs().intValue()));
                    internetExplorerDriver.manage().timeouts().pageLoadTimeout(Duration.ofSeconds(webDriverCfg.getPageLoadTimeoutInSecs().intValue()));
                    internetExplorerDriver.manage().window().setSize(new Dimension(Double.valueOf(this.appConfig.getBrowserWindowSize().getWidth()).intValue(), Double.valueOf(this.appConfig.getBrowserWindowSize().getHeight()).intValue()));
                    internetExplorerDriver.manage().window().setPosition(new Point(0, 0));
                    if (this.shouldOpenURL) {
                        internetExplorerDriver.navigate().to(this.appConfig.getAppLaunchUrl());
                    }
                    this.webDriver = internetExplorerDriver;
                    break;
                }
                case remoteWebDriverProvider: {
                    RemoteWebDriver wdriver = this.appConfig.getRemoteWebDriverProvider().createRemoteWebDriver();
                    wdriver.manage().window().setPosition(new Point(0, 0));
                    wdriver.manage().window().setSize(new Dimension(Double.valueOf(this.appConfig.getBrowserWindowSize().getWidth()).intValue(), Double.valueOf(this.appConfig.getBrowserWindowSize().getHeight()).intValue()));
                    if (this.shouldOpenURL) {
                        wdriver.navigate().to(this.appConfig.getAppLaunchUrl());
                    }
                    this.webDriver = wdriver;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Web browser '" + this.appConfig.getAppWebBrowser().getType() + "' is not supported.");
                }
            }
        }
        catch (Error | Exception ex) {
            Assert.fail((String)("Failed to initialize " + this.appConfig.getAppWebBrowser().getType() + " web browser. Going to exit... "), (Throwable)ex);
            System.exit(1);
        }
    }

    public void closeCurrentWindow() {
        if (this.webDriver != null) {
            this.webDriver.close();
        }
    }

    public void closeApp() {
        if (this.webDriver != null) {
            this.webDriver.quit();
        }
        this.opened = false;
    }

    public void closeChildWindows() {
        if (this.webDriver != null && this.appType == ApplicationType.web_app) {
            Set windowHandles = this.webDriver.getWindowHandles();
            for (String windowHandle : windowHandles) {
                if (windowHandle.equals(this.originalWindowHandle)) {
                    return;
                }
                WebDriver wd = this.webDriver.switchTo().window(windowHandle);
                if (wd == null) continue;
                wd.close();
            }
            this.webDriver.switchTo().defaultContent();
        }
    }

    public int getAppId() {
        return this.appId;
    }

    public String getAppName() {
        return this.appName;
    }

    public ApplicationType getAppType() {
        return this.appType;
    }

    public PlatformType getTestPlatformType() {
        return this.testPlatformType;
    }

    public WebDriver getWebDriver() {
        return this.webDriver;
    }

    public AppConfig getAppConfig() {
        return this.appConfig;
    }

    public boolean isOpened() {
        return this.opened;
    }

    public String getOSName() {
        return System.getProperty("os.name");
    }

    public Screen getSikuliScreen() {
        return this.sikuliDriver;
    }

    public String getOriginalWindowHandle() {
        return this.originalWindowHandle;
    }

    public void openURL(String url) {
        this.webDriver.navigate().to(url);
    }

    public void openDefaultURL() {
        this.openURL(this.appConfig.getAppLaunchUrl());
    }

    public void waitForMilliSeconds(long milliSeconds) {
        try {
            Thread.sleep(milliSeconds);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void waitForSeconds(int seconds) {
        try {
            Thread.sleep(seconds * 1000);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void refresh() {
        this.webDriver.navigate().refresh();
    }

    public void setFocus() {
        if (this.webDriver != null && this.appType == ApplicationType.web_app) {
            this.webDriver.switchTo().window(this.webDriver.getWindowHandle());
        }
    }

    private Proxy getProxyInfo(AppConfig appConfig) {
        ProxyConfiguration proxyConfig = appConfig.getProxyConfig();
        Proxy proxy = new Proxy();
        switch (proxyConfig.getProxyConfigType()) {
            case NO_PROXY: {
                proxy = null;
                break;
            }
            case AUTO_DETECT: {
                proxy.setProxyType(Proxy.ProxyType.AUTODETECT);
                proxy.setAutodetect(true);
                break;
            }
            case USE_SYSTEM_PROXY: {
                proxy.setProxyType(Proxy.ProxyType.SYSTEM);
                break;
            }
            case MANUAL_PROXY: {
                proxy.setProxyType(Proxy.ProxyType.MANUAL);
                proxy.setHttpProxy(proxyConfig.getHttpProxyHostname() + ":" + proxyConfig.getHttpProxyPort());
                proxy.setSslProxy(proxyConfig.getSslProxyHostname() + ":" + proxyConfig.getSslProxyPort());
                proxy.setFtpProxy(proxyConfig.getFtpProxyHostname() + ":" + proxyConfig.getFtpProxyPort());
                proxy.setSocksProxy(proxyConfig.getSocksHostname() + ":" + proxyConfig.getSocksPort());
                proxy.setSocksUsername(proxyConfig.getSocksUsername());
                proxy.setSocksPassword(proxyConfig.getSocksPassword());
                proxy.setNoProxy(proxyConfig.getNoProxyFor());
            }
        }
        return proxy;
    }
}

