/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.config;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.TypeRef;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.config.ApiTargetServer;

public class ApiConfig {
    private String appName;
    private String apiConfigFilePath;
    private List<ApiTargetServer> targetServers;
    private Map<String, Object> additionalProps;

    public ApiConfig(String appName, String apiConfigFilePath, DocumentContext yamlDoc) {
        this.appName = appName;
        this.apiConfigFilePath = apiConfigFilePath;
        this.additionalProps = (Map)yamlDoc.read("$.additionalProps", (TypeRef)new TypeRef<HashMap<String, Object>>(){});
        this.targetServers = (List)yamlDoc.read("$.targetServers", (TypeRef)new TypeRef<List<ApiTargetServer>>(){});
    }

    public String getAppName() {
        return this.appName;
    }

    public String getApiConfigFilePath() {
        return this.apiConfigFilePath;
    }

    public List<ApiTargetServer> getTargetServers() {
        return this.targetServers;
    }

    public ApiTargetServer getTargetServer(String name) {
        if (this.targetServers == null) {
            Assert.fail((String)("API target server '" + name + "' is not configured with application '" + this.appName + "'. You can configure in '" + this.apiConfigFilePath + "' file."));
        }
        for (ApiTargetServer targetServer : this.targetServers) {
            if (!targetServer.getName().equals(name)) continue;
            return targetServer;
        }
        Assert.fail((String)("API target server '" + name + "' is not configured with application '" + this.appName + "'. You can configure in '" + this.apiConfigFilePath + "' file."));
        return null;
    }

    public <T> T getAdditionalPropertyValue(String propName, Class<T> clazz) {
        Assert.assertTrue((boolean)this.additionalProps.containsKey(propName), (String)("Please specify the additional property '" + propName + "' in application '" + this.appName + "' '" + this.apiConfigFilePath + "' file."));
        return clazz.cast(this.additionalProps.get(propName));
    }
}

