/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.config;

import java.util.Map;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.config.ProxyConfigurationType;

public class ProxyConfiguration {
    private ProxyConfigurationType proxyConfigType = ProxyConfigurationType.NO_PROXY;
    private String httpProxyHostname;
    private String httpProxyPort;
    private String sslProxyHostname;
    private String sslProxyPort;
    private String ftpProxyHostname;
    private String ftpProxyPort;
    private String socksHostname;
    private String socksPort;
    private String socksVersion;
    private String socksUsername;
    private String socksPassword;
    private String noProxyFor;

    public ProxyConfiguration(String appName, Map<String, String> properties) {
        if (!"DEFAULT-APP".equals(appName)) {
            this.initProxyConfig(appName, properties);
        }
    }

    private void initProxyConfig(String appName, Map<String, String> properties) {
        String propValue = properties.get("proxyConfigType");
        if (propValue == null || "".equals(propValue.trim())) {
            Assert.fail((String)("FATAL: Please specify 'proxyConfigType' in AppConfig.yaml. AppName: " + appName + ". Exiting ..."));
            System.exit(1);
        } else {
            propValue = propValue.trim();
            this.proxyConfigType = ProxyConfigurationType.valueOf(propValue);
        }
        this.httpProxyHostname = properties.get("httpProxyHostname");
        if (this.httpProxyHostname != null && !"".equals(this.httpProxyHostname.trim())) {
            this.httpProxyHostname = this.httpProxyHostname.trim();
        }
        this.httpProxyPort = properties.get("httpProxyPort");
        if (this.httpProxyPort != null && !"".equals(this.httpProxyPort.trim())) {
            this.httpProxyPort = this.httpProxyPort.trim();
        }
        this.sslProxyHostname = properties.get("sslProxyHostname");
        if (this.sslProxyHostname != null && !"".equals(this.sslProxyHostname.trim())) {
            this.sslProxyHostname = this.sslProxyHostname.trim();
        }
        this.sslProxyPort = properties.get("sslProxyPort");
        if (this.sslProxyPort != null && !"".equals(this.sslProxyPort.trim())) {
            this.sslProxyPort = this.sslProxyPort.trim();
        }
        this.ftpProxyHostname = properties.get("ftpProxyHostname");
        if (this.ftpProxyHostname != null && !"".equals(this.ftpProxyHostname.trim())) {
            this.ftpProxyHostname = this.ftpProxyHostname.trim();
        }
        this.ftpProxyPort = properties.get("ftpProxyPort");
        if (this.ftpProxyPort != null && !"".equals(this.ftpProxyPort.trim())) {
            this.ftpProxyPort = this.ftpProxyPort.trim();
        }
        this.socksHostname = properties.get("socksHostname");
        if (this.socksHostname != null && !"".equals(this.socksHostname.trim())) {
            this.socksHostname = this.socksHostname.trim();
        }
        this.socksPort = properties.get("socksPort");
        if (this.socksPort != null && !"".equals(this.socksPort.trim())) {
            this.socksPort = this.socksPort.trim();
        }
        this.socksVersion = properties.get("socksVersion");
        if (this.socksVersion != null && !"".equals(this.socksVersion.trim())) {
            this.socksVersion = this.socksVersion.trim();
        }
        this.socksUsername = properties.get("socksUsername");
        if (this.socksUsername != null && !"".equals(this.socksUsername.trim())) {
            this.socksUsername = this.socksUsername.trim();
        }
        this.socksPassword = properties.get("socksPassword");
        if (this.socksPassword != null && !"".equals(this.socksPassword.trim())) {
            this.socksPassword = this.socksPassword.trim();
        }
        this.noProxyFor = properties.get("noProxyFor");
        if (this.noProxyFor != null && !"".equals(this.noProxyFor.trim())) {
            this.noProxyFor = this.noProxyFor.trim();
        }
    }

    public ProxyConfigurationType getProxyConfigType() {
        return this.proxyConfigType;
    }

    public String getHttpProxyHostname() {
        return this.httpProxyHostname;
    }

    public String getHttpProxyPort() {
        return this.httpProxyPort;
    }

    public String getSslProxyHostname() {
        return this.sslProxyHostname;
    }

    public String getSslProxyPort() {
        return this.sslProxyPort;
    }

    public String getFtpProxyHostname() {
        return this.ftpProxyHostname;
    }

    public String getFtpProxyPort() {
        return this.ftpProxyPort;
    }

    public String getSocksHostname() {
        return this.socksHostname;
    }

    public String getSocksPort() {
        return this.socksPort;
    }

    public String getSocksVersion() {
        return this.socksVersion;
    }

    public String getSocksUsername() {
        return this.socksUsername;
    }

    public String getSocksPassword() {
        return this.socksPassword;
    }

    public String getNoProxyFor() {
        return this.noProxyFor;
    }
}

