/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.config;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.TypeRef;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Map;
import org.sikuli.basics.Settings;
import org.sikuli.script.OCR;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.utils.JsonYamlUtil;

public class SikuliSettings {
    private String ocrDataPath;
    private Map<String, String> settings;
    private Map<String, Object> additionalProps;

    public SikuliSettings(String sikuliSettingsFilePath, DocumentContext yamlDoc) {
        this.ocrDataPath = sikuliSettingsFilePath + File.separator + "tessdata";
        this.initializeSikuli(yamlDoc);
    }

    public String getOcrDataPath() {
        return this.ocrDataPath;
    }

    public String getSettings(String propName) {
        return this.settings.get(propName);
    }

    public <T> T getAdditionalProperty(String propName, Class<T> clazz) {
        return clazz.cast(this.additionalProps.get(propName));
    }

    protected void initializeSikuli(DocumentContext yamlDoc) {
        try {
            this.settings = JsonYamlUtil.readNoException("$.settings", new TypeRef<Map<String, String>>(){}, yamlDoc);
            for (String name : this.settings.keySet()) {
                String value = this.settings.get(name);
                Field f = Settings.class.getDeclaredField(name);
                if (f.canAccess(null)) {
                    f.set(null, this.createObjectFromTypedValue(name, value));
                    continue;
                }
                f.setAccessible(true);
                f.set(null, this.createObjectFromTypedValue(name, value));
                f.setAccessible(false);
            }
            System.out.println("Sikuli OCRDataPath set to: " + this.getOcrDataPath());
            OCR.Options ocrOptions = OCR.globalOptions();
            ocrOptions.dataPath(this.getOcrDataPath());
            this.additionalProps = JsonYamlUtil.readNoException("$.additionalProps", new TypeRef<Map<String, Object>>(){}, yamlDoc);
        }
        catch (Throwable th) {
            Assert.fail((String)"Failed to initialize the sikuli driver.", (Throwable)th);
        }
    }

    protected Object createObjectFromTypedValue(String propertyName, String typedValue) {
        String[] typeValueArr = typedValue.split(":");
        Assert.assertTrue((typeValueArr.length > 1 ? 1 : 0) != 0, (String)("typedValue format is wrong for property '" + propertyName + "'. It should be <data-type>:<value>"));
        switch (typeValueArr[0]) {
            case "integer": {
                return Integer.parseInt(typeValueArr[1]);
            }
            case "string": {
                return typeValueArr[1];
            }
            case "float": {
                return Float.valueOf(Float.parseFloat(typeValueArr[1]));
            }
            case "double": {
                return Double.parseDouble(typeValueArr[1]);
            }
            case "boolean": {
                return Boolean.parseBoolean(typeValueArr[1]);
            }
        }
        Assert.fail((String)("'" + typeValueArr[0] + "' datatype is not supported for '" + propertyName + "' property."));
        return null;
    }
}

