/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.config;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.TypeRef;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.sikuli.script.Screen;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.api.core.reader.YamlDocumentReader;
import org.uitnet.testing.smartfwk.ui.core.commons.Locations;
import org.uitnet.testing.smartfwk.ui.core.config.AppConfig;
import org.uitnet.testing.smartfwk.ui.core.config.ApplicationType;
import org.uitnet.testing.smartfwk.ui.core.config.DatabaseProfile;
import org.uitnet.testing.smartfwk.ui.core.config.PlatformType;
import org.uitnet.testing.smartfwk.ui.core.config.SikuliSettings;
import org.uitnet.testing.smartfwk.ui.core.config.UserProfile;
import org.uitnet.testing.smartfwk.ui.core.config.WebBrowserType;
import org.uitnet.testing.smartfwk.ui.core.utils.JsonYamlUtil;
import org.uitnet.testing.smartfwk.ui.core.utils.OSDetectorUtil;

public class TestConfigManager {
    private static TestConfigManager instance;
    private static final String TEST_CONFIG_FILE_PATH;
    private String appsConfigDir;
    private List<String> appNames;
    private String cucumberTestcasesDir;
    private String appScreenCaptureDir;
    private String htmlReportsDir;
    private String sikuliConfigDir;
    private String sikuliResourcesDir;
    private PlatformType hostPlatformType;
    private boolean parallelMode;
    private int parallelThreads;
    private boolean preferDriverScreenshots;
    private boolean embedScreenshotsInTestReport;
    private Map<String, AppConfig> appConfigs;
    private Map<String, Object> additionalProps;
    private SikuliSettings sikuliSettings;

    private TestConfigManager() {
        this.init();
        this.initSikuliSettings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TestConfigManager getInstance() {
        if (instance != null) return instance;
        Class<TestConfigManager> clazz = TestConfigManager.class;
        synchronized (TestConfigManager.class) {
            if (instance != null) return instance;
            instance = new TestConfigManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void init() {
        this.hostPlatformType = OSDetectorUtil.getHostPlatform();
        this.appNames = new LinkedList<String>();
        this.appConfigs = new LinkedHashMap<String, AppConfig>();
        this.additionalProps = new LinkedHashMap<String, Object>();
        try {
            YamlDocumentReader reader = new YamlDocumentReader(new File(TEST_CONFIG_FILE_PATH));
            this.initTestConfig(reader.getDocumentContext());
            this.initAppConfigs();
        }
        catch (Exception ex) {
            Assert.fail((String)("Failed to read property file - " + TEST_CONFIG_FILE_PATH + ". Going to exit..."), (Throwable)ex);
            System.exit(1);
        }
    }

    private void initTestConfig(DocumentContext yamlDoc) {
        try {
            String[] arr;
            this.appsConfigDir = Locations.getProjectRootDir() + File.separator + "test-config" + File.separator + "apps-config";
            String appNamesAsStr = System.getProperty("appNames");
            if ((appNamesAsStr == null || "".equals(appNamesAsStr.trim())) && ((appNamesAsStr = JsonYamlUtil.readNoException("$.appNames", String.class, yamlDoc)) == null || "".equals(appNamesAsStr.trim()))) {
                Assert.fail((String)"FATAL: No application configured.");
                System.exit(1);
            }
            for (String appName : arr = appNamesAsStr.split(",")) {
                if ("".equals(appName.trim())) continue;
                this.appNames.add(appName.trim());
            }
            if (this.appNames.size() == 0) {
                Assert.fail((String)"FATAL: No application configured.");
                System.exit(1);
            }
            try {
                this.parallelThreads = Integer.parseInt(System.getProperty("parallel.threads", "1"));
            }
            catch (Exception e) {
                this.parallelThreads = 1;
            }
            this.parallelMode = this.parallelThreads > 1;
            Boolean boolValue = JsonYamlUtil.readNoException("$.preferDriverScreenshots", Boolean.class, yamlDoc);
            this.preferDriverScreenshots = boolValue == null || boolValue == true;
            boolValue = JsonYamlUtil.readNoException("$.embedScreenshotsInTestReport", Boolean.class, yamlDoc);
            this.embedScreenshotsInTestReport = boolValue == null || boolValue == true;
            this.cucumberTestcasesDir = Locations.getProjectRootDir() + File.separator + "cucumber-testcases";
            this.appScreenCaptureDir = Locations.getProjectRootDir() + File.separator + "test-results" + File.separator + "screen-captures";
            this.htmlReportsDir = Locations.getProjectRootDir() + File.separator + "test-results" + File.separator + "cucumber-html-reports";
            this.sikuliConfigDir = Locations.getProjectRootDir() + File.separator + "test-config" + File.separator + "sikuli-config";
            this.sikuliResourcesDir = Locations.getProjectRootDir() + File.separator + "sikuli-resources";
            this.additionalProps = JsonYamlUtil.readNoException("$.additionalProps", new TypeRef<Map<String, Object>>(){}, yamlDoc);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)"Error in loading configured testcase config class. Going to exit...", (Throwable)ex);
            System.exit(1);
        }
    }

    private void initAppConfigs() {
        String currAppName = null;
        try {
            this.appConfigs.put("DEFAULT-APP", this.createDefaultAppConfig(this.appsConfigDir));
            Iterator<String> iterator = this.appNames.iterator();
            while (iterator.hasNext()) {
                String appName;
                currAppName = appName = iterator.next();
                String appConfigFile = this.appsConfigDir + File.separator + appName + File.separator + "AppConfig.yaml";
                YamlDocumentReader reader = new YamlDocumentReader(new File(appConfigFile));
                AppConfig appConfig = new AppConfig(currAppName, reader.getDocumentContext(), this.appsConfigDir);
                this.appConfigs.put(appName, appConfig);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)("Error in loading AppConfig.yaml file for application name '" + currAppName + "'. Going to exit..."), (Throwable)ex);
            System.exit(1);
        }
    }

    private AppConfig createDefaultAppConfig(String appsConfigDir) {
        String defaultConfig = "applicationName: DEFAULT-APP\napplicationType: " + ApplicationType.not_applicable.getType() + "\ntestPlatformType: " + PlatformType.unknown.getType() + "\nappWebBrowser: " + WebBrowserType.notApplicable.getType() + "\nenableBrowserExtensions: false\nbrowserWindowSize: " + Screen.getPrimaryScreen().w + " x " + Screen.getPrimaryScreen().h + "\n";
        YamlDocumentReader reader = new YamlDocumentReader(defaultConfig);
        AppConfig appConfig = new AppConfig("DEFAULT-APP", reader.getDocumentContext(), appsConfigDir);
        return appConfig;
    }

    public boolean isParallelMode() {
        return this.parallelMode;
    }

    public boolean preferDriverScreenshots() {
        return this.preferDriverScreenshots;
    }

    public boolean embedScreenshotsInTestReport() {
        return this.embedScreenshotsInTestReport;
    }

    public AppConfig getAppConfig(String appName) {
        AppConfig appConfig = this.appConfigs.get(appName);
        Assert.assertNotNull((Object)appConfig, (String)("Please configure application config for application '" + appName + "'."));
        return appConfig;
    }

    public Collection<AppConfig> getAppConfigs() {
        return this.appConfigs.values();
    }

    public String getCucumberTestcasesDir() {
        return this.cucumberTestcasesDir;
    }

    public UserProfile getUserProfile(String appName, String profileName) {
        AppConfig appConfig = this.getAppConfig(appName);
        return appConfig.getUserProfile(profileName);
    }

    public DatabaseProfile getDatabaseProfile(String appName, String profileName) {
        AppConfig appConfig = this.getAppConfig(appName);
        return appConfig.getDatabaseProfile(profileName);
    }

    public <T> T getAdditionalPropertyValue(String propName, Class<T> clazz) {
        Assert.assertTrue((boolean)this.additionalProps.containsKey(propName), (String)("Please specify the additional property '" + propName + "' in TestConfig.yaml file."));
        return clazz.cast(this.additionalProps.get(propName));
    }

    public <T> T getAdditionalPropertyValue(String appName, String propName, Class<T> clazz) {
        return this.getAppConfig(appName).getAdditionalPropertyValue(propName, clazz);
    }

    public String getAppScreenCaptureDirectory() {
        return this.appScreenCaptureDir;
    }

    public String getHtmlReportsDir() {
        return this.htmlReportsDir;
    }

    public String getUserProfileAdditionalPropertyValue(String appName, String profileName, String propName) {
        return this.getUserProfile(appName, profileName).getAdditionalPropertyValue(propName);
    }

    private void initSikuliSettings() {
        String sikuliSettingsFile = this.sikuliConfigDir + File.separator + "SikuliSettings.yaml";
        try {
            YamlDocumentReader reader = new YamlDocumentReader(new File(sikuliSettingsFile));
            this.sikuliSettings = new SikuliSettings(this.sikuliConfigDir, reader.getDocumentContext());
        }
        catch (Exception ex) {
            Assert.fail((String)("Failed to read property file - " + sikuliSettingsFile + ". Going to exit..."), (Throwable)ex);
            System.exit(1);
        }
    }

    public SikuliSettings getSikuliSettings() {
        return this.sikuliSettings;
    }

    public String getSikuliResourcesDir() {
        return this.sikuliResourcesDir;
    }

    public PlatformType getHostPlatformType() {
        return this.hostPlatformType;
    }

    static {
        TEST_CONFIG_FILE_PATH = Locations.getConfigDirPath() + File.separator + "TestConfig.yaml";
    }
}

