/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.file.reader.support;

import java.util.List;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.file.reader.support.Table;

public class TableRow {
    private Table table;
    private int rowIndex;

    public TableRow(Table table, int rowIndex) {
        this.table = table;
        this.rowIndex = rowIndex;
    }

    public String getColumnValue(String columnName) {
        int colIndex = this.table.getColumnIndex(columnName);
        List<String> row = this.table.getRawRows().get(this.rowIndex);
        return row.get(colIndex);
    }

    public String getCulumnNumericPart(String columnName) {
        String intValue = "";
        String colValue = this.getColumnValue(columnName);
        try {
            intValue = colValue.split("[.]")[0];
        }
        catch (Exception ex) {
            Assert.fail((String)("Invalid integer value '" + colValue + "' in table '" + this.table.getTableName() + "', column '" + columnName + "'."));
        }
        return intValue;
    }

    public String toString() {
        return this.table.getRawRow(this.rowIndex).toString();
    }
}

