/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.api.core.reader;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.TypeRef;
import com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.io.File;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.testng.Assert;

public class YamlDocumentReader {
    protected DocumentContext jsonDocCtx;

    public YamlDocumentReader(File yamlFilePath) {
        try {
            this.init();
            Assert.assertNotNull((Object)yamlFilePath, (String)"YAML file path cannot be null.");
            ObjectMapper yamlMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
            Object yamlData = yamlMapper.readValue(yamlFilePath, Object.class);
            ObjectMapper objectMapper = new ObjectMapper();
            JacksonJsonProvider provider = new JacksonJsonProvider(objectMapper);
            this.jsonDocCtx = JsonPath.using((Configuration)Configuration.builder().jsonProvider((JsonProvider)provider).build()).parse(new ObjectMapper().writeValueAsString(yamlData));
        }
        catch (Exception ex) {
            Assert.fail((String)"Failed to parse YAML document.", (Throwable)ex);
        }
    }

    public YamlDocumentReader(String yamlAsString) {
        try {
            this.init();
            Assert.assertNotNull((Object)yamlAsString, (String)"YAML document cannot be null.");
            Assert.assertNotEquals((Object)yamlAsString.trim(), (Object)"", (String)"YAML document cannot be empty.");
            ObjectMapper yamlMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
            Object yamlData = yamlMapper.readValue(yamlAsString, Object.class);
            this.jsonDocCtx = this.prepareDocumentContext(yamlData);
        }
        catch (Exception ex) {
            Assert.fail((String)"Failed to parse YAML document.", (Throwable)ex);
        }
    }

    public DocumentContext prepareDocumentContext(Object obj) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            JacksonJsonProvider provider = new JacksonJsonProvider(objectMapper);
            return JsonPath.using((Configuration)Configuration.builder().jsonProvider((JsonProvider)provider).build()).parse(new ObjectMapper().writeValueAsString(obj));
        }
        catch (Exception ex) {
            Assert.fail((String)"Failed to covert object into DocumentContext.", (Throwable)ex);
            return null;
        }
    }

    public DocumentContext getDocumentContext() {
        return this.jsonDocCtx;
    }

    public <T> List<T> readValuesAsList(String yamlPath) {
        TypeRef typeRef = new TypeRef<List<T>>(){};
        return (List)this.jsonDocCtx.read(yamlPath, typeRef);
    }

    public <T> Set<T> readValuesAsSet(String yamlPath) {
        TypeRef typeRef = new TypeRef<Set<T>>(){};
        return (Set)this.jsonDocCtx.read(yamlPath, typeRef);
    }

    public <T> T readSingleValue(String yamlPath) {
        TypeRef typeRef = new TypeRef<T>(){};
        return (T)this.jsonDocCtx.read(yamlPath, typeRef);
    }

    public <T> T readValueAsObject(String yamlPath, Class<T> clazz) {
        try {
            Object obj = this.jsonDocCtx.read(yamlPath, Object.class, new Predicate[0]);
            ObjectMapper omapper = new ObjectMapper();
            String jsonStr = omapper.writeValueAsString(obj);
            omapper = new ObjectMapper();
            return (T)omapper.readValue(jsonStr, clazz);
        }
        catch (Exception ex) {
            Assert.fail((String)("Failed to read yaml path " + yamlPath + " as class object."), (Throwable)ex);
            return null;
        }
    }

    protected void init() {
        Configuration.setDefaults((Configuration.Defaults)new Configuration.Defaults(){
            private ObjectMapper objectMapper = JsonMapper.builder().enable(new JsonReadFeature[]{JsonReadFeature.ALLOW_SINGLE_QUOTES}).enable(new JsonReadFeature[]{JsonReadFeature.ALLOW_UNQUOTED_FIELD_NAMES}).build();

            public JsonProvider jsonProvider() {
                JacksonJsonProvider jsonProvider = new JacksonJsonProvider(this.objectMapper);
                return jsonProvider;
            }

            public MappingProvider mappingProvider() {
                return new JacksonMappingProvider(this.objectMapper);
            }

            public Set<Option> options() {
                return EnumSet.noneOf(Option.class);
            }
        });
    }
}

