/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.api.core.support;

import java.util.LinkedHashMap;
import java.util.Map;

public class HttpRequest {
    private String payload;
    private Map<String, String> headers;

    public HttpRequest() {
        this.headers = new LinkedHashMap<String, String>();
        this.headers.put("Content-Type", "application/json");
        this.headers.put("Accept", "application/json");
    }

    public HttpRequest(Map<String, String> headers, String payload, String payloadType, String responseContentType) {
        headers = new LinkedHashMap<String, String>();
        headers.putAll(headers);
        headers.put("Content-Type", payloadType);
        headers.put("Accept", responseContentType);
        this.payload = payload;
    }

    public String getPayload() {
        return this.payload;
    }

    public HttpRequest setPayload(String payload) {
        this.payload = payload;
        return this;
    }

    public String getPayloadType() {
        return this.getHeader("Content-Type");
    }

    public HttpRequest setPayloadType(String payloadType) {
        this.headers.put("Content-Type", payloadType);
        return this;
    }

    public String getHeader(String name) {
        for (Map.Entry<String, String> e : this.headers.entrySet()) {
            if (!e.getKey().toUpperCase().equals(name.toUpperCase())) continue;
            return e.getValue();
        }
        return null;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public HttpRequest setHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public String getResponseContentType() {
        return this.headers.get("Accept");
    }

    public HttpRequest setResponseContentType(String responseContentType) {
        this.headers.put("Accept", responseContentType);
        return this;
    }
}

