/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.database;

import java.io.IOException;
import java.io.Reader;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.ParameterMode;
import javax.persistence.StoredProcedureQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.query.NativeQuery;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.common.MethodArg;
import org.uitnet.testing.smartfwk.common.MethodArgMode;
import org.uitnet.testing.smartfwk.common.ReturnType;
import org.uitnet.testing.smartfwk.database.AbstractDatabaseActionHandler;
import org.uitnet.testing.smartfwk.database.DatabaseConnection;
import org.uitnet.testing.smartfwk.ui.core.config.DatabaseProfile;
import org.uitnet.testing.smartfwk.ui.core.utils.JsonYamlUtil;

public class SqlDatabaseActionHandler
extends AbstractDatabaseActionHandler {
    public SqlDatabaseActionHandler(String appName, int sessionExpiryDurationInSeconds, DatabaseProfile databaseProfile) {
        super(appName, sessionExpiryDurationInSeconds, databaseProfile);
    }

    @Override
    public DatabaseConnection connect(DatabaseProfile dbProfile) {
        Map<String, Object> dbAdditionalProps = dbProfile.getAdditionalProps();
        Properties dbProps = new Properties();
        dbProps.putAll(dbAdditionalProps);
        Configuration hibernateCfg = new Configuration().addProperties(dbProps);
        SessionFactory hibernateSessionFactory = hibernateCfg.buildSessionFactory();
        DatabaseConnection connection = new DatabaseConnection(hibernateSessionFactory);
        return connection;
    }

    @Override
    public void disconnect(DatabaseConnection connection) {
        if (connection != null && connection.getConnection() != null) {
            try {
                ((SessionFactory)connection.getConnection()).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String getDataAsJsonString(DatabaseConnection connection, String entityName, String searchStatement) {
        try (Session hibSession = null;){
            Thread.sleep(5000L);
            hibSession = ((SessionFactory)connection.getConnection()).openSession();
            NativeQuery sqlQuery = hibSession.createSQLQuery(searchStatement);
            List foundRecords = sqlQuery.list();
            String string = JsonYamlUtil.convertObjectToJsonString(foundRecords);
            return string;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateData(DatabaseConnection connection, String entityName, String updateStatement) {
        Transaction txn = null;
        try (Session hibSession = null;){
            hibSession = ((SessionFactory)connection.getConnection()).openSession();
            txn = hibSession.beginTransaction();
            NativeQuery sqlQuery = hibSession.createSQLQuery(updateStatement);
            sqlQuery.executeUpdate();
            txn.commit();
            txn = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void deleteData(DatabaseConnection connection, String entityName, String deleteStatement) {
        Transaction txn = null;
        try (Session hibSession = null;){
            hibSession = ((SessionFactory)connection.getConnection()).openSession();
            txn = hibSession.beginTransaction();
            NativeQuery sqlQuery = hibSession.createSQLQuery(deleteStatement);
            sqlQuery.executeUpdate();
            txn.commit();
            txn = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void insertData(DatabaseConnection connection, String entityName, String insertStatement) {
        Transaction txn = null;
        try (Session hibSession = null;){
            hibSession = ((SessionFactory)connection.getConnection()).openSession();
            txn = hibSession.beginTransaction();
            NativeQuery sqlQuery = hibSession.createSQLQuery(insertStatement);
            sqlQuery.executeUpdate();
            txn.commit();
            txn = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void insertDataInBatch(DatabaseConnection connection, String entityName, List<String> insertStatements) {
        Transaction txn = null;
        try (Session hibSession = null;){
            hibSession = ((SessionFactory)connection.getConnection()).openSession();
            txn = hibSession.beginTransaction();
            hibSession.setJdbcBatchSize(Integer.valueOf(100));
            NativeQuery sqlQuery = null;
            for (String stmt : insertStatements) {
                sqlQuery = hibSession.createSQLQuery(stmt);
                sqlQuery.executeUpdate();
            }
            txn.commit();
            txn = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void create(DatabaseConnection connection, String entityName, String createStatement) {
        Transaction txn = null;
        try (Session hibSession = null;){
            hibSession = ((SessionFactory)connection.getConnection()).openSession();
            txn = hibSession.beginTransaction();
            hibSession.setJdbcBatchSize(Integer.valueOf(100));
            NativeQuery sqlQuery = null;
            sqlQuery = hibSession.createSQLQuery(createStatement);
            sqlQuery.executeUpdate();
            txn.commit();
            txn = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void drop(DatabaseConnection connection, String entityName, String dropStatement) {
        Transaction txn = null;
        try (Session hibSession = null;){
            hibSession = ((SessionFactory)connection.getConnection()).openSession();
            txn = hibSession.beginTransaction();
            hibSession.setJdbcBatchSize(Integer.valueOf(100));
            NativeQuery sqlQuery = null;
            sqlQuery = hibSession.createSQLQuery(dropStatement);
            sqlQuery.executeUpdate();
            txn.commit();
            txn = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String executeFunctionReturnAsJson(String functionName, ReturnType returnType, Object ... args) {
        try (Session hibSession = null;){
            Thread.sleep(5000L);
            hibSession = ((SessionFactory)this.connection.getConnection()).openSession();
            String driverClazz = this.activeDatabaseProfile.getAdditionalPropertyValue("hibernate.connection.driver_class", String.class);
            NativeQuery query = null;
            query = driverClazz.contains("Oracle") ? hibSession.createNativeQuery("select " + functionName + "(" + this.prepareArgsForFunction(args) + ") from dual") : hibSession.createNativeQuery("select " + functionName + "(" + this.prepareArgsForFunction(args) + ")");
            for (int i = 1; i < args.length; ++i) {
                query.setParameter(i, args[i - 1]);
            }
            if (returnType == null || returnType == ReturnType.SingleRecord) {
                Object foundRecords = query.getSingleResult();
                String string = JsonYamlUtil.convertObjectToJsonString(foundRecords);
                return string;
            }
            List foundRecords = query.getResultList();
            String string = JsonYamlUtil.convertObjectToJsonString(foundRecords);
            return string;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String executeProcedureReturnAsJson(String procedureName, MethodArg<?> ... args) {
        try (Session hibSession = null;){
            Thread.sleep(5000L);
            hibSession = ((SessionFactory)this.connection.getConnection()).openSession();
            StoredProcedureQuery query = null;
            query = hibSession.createStoredProcedureQuery(procedureName);
            LinkedList<String> outParamNames = new LinkedList<String>();
            LinkedList<String> refCursorParamNames = new LinkedList<String>();
            for (int i = 1; i < args.length; ++i) {
                if (args[i].getMode() == MethodArgMode.IN) {
                    query.registerStoredProcedureParameter(args[i].getName(), args[i].getDataType(), ParameterMode.valueOf((String)args[i].getMode().name()));
                    query.setParameter(args[i].getName(), args[i].getValue());
                    continue;
                }
                if (args[i].getMode() == MethodArgMode.INOUT) {
                    query.registerStoredProcedureParameter(args[i].getName(), args[i].getDataType(), ParameterMode.valueOf((String)args[i].getMode().name()));
                    query.setParameter(args[i].getName(), args[i].getValue());
                    outParamNames.add(args[i].getName());
                    continue;
                }
                if (args[i].getMode() == MethodArgMode.OUT) {
                    query.registerStoredProcedureParameter(args[i].getName(), args[i].getDataType(), ParameterMode.valueOf((String)args[i].getMode().name()));
                    outParamNames.add(args[i].getName());
                    continue;
                }
                query.registerStoredProcedureParameter(args[i].getName(), Void.TYPE, ParameterMode.valueOf((String)args[i].getMode().name()));
                refCursorParamNames.add(args[i].getName());
            }
            if (refCursorParamNames.size() > 1) {
                Assert.fail((String)"Procedure can have only one parameter as REF_CURSOR.");
                String i = null;
                return i;
            }
            LinkedHashMap<String, Object> outputMap = new LinkedHashMap<String, Object>();
            if (refCursorParamNames.size() == 1) {
                Object result = query.getSingleResult();
                outputMap.put((String)refCursorParamNames.get(0), result);
            } else {
                query.execute();
            }
            for (String outParamName : outParamNames) {
                Object result = query.getOutputParameterValue(outParamName);
                if (result instanceof Clob) {
                    result = this.readClobData((Clob)result);
                }
                outputMap.put(outParamName, result);
            }
            if (outputMap.size() > 0) {
                String string = JsonYamlUtil.convertObjectToJsonString(outputMap);
                return string;
            }
        }
        return null;
    }

    private String prepareArgsForFunction(Object[] args) {
        StringBuilder sb = new StringBuilder("");
        if (args == null) {
            return "";
        }
        for (int i = 0; i < args.length; ++i) {
            if (i == 0) {
                sb.append("?");
                continue;
            }
            sb.append(", ?");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readClobData(Clob clob) throws SQLException, IOException {
        String outBuffer;
        try (Reader reader = null;){
            char[] charBuffer = new char[(int)clob.length()];
            reader = clob.getCharacterStream();
            reader.read(charBuffer);
            outBuffer = new String(charBuffer);
        }
        return outBuffer;
    }
}

