/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.appdriver;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.uitnet.testing.smartfwk.ui.core.appdriver.SmartAppDriver;
import org.uitnet.testing.smartfwk.ui.core.config.AppConfig;
import org.uitnet.testing.smartfwk.ui.core.config.TestConfigManager;

public class SmartAppDriverFactory {
    private static SmartAppDriverFactory instance;
    private Map<String, SmartAppDriver> appDriverMap = new LinkedHashMap<String, SmartAppDriver>();

    private SmartAppDriverFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SmartAppDriverFactory getInstance() {
        if (instance != null) return instance;
        Class<SmartAppDriverFactory> clazz = SmartAppDriverFactory.class;
        synchronized (SmartAppDriverFactory.class) {
            if (instance != null) return instance;
            instance = new SmartAppDriverFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public synchronized SmartAppDriver getNewAppDriver(String appName) {
        AppConfig appConfig = TestConfigManager.getInstance().getAppConfig(appName);
        SmartAppDriver appDriver = new SmartAppDriver(appName, appConfig.getAppType(), appConfig.getTestPlatformType());
        this.appDriverMap.put(appName + ":" + appDriver.getAppId(), appDriver);
        return appDriver;
    }

    public synchronized SmartAppDriver getLatestAppDriverOrCreateOne(String appName) {
        SmartAppDriver driver = null;
        String appKey = appName + ":";
        for (Map.Entry<String, SmartAppDriver> entry : this.appDriverMap.entrySet()) {
            if (!entry.getKey().startsWith(appKey)) continue;
            driver = entry.getValue();
        }
        if (driver == null) {
            return this.getNewAppDriver(appName);
        }
        return driver;
    }

    public List<SmartAppDriver> getAllAppDrivers(String appName) {
        LinkedList<SmartAppDriver> drivers = new LinkedList<SmartAppDriver>();
        String appKey = appName + ":";
        for (Map.Entry<String, SmartAppDriver> entry : this.appDriverMap.entrySet()) {
            if (!entry.getKey().startsWith(appKey)) continue;
            drivers.add(entry.getValue());
        }
        return drivers;
    }

    public synchronized void removeAppDriver(String appName, int appId) {
        String key = appName + ":" + appId;
        SmartAppDriver driver = this.appDriverMap.get(key);
        if (driver != null) {
            driver.closeApp();
            this.appDriverMap.remove(key);
        }
    }

    public synchronized void removeAllAppDrivers(String appName) {
        LinkedList<SmartAppDriver> drivers = new LinkedList<SmartAppDriver>();
        for (Map.Entry<String, SmartAppDriver> entry : this.appDriverMap.entrySet()) {
            if (!entry.getKey().startsWith(appName)) continue;
            entry.getValue().closeApp();
            drivers.add(entry.getValue());
        }
        for (SmartAppDriver driver : drivers) {
            this.appDriverMap.remove(driver.getAppName() + ":" + driver.getAppId());
        }
    }

    public synchronized void removeAllAppDrivers() {
        LinkedList<SmartAppDriver> drivers = new LinkedList<SmartAppDriver>();
        for (Map.Entry<String, SmartAppDriver> entry : this.appDriverMap.entrySet()) {
            entry.getValue().closeApp();
            drivers.add(entry.getValue());
        }
        for (SmartAppDriver driver : drivers) {
            this.appDriverMap.remove(driver.getAppName() + ":" + driver.getAppId());
        }
    }
}

