/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.config;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.TypeRef;
import java.awt.Dimension;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.api.core.reader.YamlDocumentReader;
import org.uitnet.testing.smartfwk.ui.core.appdriver.RemoteWebDriverProvider;
import org.uitnet.testing.smartfwk.ui.core.commons.Locations;
import org.uitnet.testing.smartfwk.ui.core.config.ApiConfig;
import org.uitnet.testing.smartfwk.ui.core.config.AppDriverConfig;
import org.uitnet.testing.smartfwk.ui.core.config.ApplicationType;
import org.uitnet.testing.smartfwk.ui.core.config.DatabaseProfile;
import org.uitnet.testing.smartfwk.ui.core.config.EnvironmentConfig;
import org.uitnet.testing.smartfwk.ui.core.config.PlatformType;
import org.uitnet.testing.smartfwk.ui.core.config.ProxyConfiguration;
import org.uitnet.testing.smartfwk.ui.core.config.UserProfile;
import org.uitnet.testing.smartfwk.ui.core.config.WebBrowserType;
import org.uitnet.testing.smartfwk.ui.core.defaults.DefaultInfo;
import org.uitnet.testing.smartfwk.ui.core.utils.JsonYamlUtil;
import org.uitnet.testing.smartfwk.ui.core.utils.ScreenCaptureUtil;

public class AppConfig {
    private String appName;
    private ApplicationType appType;
    private PlatformType testPlatformType;
    private String appsConfigDir;
    private String appLaunchUrl;
    private String appLoginPageValidatorClass;
    private String appLoginSuccessPageValidatorClass;
    private String remoteWebDriverProviderClass;
    private RemoteWebDriverProvider remoteWebDriverProvider;
    private WebBrowserType appWebBrowser;
    private boolean enableWebBrowserExtension;
    private Dimension browserWindowSize;
    private String userProfileConfigDir = "user-profiles";
    private Map<String, UserProfile> userProfiles;
    private String dbProfileConfigDir = "database-profiles";
    private Map<String, DatabaseProfile> dbProfiles;
    private ProxyConfiguration proxyConfig;
    private Map<String, Object> additionalProps;
    private ApiConfig apiConfig;
    private AppDriverConfig appDriverConfig;
    private EnvironmentConfig environmentConfig;

    public AppConfig(String appName, DocumentContext yamlDoc, String appsConfigDir) {
        this.appName = appName;
        this.appsConfigDir = appsConfigDir;
        System.out.println("Going to configure '" + this.appName + "' application.");
        this.userProfiles = new LinkedHashMap<String, UserProfile>();
        this.dbProfiles = new LinkedHashMap<String, DatabaseProfile>();
        this.additionalProps = new LinkedHashMap<String, Object>();
        String activeEnvironmentName = Locations.getAppActiveEnvironmentName(appName);
        this.environmentConfig = new EnvironmentConfig(appName, activeEnvironmentName);
        System.out.println("Going to set active environment '" + this.environmentConfig.getName() + "' for application '" + this.appName + "'.");
        System.out.println("Environment '" + this.environmentConfig.getName() + "' properties: " + (this.environmentConfig.getDocumentContext() == null ? "" : this.environmentConfig.getDocumentContext().read("$", new Predicate[0])));
        this.initAppConfig(appName, yamlDoc, this.environmentConfig.getDocumentContext());
        System.out.println("Application '" + this.appName + "' configured successfully using active environment: " + this.environmentConfig.getName() + ".");
    }

    public String getAppName() {
        return this.appName;
    }

    public String getAppsConfigDir() {
        return this.appsConfigDir;
    }

    private void initAppConfig(String appName, DocumentContext appConfigDocContext, DocumentContext envAppConfigDocContext) {
        String propValue = JsonYamlUtil.readNoException("$.applicationName", String.class, appConfigDocContext, envAppConfigDocContext);
        if (propValue == null || !appName.equals(propValue.trim())) {
            Assert.fail((String)("FATAL: Application name '" + propValue + "' specified in file is not same as configured in TestConfig.yaml file '" + appName + "'. Exiting ..."));
            System.exit(1);
        }
        if ((propValue = JsonYamlUtil.readNoException("$.applicationType", String.class, appConfigDocContext, envAppConfigDocContext)) == null || "".equals(propValue.trim())) {
            Assert.fail((String)("FATAL: Please specify 'applicationType' in AppConfig.yaml. AppName: " + appName + ", environmentName: . Exiting ..."));
            System.exit(1);
        } else {
            this.appType = ApplicationType.valueOf2(propValue);
        }
        propValue = JsonYamlUtil.readNoException("$.testPlatformType", String.class, appConfigDocContext, envAppConfigDocContext);
        if (propValue == null || "".equals(propValue.trim())) {
            Assert.fail((String)("FATAL: Please specify 'testPlatformType' in AppConfig.yaml. AppName: " + appName + ". Exiting ..."));
            System.exit(1);
        } else {
            this.testPlatformType = PlatformType.valueOf2(propValue);
        }
        this.appLaunchUrl = JsonYamlUtil.readNoException("$.appLaunchURL", String.class, appConfigDocContext, envAppConfigDocContext);
        if (this.appLaunchUrl == null || "".equals(this.appLaunchUrl.trim())) {
            if (!"DEFAULT-APP".equals(this.appName)) {
                Assert.fail((String)("FATAL: Please specify 'appLaunchURL' in AppConfig.yaml. AppName: " + appName + ". Exiting ..."));
                System.exit(1);
            } else {
                this.appLaunchUrl = "";
            }
        } else {
            this.appLaunchUrl = this.appLaunchUrl.trim();
        }
        propValue = JsonYamlUtil.readNoException("$.appWebBrowser", String.class, appConfigDocContext, envAppConfigDocContext);
        if (propValue == null || "".equals(propValue.trim())) {
            Assert.fail((String)("FATAL: Please specify 'appWebBrowser' in AppConfig.yaml. AppName: " + appName + ". Exiting ..."));
            System.exit(1);
        } else {
            this.appWebBrowser = WebBrowserType.valueOf2(propValue.trim());
        }
        Map<String, String> propValuesAsMap = JsonYamlUtil.readNoException("$.proxySettings", new TypeRef<Map<String, String>>(){}, appConfigDocContext, envAppConfigDocContext);
        this.proxyConfig = new ProxyConfiguration(appName, propValuesAsMap);
        this.remoteWebDriverProviderClass = JsonYamlUtil.readNoException("$.remoteWebDriverProviderClass", String.class, appConfigDocContext, envAppConfigDocContext);
        this.appLoginPageValidatorClass = JsonYamlUtil.readNoException("$.appLoginPageValidatorClass", String.class, appConfigDocContext, envAppConfigDocContext);
        this.appLoginPageValidatorClass = this.appLoginPageValidatorClass == null || "".equals(this.appLoginPageValidatorClass.trim()) ? DefaultInfo.DEFAULT_APP_LOGIN_PAGE_VALIDATOR : this.appLoginPageValidatorClass.trim();
        this.appLoginSuccessPageValidatorClass = JsonYamlUtil.readNoException("$.appLoginSuccessPageValidatorClass", String.class, appConfigDocContext, envAppConfigDocContext);
        this.appLoginSuccessPageValidatorClass = this.appLoginSuccessPageValidatorClass == null || "".equals(this.appLoginSuccessPageValidatorClass.trim()) ? DefaultInfo.DEFAULT_APP_LOGIN_SUCCESS_PAGE_VALIDATOR : this.appLoginSuccessPageValidatorClass.trim();
        propValue = JsonYamlUtil.readNoException("$.enableBrowserExtensions", String.class, appConfigDocContext, envAppConfigDocContext);
        if (propValue == null || "".equals(propValue.trim())) {
            Assert.fail((String)("FATAL: Please specify 'enableBrowserExtensions' in AppConfig.yaml. AppName: " + appName + ". Exiting ..."));
            System.exit(1);
        } else {
            this.enableWebBrowserExtension = Boolean.valueOf(propValue.trim());
        }
        propValue = JsonYamlUtil.readNoException("$.browserWindowSize", String.class, appConfigDocContext, envAppConfigDocContext);
        if (propValue == null || "".equals(propValue.trim()) || !propValue.contains("x")) {
            Assert.fail((String)("FATAL: Please specify correct 'browserWindowSize' in AppConfig.yaml. AppName: " + appName + ". Exiting ..."));
            System.exit(1);
        } else {
            String[] wh = propValue.split("x");
            try {
                int browserWidth = Integer.parseInt(wh[0].trim());
                int browserHeight = Integer.parseInt(wh[1].trim());
                Dimension screenSize = ScreenCaptureUtil.getScreenSize();
                if ((double)browserWidth > screenSize.getWidth()) {
                    Assert.fail((String)("FATAL: please specify the 'browserWindowSize' (browserWidth) <= screenWidth in AppConfig.yaml. AppName: " + appName + ". Exiting ..."));
                    System.exit(1);
                } else if ((double)browserHeight > screenSize.getHeight()) {
                    Assert.fail((String)("FATAL: please specify the 'browserWindowSize' (browserHeight) <= screenHeight in AppConfig.yaml. AppName: " + appName + ". Exiting ..."));
                    System.exit(1);
                }
                this.browserWindowSize = new Dimension(browserWidth, browserHeight);
            }
            catch (Exception ex) {
                Assert.fail((String)("FATAL: Please specify correct 'browserWindowSize' in AppConfig.yaml. AppName: " + appName + ". Exiting ..."));
                System.exit(1);
            }
        }
        this.userProfileConfigDir = this.appsConfigDir + File.separator + appName + File.separator + this.userProfileConfigDir.trim();
        List<String> propValues = JsonYamlUtil.readNoException("$.userProfileNames", new TypeRef<List<String>>(){}, appConfigDocContext, envAppConfigDocContext);
        if (propValues == null || propValues.isEmpty()) {
            this.userProfiles.put("DEFAULT-USER-PROFILE", null);
        } else {
            for (String item : propValues) {
                String keyStr = item.trim();
                if ("".equals(keyStr)) continue;
                this.userProfiles.put(keyStr, null);
            }
            this.initUserProfiles();
        }
        this.dbProfileConfigDir = this.appsConfigDir + File.separator + appName + File.separator + this.dbProfileConfigDir.trim();
        propValues = JsonYamlUtil.readNoException("$.dbProfileNames", new TypeRef<List<String>>(){}, appConfigDocContext, envAppConfigDocContext);
        if (propValues != null && !propValues.isEmpty()) {
            for (String item : propValues) {
                String keyStr = item.trim();
                if ("".equals(keyStr)) continue;
                this.dbProfiles.put(keyStr, null);
            }
            this.initDatabaseProfiles();
        }
        this.additionalProps = JsonYamlUtil.readNoException("$.additionalProps", new TypeRef<HashMap<String, Object>>(){}, appConfigDocContext, envAppConfigDocContext);
        if (this.remoteWebDriverProviderClass == null || "".equals(this.remoteWebDriverProviderClass.trim())) {
            this.remoteWebDriverProviderClass = null;
        } else {
            this.remoteWebDriverProviderClass = this.remoteWebDriverProviderClass.trim();
            try {
                this.remoteWebDriverProvider = (RemoteWebDriverProvider)Class.forName(this.remoteWebDriverProviderClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.remoteWebDriverProvider.setAppConfig(this);
            }
            catch (Exception ex) {
                Assert.fail((String)("Failed to instantiate remote web driver class '" + this.remoteWebDriverProviderClass + "' defined in application '" + appName + "'."), (Throwable)ex);
            }
        }
        propValue = JsonYamlUtil.readNoException("$.apiConfigFileName", String.class, appConfigDocContext, envAppConfigDocContext);
        if (propValue == null || "".equals(propValue.trim())) {
            if (!"DEFAULT-APP".equals(this.appName)) {
                Assert.fail((String)("FATAL: Please specify 'apiConfigFileName' in AppConfig.yaml. AppName: " + appName + ". Exiting ..."));
                System.exit(1);
            }
        } else {
            String apiConfigFile = this.appsConfigDir + File.separator + this.appName + File.separator + "api-configs" + File.separator + propValue;
            try {
                YamlDocumentReader yamlReader = new YamlDocumentReader(new File(apiConfigFile));
                this.apiConfig = new ApiConfig(this.appName, apiConfigFile, yamlReader.getDocumentContext());
            }
            catch (Exception ex) {
                Assert.fail((String)("Failed to load '" + apiConfigFile + "' file for application '" + this.appName + "'."), (Throwable)ex);
            }
        }
        propValue = JsonYamlUtil.readNoException("$.appDriverConfigFileName", String.class, appConfigDocContext, envAppConfigDocContext);
        this.initAppDriverConfig(propValue);
    }

    public ApiConfig getApiConfig() {
        return this.apiConfig;
    }

    public AppDriverConfig getAppDriverConfig() {
        return this.appDriverConfig;
    }

    private void initUserProfiles() {
        Object currProfileName = null;
        try {
            for (String profileName : this.userProfiles.keySet()) {
                currProfileName = profileName + "-" + this.environmentConfig.getName();
                if (!this.isUserProfileExist((String)currProfileName) && !this.isUserProfileExist((String)(currProfileName = profileName))) {
                    throw new RuntimeException("'" + (String)currProfileName + "' user profile does not exist for app '" + this.appName + "' and environment '" + this.environmentConfig.getName() + "'.");
                }
                UserProfile userProfile = this.prepareUserProfile((String)currProfileName);
                userProfile.setEnvFileName((String)currProfileName + ".yaml");
                userProfile.validateInfo();
                if (!profileName.equals(userProfile.getProfileName())) {
                    throw new RuntimeException("'" + profileName + "' user profile does not exist for app '" + this.appName + "' and environment '" + this.environmentConfig.getName() + "'.");
                }
                this.userProfiles.put(userProfile.getProfileName(), userProfile);
            }
            this.userProfiles.put("DEFAULT-USER-PROFILE", null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)("Error in loading user profile '" + currProfileName + ".yaml' for application name '" + this.appName + "'. Going to exit..."), (Throwable)ex);
            System.exit(1);
        }
    }

    private void initDatabaseProfiles() {
        Object currProfileName = null;
        try {
            for (String profileName : this.dbProfiles.keySet()) {
                currProfileName = profileName + "-" + this.environmentConfig.getName();
                if (!this.isDatabaseProfileExist((String)currProfileName) && !this.isDatabaseProfileExist((String)(currProfileName = profileName))) {
                    throw new RuntimeException("'" + (String)currProfileName + "' database profile does not exist for app '" + this.appName + "' and environment '" + this.environmentConfig.getName() + "'.");
                }
                DatabaseProfile dbProfile = this.prepareDatabaseProfile((String)currProfileName);
                dbProfile.setEnvFileName((String)currProfileName + ".yaml");
                dbProfile.validateInfo();
                if (!profileName.equals(dbProfile.getProfileName())) {
                    throw new RuntimeException("'" + profileName + "' database profile does not exist for app '" + this.appName + "' and environment '" + this.environmentConfig.getName() + "'.");
                }
                this.dbProfiles.put(dbProfile.getProfileName(), dbProfile);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)("Error in loading database profile '" + currProfileName + ".yaml' for application name '" + this.appName + "'. Going to exit..."), (Throwable)ex);
            System.exit(1);
        }
    }

    private boolean isUserProfileExist(String profileName) {
        String path = this.userProfileConfigDir + "/" + profileName + ".yaml";
        return new File(path).exists();
    }

    private UserProfile prepareUserProfile(String profileName) {
        String path = this.userProfileConfigDir + "/" + profileName + ".yaml";
        YamlDocumentReader reader = new YamlDocumentReader(new File(path));
        UserProfile profile = reader.readValueAsObject("$", UserProfile.class);
        profile.setAppName(this.appName);
        return profile;
    }

    private boolean isDatabaseProfileExist(String profileName) {
        String path = this.dbProfileConfigDir + "/" + profileName + ".yaml";
        return new File(path).exists();
    }

    private DatabaseProfile prepareDatabaseProfile(String profileName) {
        String path = this.dbProfileConfigDir + "/" + profileName + ".yaml";
        YamlDocumentReader reader = new YamlDocumentReader(new File(path));
        DatabaseProfile profile = reader.readValueAsObject("$", DatabaseProfile.class);
        profile.setAppName(this.appName);
        return profile;
    }

    private void initAppDriverConfig(String appDriverConfigFileName) {
        if (appDriverConfigFileName == null || "".equals(appDriverConfigFileName.trim())) {
            if (!"DEFAULT-APP".equals(this.appName)) {
                Assert.fail((String)("FATAL: Please specify 'appDriverConfigFileName' in AppConfig.yaml. AppName: " + this.appName + ". Exiting ..."));
                System.exit(1);
            }
        } else {
            String driverCfgFile = this.appsConfigDir + File.separator + this.appName + File.separator + "driver-configs" + File.separator + appDriverConfigFileName;
            Assert.assertTrue((boolean)new File(driverCfgFile).exists(), (String)("Missing '" + driverCfgFile + "' file for '" + this.appName + "' application."));
            try {
                YamlDocumentReader yamlReader = new YamlDocumentReader(new File(driverCfgFile));
                this.appDriverConfig = new AppDriverConfig(this, yamlReader.getDocumentContext());
            }
            catch (Exception ex) {
                Assert.fail((String)("Failed to read property file - " + driverCfgFile + ". Going to exit..."), (Throwable)ex);
                System.exit(1);
            }
        }
    }

    public String getName() {
        return this.appName;
    }

    public ApplicationType getAppType() {
        return this.appType;
    }

    public PlatformType getTestPlatformType() {
        return this.testPlatformType;
    }

    public String getAppLaunchUrl() {
        return this.appLaunchUrl;
    }

    public String getAppLoginPageValidatorClass() {
        return this.appLoginPageValidatorClass;
    }

    public String getAppLoginSuccessPageValidatorClass() {
        return this.appLoginSuccessPageValidatorClass;
    }

    public String getRemoteWebDriverProviderClass() {
        return this.remoteWebDriverProviderClass;
    }

    public RemoteWebDriverProvider getRemoteWebDriverProvider() {
        return this.remoteWebDriverProvider;
    }

    public WebBrowserType getAppWebBrowser() {
        return this.appWebBrowser;
    }

    public boolean isEnableWebBrowserExtension() {
        return this.enableWebBrowserExtension;
    }

    public Dimension getBrowserWindowSize() {
        return this.browserWindowSize;
    }

    public String getUserProfileConfigDir() {
        return this.userProfileConfigDir;
    }

    public String getDbProfileConfigDir() {
        return this.dbProfileConfigDir;
    }

    public ProxyConfiguration getProxyConfig() {
        return this.proxyConfig;
    }

    public UserProfile getUserProfile(String profileName) {
        UserProfile profile = this.userProfiles.get(profileName);
        return profile;
    }

    public DatabaseProfile getDatabaseProfile(String profileName) {
        DatabaseProfile profile = this.dbProfiles.get(profileName);
        return profile;
    }

    public <T> T getAdditionalPropertyValue(String propName, Class<T> clazz) {
        Assert.assertTrue((boolean)this.additionalProps.containsKey(propName), (String)("Please specify the additional property '" + propName + "' in application '" + this.appName + "' AppConfig.yaml file."));
        return clazz.cast(this.additionalProps.get(propName));
    }

    public EnvironmentConfig getEnvironmentConfig() {
        return this.environmentConfig;
    }

    public Collection<UserProfile> getUserProfiles() {
        return this.userProfiles.values();
    }

    public Collection<DatabaseProfile> getDatabaseProfiles() {
        return this.dbProfiles.values();
    }
}

