/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.config;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.TypeRef;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.openqa.selenium.PageLoadStrategy;
import org.openqa.selenium.UnexpectedAlertBehaviour;
import org.uitnet.testing.smartfwk.ui.core.commons.Locations;
import org.uitnet.testing.smartfwk.ui.core.config.AppConfig;
import org.uitnet.testing.smartfwk.ui.core.config.WebBrowserType;
import org.uitnet.testing.smartfwk.ui.core.utils.JsonYamlUtil;
import org.uitnet.testing.smartfwk.ui.core.utils.OSDetectorUtil;
import org.uitnet.testing.smartfwk.ui.core.utils.StringUtil;

public class AppDriverConfig {
    private WebBrowserType browserType = null;
    private String driverSystemPropertyName;
    private String driverBinaryFilePath;
    private String driverFileName;
    private String remoteDriverURL;
    private boolean headless = false;
    private PageLoadStrategy pageLoadStrategy = PageLoadStrategy.NORMAL;
    private UnexpectedAlertBehaviour unexpectedAlertBehaviour = UnexpectedAlertBehaviour.DISMISS;
    private Level logLevel = Level.SEVERE;
    private List<String> arguments;
    private Map<String, Object> driverCapabilities;
    private Map<String, Object> experimentalOptions;
    private Map<String, Object> browserExtensions;
    private List<File> browserExtensionFiles;
    private boolean deleteExtensionsCacheIfItExists = true;
    private boolean alwaysLoadNoFocusLib = false;
    private Map<String, Object> browserPreferences;
    private boolean acceptInsecureCertificates = false;
    private boolean acceptUntrustedCertificates = false;
    private boolean assumeUntrustedCertificateIssuer = false;
    private Map<String, String> webAttrMap;
    private String profilePath;
    private Integer scriptTimeoutInSecs = 60;
    private Integer pageLoadTimeoutInSecs = 60;
    private AppConfig appConfig;
    private DocumentContext defaultYamlProps;

    public AppDriverConfig(AppConfig appConfig, DocumentContext yamlDoc) {
        this.appConfig = appConfig;
        this.defaultYamlProps = yamlDoc;
        this.arguments = new ArrayList<String>();
        this.driverCapabilities = new HashMap<String, Object>();
        this.experimentalOptions = new HashMap<String, Object>();
        this.browserExtensionFiles = new ArrayList<File>();
        this.browserPreferences = new HashMap<String, Object>();
        this.webAttrMap = new HashMap<String, String>();
        this.init(yamlDoc, null);
    }

    private AppDriverConfig(AppConfig appConfig, DocumentContext yamlDoc, DocumentContext overriddenYamlDoc) {
        this.appConfig = appConfig;
        this.defaultYamlProps = yamlDoc;
        this.arguments = new ArrayList<String>();
        this.driverCapabilities = new HashMap<String, Object>();
        this.experimentalOptions = new HashMap<String, Object>();
        this.browserExtensionFiles = new ArrayList<File>();
        this.browserPreferences = new HashMap<String, Object>();
        this.webAttrMap = new HashMap<String, String>();
        this.init(yamlDoc, overriddenYamlDoc);
    }

    private void init(DocumentContext yamlDoc, DocumentContext overriddenYamlDoc) {
        String value;
        String args;
        this.browserType = WebBrowserType.valueOf2(JsonYamlUtil.readNoException("$.browserType", String.class, yamlDoc, overriddenYamlDoc));
        this.driverSystemPropertyName = JsonYamlUtil.readNoException("$.driverSystemPropertyName", String.class, yamlDoc, overriddenYamlDoc);
        this.driverBinaryFilePath = JsonYamlUtil.readNoException("$.driverBinaryFilePath", String.class, yamlDoc, overriddenYamlDoc);
        if (this.driverBinaryFilePath == null) {
            this.driverFileName = JsonYamlUtil.readNoException("$.driverFileName", String.class, yamlDoc, overriddenYamlDoc);
            this.driverBinaryFilePath = Locations.getProjectRootDir() + File.separator + "test-config" + File.separator + "app-drivers" + File.separator + OSDetectorUtil.getHostPlatform().getType() + File.separator + this.appConfig.getAppType().getType() + File.separator + this.browserType.getType() + File.separator + this.driverFileName;
        }
        this.remoteDriverURL = JsonYamlUtil.readNoException("$.remoteDriverURL", String.class, yamlDoc, overriddenYamlDoc);
        this.headless = Boolean.parseBoolean(JsonYamlUtil.readNoException("$.headless", String.class, yamlDoc, overriddenYamlDoc));
        this.pageLoadStrategy = PageLoadStrategy.fromString((String)JsonYamlUtil.readNoException("$.pageLoadStrategy", String.class, yamlDoc, overriddenYamlDoc));
        this.unexpectedAlertBehaviour = UnexpectedAlertBehaviour.fromString((String)JsonYamlUtil.readNoException("$.unexpectedAlertBehaviour", String.class, yamlDoc, overriddenYamlDoc));
        if (JsonYamlUtil.readNoException("$.logLevel", String.class, yamlDoc, overriddenYamlDoc) != null) {
            this.logLevel = Level.parse(JsonYamlUtil.readNoException("$.logLevel", String.class, yamlDoc, overriddenYamlDoc));
        }
        if (!StringUtil.isEmptyAfterTrim(args = JsonYamlUtil.readNoException("$.driverArguments", String.class, yamlDoc, overriddenYamlDoc))) {
            String[] argArr = args.split(" ");
            for (String a : argArr) {
                if (StringUtil.isEmptyAfterTrim(a)) continue;
                this.arguments.add(a.trim());
            }
        }
        this.driverCapabilities = JsonYamlUtil.readNoException("$.driverCapabilities", new TypeRef<Map<String, Object>>(){}, yamlDoc, overriddenYamlDoc);
        this.webAttrMap = JsonYamlUtil.readNoException("$.webAttrMap", new TypeRef<Map<String, String>>(){}, yamlDoc, overriddenYamlDoc);
        this.experimentalOptions = JsonYamlUtil.readNoException("$.experimentalOptions", new TypeRef<Map<String, Object>>(){}, yamlDoc, overriddenYamlDoc);
        this.browserExtensions = JsonYamlUtil.readNoException("$.browserExtensions", new TypeRef<Map<String, Object>>(){}, yamlDoc, overriddenYamlDoc);
        if (this.browserExtensions != null && this.browserExtensions.size() > 0) {
            for (Map.Entry entry : this.browserExtensions.entrySet()) {
                this.browserExtensionFiles.add(new File(this.driverBinaryFilePath + File.separator + OSDetectorUtil.getHostPlatform().getType() + File.separator + this.appConfig.getAppType().getType() + File.separator + this.browserType.name() + File.separator + "extensions" + File.separator + entry.getValue()));
            }
        }
        this.browserPreferences = JsonYamlUtil.readNoException("$.browserPreferences", new TypeRef<Map<String, Object>>(){}, yamlDoc, overriddenYamlDoc);
        this.deleteExtensionsCacheIfItExists = Boolean.parseBoolean(JsonYamlUtil.readNoException("$.deleteExtensionsCacheIfItExists", String.class, yamlDoc, overriddenYamlDoc));
        this.alwaysLoadNoFocusLib = Boolean.parseBoolean(JsonYamlUtil.readNoException("$.alwaysLoadNoFocusLib", String.class, yamlDoc, overriddenYamlDoc));
        this.acceptInsecureCertificates = Boolean.parseBoolean(JsonYamlUtil.readNoException("$.acceptInsecureCertificates", String.class, yamlDoc, overriddenYamlDoc));
        this.acceptUntrustedCertificates = Boolean.parseBoolean(JsonYamlUtil.readNoException("$.acceptUntrustedCertificates", String.class, yamlDoc, overriddenYamlDoc));
        this.assumeUntrustedCertificateIssuer = Boolean.parseBoolean(JsonYamlUtil.readNoException("$.assumeUntrustedCertificateIssuer", String.class, yamlDoc, overriddenYamlDoc));
        this.profilePath = this.appConfig.getAppsConfigDir() + File.separator + this.appConfig.getAppName() + File.separator + "profile";
        if (!new File(this.profilePath).exists()) {
            new File(this.profilePath).mkdirs();
        }
        if ((value = JsonYamlUtil.readNoException("$.scriptTimeoutInSeconds", String.class, yamlDoc, overriddenYamlDoc)) != null) {
            this.scriptTimeoutInSecs = Integer.parseInt(value);
        }
        if ((value = JsonYamlUtil.readNoException("$.pageLoadTimeoutInSeconds", String.class, yamlDoc, overriddenYamlDoc)) != null) {
            this.pageLoadTimeoutInSecs = Integer.parseInt(value);
        }
    }

    public AppDriverConfig getUpdatedProperties(DocumentContext updatedJsonProps) {
        if (updatedJsonProps == null) {
            return this;
        }
        AppDriverConfig updatedConfig = new AppDriverConfig(this.appConfig, this.defaultYamlProps, updatedJsonProps);
        return updatedConfig;
    }

    public WebBrowserType getBrowserType() {
        return this.browserType;
    }

    public void setBrowserType(WebBrowserType browserType) {
        this.browserType = browserType;
    }

    public String getDriverSystemPropertyName() {
        return this.driverSystemPropertyName;
    }

    public void setDriverSystemPropertyName(String driverSystemPropertyName) {
        this.driverSystemPropertyName = driverSystemPropertyName;
    }

    public String getDriverBinaryFilePath() {
        return this.driverBinaryFilePath;
    }

    public void setDriverBinaryFilePath(String driverBinaryFilePath) {
        this.driverBinaryFilePath = driverBinaryFilePath;
    }

    public String getDriverFileName() {
        return this.driverFileName;
    }

    public String getRemoteDriverURL() {
        return this.remoteDriverURL;
    }

    public boolean isHeadless() {
        return this.headless;
    }

    public void setHeadless(boolean headless) {
        this.headless = headless;
    }

    public PageLoadStrategy getPageLoadStrategy() {
        return this.pageLoadStrategy;
    }

    public void setPageLoadStrategy(PageLoadStrategy pageLoadStrategy) {
        this.pageLoadStrategy = pageLoadStrategy;
    }

    public UnexpectedAlertBehaviour getUnexpectedAlertBehaviour() {
        return this.unexpectedAlertBehaviour;
    }

    public void setUnexpectedAlertBehaviour(UnexpectedAlertBehaviour unexpectedAlertBehaviour) {
        this.unexpectedAlertBehaviour = unexpectedAlertBehaviour;
    }

    public Level getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(Level logLevel) {
        this.logLevel = logLevel;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<String> arguments) {
        this.arguments = arguments;
    }

    public Map<String, Object> getDriverCapabilities() {
        return this.driverCapabilities;
    }

    public void setDriverCapabilities(Map<String, Object> driverCapabilities) {
        this.driverCapabilities = driverCapabilities;
    }

    public Map<String, Object> getExperimentalOptions() {
        return this.experimentalOptions;
    }

    public void setExperimentalOptions(Map<String, Object> experimentalOptions) {
        this.experimentalOptions = experimentalOptions;
    }

    public List<File> getBrowserExtensionFiles() {
        return this.browserExtensionFiles;
    }

    public void setBrowserExtensionFiles(List<File> browserExtensionFiles) {
        this.browserExtensionFiles = browserExtensionFiles;
    }

    public boolean isDeleteExtensionsCacheIfItExists() {
        return this.deleteExtensionsCacheIfItExists;
    }

    public void setDeleteExtensionsCacheIfItExists(boolean deleteExtensionsCacheIfItExists) {
        this.deleteExtensionsCacheIfItExists = deleteExtensionsCacheIfItExists;
    }

    public boolean isAlwaysLoadNoFocusLib() {
        return this.alwaysLoadNoFocusLib;
    }

    public void setAlwaysLoadNoFocusLib(boolean alwaysLoadNoFocusLib) {
        this.alwaysLoadNoFocusLib = alwaysLoadNoFocusLib;
    }

    public Map<String, Object> getBrowserPreferences() {
        return this.browserPreferences;
    }

    public Map<String, String> getWebAttrMap() {
        return this.webAttrMap;
    }

    public void setBrowserPreferences(Map<String, Object> browserPreferences) {
        this.browserPreferences = browserPreferences;
    }

    public boolean isAcceptInsecureCertificates() {
        return this.acceptInsecureCertificates;
    }

    public void setAcceptInsecureCertificates(boolean acceptInsecureCertificates) {
        this.acceptInsecureCertificates = acceptInsecureCertificates;
    }

    public boolean isAcceptUntrustedCertificates() {
        return this.acceptUntrustedCertificates;
    }

    public void setAcceptUntrustedCertificates(boolean acceptUntrustedCertificates) {
        this.acceptUntrustedCertificates = acceptUntrustedCertificates;
    }

    public boolean isAssumeUntrustedCertificateIssuer() {
        return this.assumeUntrustedCertificateIssuer;
    }

    public void setAssumeUntrustedCertificateIssuer(boolean assumeUntrustedCertificateIssuer) {
        this.assumeUntrustedCertificateIssuer = assumeUntrustedCertificateIssuer;
    }

    public String getProfilePath() {
        return this.profilePath;
    }

    public void setProfilePath(String profilePath) {
        this.profilePath = profilePath;
    }

    public Integer getScriptTimeoutInSecs() {
        return this.scriptTimeoutInSecs;
    }

    public void setScriptTimeoutInSecs(Integer scriptTimeoutInSecs) {
        this.scriptTimeoutInSecs = scriptTimeoutInSecs;
    }

    public Integer getPageLoadTimeoutInSecs() {
        return this.pageLoadTimeoutInSecs;
    }

    public void setPageLoadTimeoutInSecs(Integer pageLoadTimeoutInSecs) {
        this.pageLoadTimeoutInSecs = pageLoadTimeoutInSecs;
    }
}

