/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.objects;

import java.awt.Rectangle;
import java.util.Iterator;
import org.openqa.selenium.WebElement;
import org.sikuli.script.Match;
import org.sikuli.script.Region;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.appdriver.SmartAppDriver;
import org.uitnet.testing.smartfwk.ui.core.commons.UIObjectType;
import org.uitnet.testing.smartfwk.ui.core.objects.ImageObject;
import org.uitnet.testing.smartfwk.ui.core.objects.ImageObjectValidator;
import org.uitnet.testing.smartfwk.ui.core.objects.ObjectLocationType;
import org.uitnet.testing.smartfwk.ui.core.objects.ReferenceObjectPosition;
import org.uitnet.testing.smartfwk.ui.core.objects.UIObject;

public class ObjectLocation {
    private ObjectLocationType objLocType;
    private int x;
    private int y;
    private int width;
    private int height;
    private UIObject refObject;
    private ReferenceObjectPosition refObjectPosition;
    private int refObjectDistanceInPx;
    private int leftMarginOfRefObjectInPx;

    public ObjectLocation() {
        this.objLocType = ObjectLocationType.WITHIN_SCREEN_LIMIT;
        this.refObjectDistanceInPx = 0;
        this.leftMarginOfRefObjectInPx = 10;
    }

    public ObjectLocation(int x, int y, int width, int height) {
        this.objLocType = ObjectLocationType.WITHIN_CUSTOM_LIMIT;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.refObjectDistanceInPx = 0;
        this.leftMarginOfRefObjectInPx = 10;
    }

    public ObjectLocation(Rectangle area) {
        this.objLocType = ObjectLocationType.WITHIN_CUSTOM_LIMIT;
        this.x = area.x;
        this.y = area.y;
        this.width = area.width;
        this.height = area.height;
        this.refObjectDistanceInPx = 0;
        this.leftMarginOfRefObjectInPx = 10;
    }

    public ObjectLocation(UIObject refObject, ReferenceObjectPosition refObjectPosition, int refObjDistanceInPx) {
        this.objLocType = ObjectLocationType.RELATIVE_TO_REF_OBJ;
        this.refObject = refObject;
        this.refObjectPosition = refObjectPosition;
        this.refObjectDistanceInPx = refObjDistanceInPx;
        this.leftMarginOfRefObjectInPx = 10;
    }

    public ObjectLocation setLeftMarginOfRefObject(int leftMarginOfRefObjectInPx) {
        this.leftMarginOfRefObjectInPx = leftMarginOfRefObjectInPx > 10 ? leftMarginOfRefObjectInPx : 10;
        return this;
    }

    public Rectangle getRectangleOfImageObject(SmartAppDriver appDriver, String leftSideImageOfImageObject, String rightSideImageOfImageObject) {
        switch (this.objLocType) {
            case WITHIN_CUSTOM_LIMIT: 
            case WITHIN_SCREEN_LIMIT: {
                Region region = null;
                region = this.objLocType == ObjectLocationType.WITHIN_SCREEN_LIMIT ? new Region(appDriver.getSikuliScreen().getRect()) : new Region(this.x, this.y, this.width, this.height);
                region.setAutoWaitTimeout(1.0);
                ImageObject obj = new ImageObject(UIObjectType.leftSideImageOfRectangle, "Left Side Image", leftSideImageOfImageObject);
                Object m1 = obj.getValidator(appDriver, region).findElements(3);
                obj = new ImageObject(UIObjectType.rightSideImageOfRectangle, "Right Side Image", rightSideImageOfImageObject);
                Object m2 = obj.getValidator(appDriver, region).findElements(3);
                Rectangle objDim = new Rectangle();
                objDim.x = ((Match)m1.get((int)0)).x;
                objDim.y = ((Match)m1.get((int)0)).y;
                objDim.width = ((Match)m2.get((int)0)).x - objDim.x;
                objDim.height = ((Match)m2.get((int)0)).y - objDim.y;
                return objDim;
            }
            case RELATIVE_TO_REF_OBJ: {
                return this.calculateRectangleOfImgObjUsingRefObj(appDriver, leftSideImageOfImageObject, rightSideImageOfImageObject);
            }
        }
        return null;
    }

    public Rectangle getRectangleOfImageObject(SmartAppDriver appDriver, int width, int height) {
        switch (this.objLocType) {
            case WITHIN_CUSTOM_LIMIT: 
            case WITHIN_SCREEN_LIMIT: {
                Assert.fail((String)"Size based components not supported for WITHIN_CUSTOM_LIMIT, WITHIN_SCREEN_LIMIT.");
                return null;
            }
            case RELATIVE_TO_REF_OBJ: {
                return this.calculateRectangleOfImgObjUsingRefObj(appDriver, width, height);
            }
        }
        return null;
    }

    private Rectangle calculateRectangleOfImgObjUsingRefObj(SmartAppDriver appDriver, String leftSideImageOfImageObject, String rightSideImageOfImageObject) {
        Rectangle rect = null;
        ImageObject leftSideImgObj = new ImageObject(UIObjectType.leftSideImageOfRectangle, "Left Side Image", leftSideImageOfImageObject);
        ImageObjectValidator imgValidator = leftSideImgObj.getValidator(appDriver, null);
        Object leftSideImgMatches = imgValidator.findElements(3);
        ImageObject rightSideImgObj = new ImageObject(UIObjectType.rightSideImageOfRectangle, "Right Side Image", rightSideImageOfImageObject);
        imgValidator = rightSideImgObj.getValidator(appDriver, null);
        imgValidator.getRegion().setAutoWaitTimeout(1.0);
        Object rightSideImgMatches = imgValidator.findElements(0);
        Object refElem = this.refObject.getValidator(appDriver, null).findElement(0);
        Rectangle refElemRect = null;
        if (refElem instanceof Match) {
            Match refElemAsImg = (Match)refElem;
            refElemRect = refElemAsImg.getRect();
        } else if (refElem instanceof WebElement) {
            WebElement refElemAsDOM = (WebElement)refElem;
            refElemRect = new Rectangle(refElemAsDOM.getRect().getX(), refElemAsDOM.getRect().getY(), refElemAsDOM.getRect().getWidth(), refElemAsDOM.getRect().getHeight());
        }
        Assert.assertNotNull((Object)refElemRect, (String)("Failed to find reference element '" + this.refObject.getDisplayName() + "'."));
        int refObjX1 = Double.valueOf(refElemRect.getX()).intValue();
        int refObjY1 = Double.valueOf(refElemRect.getY()).intValue();
        int refObjX2 = Double.valueOf(refElemRect.getX() + refElemRect.getWidth()).intValue();
        int refObjY2 = Double.valueOf(refElemRect.getY() + refElemRect.getHeight()).intValue();
        switch (this.refObjectPosition) {
            case LEFT: {
                int refObjCenterY = refObjY1 + (refObjY2 - refObjY1) / 2;
                int refObjXDistanceFromM1 = 999999999;
                Match nearestLeftSideMatch = null;
                Iterator iterator = leftSideImgMatches.iterator();
                while (iterator.hasNext()) {
                    Match m1 = (Match)iterator.next();
                    int m1Y2 = m1.getY() + m1.getH();
                    int m1X2 = m1.getX() + m1.getW();
                    if (refObjCenterY < m1.getY() || refObjCenterY > m1Y2 || m1X2 < refObjX2 || m1X2 - refObjX2 >= refObjXDistanceFromM1) continue;
                    refObjXDistanceFromM1 = m1X2 - refObjX2;
                    nearestLeftSideMatch = m1;
                }
                Assert.assertNotNull(nearestLeftSideMatch, (String)("Failed to find nearest leftSideImage '" + leftSideImageOfImageObject + "' relative to refernce object '" + this.refObject.getDisplayName() + "'."));
                int objectRangeFromRefObject = refObjX2 + this.refObjectDistanceInPx;
                Assert.assertTrue((nearestLeftSideMatch.getX() <= objectRangeFromRefObject ? 1 : 0) != 0, (String)("Failed to find object within the horizontal range (" + refObjX2 + ", " + objectRangeFromRefObject + "). Probably you can increase refObjectDistanceInPx (" + this.refObjectDistanceInPx + ") parameter value."));
                int refObjXDistanceFromM2 = 999999999;
                Match nearestRightSideMatch = null;
                iterator = rightSideImgMatches.iterator();
                while (iterator.hasNext()) {
                    Match m2 = (Match)iterator.next();
                    int m2Y2 = m2.getY() + m2.getH();
                    if (refObjCenterY < m2.getY() || refObjCenterY > m2Y2 || m2.getX() < nearestLeftSideMatch.getX() || m2.getX() - nearestLeftSideMatch.getX() >= refObjXDistanceFromM2 || m2.getX() <= nearestLeftSideMatch.getX() + nearestLeftSideMatch.getW()) continue;
                    refObjXDistanceFromM2 = m2.getX() - nearestLeftSideMatch.getX();
                    nearestRightSideMatch = m2;
                }
                Assert.assertNotNull(nearestRightSideMatch, (String)("Failed to find nearest rightSideImage '" + rightSideImageOfImageObject + "' relative to refernce object '" + this.refObject.getDisplayName() + "'."));
                rect = new Rectangle(nearestLeftSideMatch.getX() + nearestLeftSideMatch.getW(), nearestLeftSideMatch.getY(), nearestRightSideMatch.getX() - nearestLeftSideMatch.getX(), nearestLeftSideMatch.getH());
                break;
            }
            case RIGHT: {
                int refObjCenterY = refObjY1 + (refObjY2 - refObjY1) / 2;
                int refObjXDistanceFromM1 = 999999999;
                Match nearestRightSideMatch = null;
                Iterator iterator = rightSideImgMatches.iterator();
                while (iterator.hasNext()) {
                    Match m1 = (Match)iterator.next();
                    int m1Y2 = m1.getY() + m1.getH();
                    if (refObjCenterY < m1.getY() || refObjCenterY > m1Y2 || refObjX1 < m1.getX() || refObjX1 - m1.getX() >= refObjXDistanceFromM1) continue;
                    refObjXDistanceFromM1 = refObjX1 - m1.getX();
                    nearestRightSideMatch = m1;
                }
                Assert.assertNotNull(nearestRightSideMatch, (String)("Failed to find nearest rightSideImage '" + rightSideImageOfImageObject + "' relative to refernce object '" + this.refObject.getDisplayName() + "'."));
                int objectRangeFromRefObject = refObjX1 - this.refObjectDistanceInPx;
                int nearestRightSideMatchX2 = nearestRightSideMatch.getX() + nearestRightSideMatch.getW();
                Assert.assertTrue((nearestRightSideMatchX2 >= objectRangeFromRefObject ? 1 : 0) != 0, (String)("Failed to find object within the horizontal range (" + refObjX1 + ", " + objectRangeFromRefObject + "). Probably you can increase refObjectDistanceInPx (" + this.refObjectDistanceInPx + ") parameter value."));
                int refObjXDistanceFromM2 = 999999999;
                Match nearestLeftSideMatch = null;
                iterator = leftSideImgMatches.iterator();
                while (iterator.hasNext()) {
                    Match m2 = (Match)iterator.next();
                    int m2Y2 = m2.getY() + m2.getH();
                    if (refObjCenterY < m2.getY() || refObjCenterY > m2Y2 || nearestRightSideMatchX2 < m2.getX() || nearestRightSideMatchX2 - m2.getX() >= refObjXDistanceFromM2 || nearestRightSideMatchX2 <= m2.getX() + m2.getW()) continue;
                    refObjXDistanceFromM2 = nearestRightSideMatch.getX() - m2.getX();
                    nearestLeftSideMatch = m2;
                }
                Assert.assertNotNull(nearestLeftSideMatch, (String)("Failed to find nearest leftSideImage '" + leftSideImageOfImageObject + "' relative to refernce object '" + this.refObject.getDisplayName() + "'."));
                rect = new Rectangle(nearestLeftSideMatch.getX() + nearestLeftSideMatch.getW(), nearestLeftSideMatch.getY(), nearestRightSideMatch.getX() - nearestLeftSideMatch.getX(), nearestLeftSideMatch.getH());
                break;
            }
            case TOP: {
                int refObjCenterY = refObjY2 + this.refObjectDistanceInPx;
                int leftObjX2 = refObjX1 - this.leftMarginOfRefObjectInPx;
                int refObjXDistanceFromM1 = 999999999;
                Match nearestLeftSideMatch = null;
                Iterator iterator = leftSideImgMatches.iterator();
                while (iterator.hasNext()) {
                    Match m1 = (Match)iterator.next();
                    int m1Y2 = m1.getY() + m1.getH();
                    if (refObjCenterY < m1.getY() || refObjCenterY > m1Y2 || m1.getX() < leftObjX2 || m1.getX() - leftObjX2 >= refObjXDistanceFromM1) continue;
                    refObjXDistanceFromM1 = m1.getX() - leftObjX2;
                    nearestLeftSideMatch = m1;
                }
                Assert.assertNotNull(nearestLeftSideMatch, (String)("Failed to find nearest leftSideImage '" + leftSideImageOfImageObject + "' relative to refernce object '" + this.refObject.getDisplayName() + "'."));
                int objectRangeFromRefObject = leftObjX2 + Double.valueOf(refElemRect.getWidth()).intValue();
                Assert.assertTrue((nearestLeftSideMatch.getX() <= objectRangeFromRefObject ? 1 : 0) != 0, (String)("Failed to find object within the horizontal range (" + leftObjX2 + ", " + objectRangeFromRefObject + "). Probably you can increase refObject size by taking the bigger horizontal snapshot."));
                int refObjXDistanceFromM2 = 999999999;
                Match nearestRightSideMatch = null;
                iterator = rightSideImgMatches.iterator();
                while (iterator.hasNext()) {
                    Match m2 = (Match)iterator.next();
                    int m2Y2 = m2.getY() + m2.getH();
                    if (refObjCenterY < m2.getY() || refObjCenterY > m2Y2 || m2.getX() < nearestLeftSideMatch.getX() || m2.getX() - nearestLeftSideMatch.getX() >= refObjXDistanceFromM2 || m2.getX() <= nearestLeftSideMatch.getX() + nearestLeftSideMatch.getW()) continue;
                    refObjXDistanceFromM2 = m2.getX() - nearestLeftSideMatch.getX();
                    nearestRightSideMatch = m2;
                }
                Assert.assertNotNull(nearestRightSideMatch, (String)("Failed to find nearest rightSideImage '" + rightSideImageOfImageObject + "' relative to refernce object '" + this.refObject.getDisplayName() + "'."));
                rect = new Rectangle(nearestLeftSideMatch.getX() + nearestLeftSideMatch.getW(), nearestLeftSideMatch.getY(), nearestRightSideMatch.getX() - nearestLeftSideMatch.getX(), nearestLeftSideMatch.getH());
                break;
            }
            case BOTTOM: {
                int refObjCenterY = refObjY1 - this.refObjectDistanceInPx;
                int leftObjX2 = refObjX1 - this.leftMarginOfRefObjectInPx;
                int refObjXDistanceFromM1 = 999999999;
                Match nearestLeftSideMatch = null;
                Iterator iterator = leftSideImgMatches.iterator();
                while (iterator.hasNext()) {
                    Match m1 = (Match)iterator.next();
                    int m1Y2 = m1.getY() + m1.getH();
                    if (refObjCenterY < m1.getY() || refObjCenterY > m1Y2 || m1.getX() < leftObjX2 || m1.getX() - leftObjX2 >= refObjXDistanceFromM1) continue;
                    refObjXDistanceFromM1 = m1.getX() - leftObjX2;
                    nearestLeftSideMatch = m1;
                }
                Assert.assertNotNull(nearestLeftSideMatch, (String)("Failed to find nearest leftSideImage '" + leftSideImageOfImageObject + "' relative to refernce object '" + this.refObject.getDisplayName() + "'."));
                int objectRangeFromRefObject = leftObjX2 + Double.valueOf(refElemRect.getWidth()).intValue();
                Assert.assertTrue((nearestLeftSideMatch.getX() <= objectRangeFromRefObject ? 1 : 0) != 0, (String)("Failed to find object within the horizontal range (" + leftObjX2 + ", " + objectRangeFromRefObject + "). Probably you can increase refObject size by taking the bigger horizontal snapshot."));
                int refObjXDistanceFromM2 = 999999999;
                Match nearestRightSideMatch = null;
                iterator = rightSideImgMatches.iterator();
                while (iterator.hasNext()) {
                    Match m2 = (Match)iterator.next();
                    int m2Y2 = m2.getY() + m2.getH();
                    if (refObjCenterY < m2.getY() || refObjCenterY > m2Y2 || m2.getX() < nearestLeftSideMatch.getX() || m2.getX() - nearestLeftSideMatch.getX() >= refObjXDistanceFromM2 || m2.getX() <= nearestLeftSideMatch.getX() + nearestLeftSideMatch.getW()) continue;
                    refObjXDistanceFromM2 = m2.getX() - nearestLeftSideMatch.getX();
                    nearestRightSideMatch = m2;
                }
                Assert.assertNotNull(nearestRightSideMatch, (String)("Failed to find nearest rightSideImage '" + rightSideImageOfImageObject + "' relative to refernce object '" + this.refObject.getDisplayName() + "'."));
                rect = new Rectangle(nearestLeftSideMatch.getX() + nearestLeftSideMatch.getW(), nearestLeftSideMatch.getY(), nearestRightSideMatch.getX() - nearestLeftSideMatch.getX(), nearestLeftSideMatch.getH());
            }
        }
        return rect;
    }

    private Rectangle calculateRectangleOfImgObjUsingRefObj(SmartAppDriver appDriver, int width, int height) {
        Rectangle rect = null;
        Object refElem = this.refObject.getValidator(appDriver, null).findElement(0);
        Rectangle refElemRect = null;
        if (refElem instanceof Match) {
            Match refElemAsImg = (Match)refElem;
            refElemRect = refElemAsImg.getRect();
        } else if (refElem instanceof WebElement) {
            WebElement refElemAsDOM = (WebElement)refElem;
            refElemRect = new Rectangle(refElemAsDOM.getRect().getX(), refElemAsDOM.getRect().getY(), refElemAsDOM.getRect().getWidth(), refElemAsDOM.getRect().getHeight());
        }
        Assert.assertNotNull((Object)refElemRect, (String)("Failed to find reference element '" + this.refObject.getDisplayName() + "'."));
        int refObjX1 = Double.valueOf(refElemRect.getX()).intValue();
        int refObjY1 = Double.valueOf(refElemRect.getY()).intValue();
        int refObjX2 = Double.valueOf(refElemRect.getX() + refElemRect.getWidth()).intValue();
        int refObjY2 = Double.valueOf(refElemRect.getY() + refElemRect.getHeight()).intValue();
        switch (this.refObjectPosition) {
            case LEFT: {
                int elemX1 = refObjX2;
                int elemY1 = refObjY1 + this.refObjectDistanceInPx;
                rect = new Rectangle(elemX1, elemY1, width, height);
                break;
            }
            case RIGHT: {
                int elemX1 = refObjX1 - width;
                int elemY1 = refObjY1 + this.refObjectDistanceInPx;
                rect = new Rectangle(elemX1, elemY1, width, height);
                break;
            }
            case TOP: {
                int elemX1 = refObjX1 - this.leftMarginOfRefObjectInPx;
                int elemY1 = refObjY2;
                rect = new Rectangle(elemX1, elemY1, width, height);
                break;
            }
            case BOTTOM: {
                int elemX1 = refObjX1 - this.leftMarginOfRefObjectInPx;
                int elemY1 = refObjY1 - height;
                rect = new Rectangle(elemX1, elemY1, width, height);
            }
        }
        return rect;
    }

    private Rectangle calculateRectangleOfImgObjUsingRefObj(SmartAppDriver appDriver, String imageObject) {
        Rectangle rect = null;
        ImageObject imgObject = new ImageObject(UIObjectType.image, "Image Object", imageObject);
        ImageObjectValidator imgValidator = imgObject.getValidator(appDriver, null);
        imgValidator.getRegion().setAutoWaitTimeout(1.0);
        Object imgMatches = imgValidator.findElements(3);
        Object refElem = this.refObject.getValidator(appDriver, null).findElement(0);
        Rectangle refElemRect = null;
        if (refElem instanceof Match) {
            Match refElemAsImg = (Match)refElem;
            refElemRect = refElemAsImg.getRect();
        } else if (refElem instanceof WebElement) {
            WebElement refElemAsDOM = (WebElement)refElem;
            refElemRect = new Rectangle(refElemAsDOM.getRect().getX(), refElemAsDOM.getRect().getY(), refElemAsDOM.getRect().getWidth(), refElemAsDOM.getRect().getHeight());
        }
        Assert.assertNotNull((Object)refElemRect, (String)("Failed to find reference element '" + this.refObject.getDisplayName() + "'."));
        int refObjX1 = Double.valueOf(refElemRect.getX()).intValue();
        int refObjY1 = Double.valueOf(refElemRect.getY()).intValue();
        int refObjX2 = Double.valueOf(refElemRect.getX() + refElemRect.getWidth()).intValue();
        int refObjY2 = Double.valueOf(refElemRect.getY() + refElemRect.getHeight()).intValue();
        switch (this.refObjectPosition) {
            case LEFT: {
                int refObjCenterY = refObjY1 + (refObjY2 - refObjY1) / 2;
                int refObjXDistanceFromM1 = 999999999;
                Match nearestImageMatch = null;
                Iterator iterator = imgMatches.iterator();
                while (iterator.hasNext()) {
                    Match m1 = (Match)iterator.next();
                    int m1Y2 = m1.getY() + m1.getH();
                    if (refObjCenterY < m1.getY() || refObjCenterY > m1Y2 || m1.getX() < refObjX2 || m1.getX() - refObjX2 >= refObjXDistanceFromM1) continue;
                    refObjXDistanceFromM1 = m1.getX() - refObjX2;
                    nearestImageMatch = m1;
                }
                Assert.assertNotNull(nearestImageMatch, (String)("Failed to find nearest image '" + imageObject + "' relative to refernce object '" + this.refObject.getDisplayName() + "'."));
                int objectRangeFromRefObject = refObjX2 + this.refObjectDistanceInPx;
                Assert.assertTrue((nearestImageMatch.getX() <= objectRangeFromRefObject ? 1 : 0) != 0, (String)("Failed to find object within the horizontal range (" + refObjX2 + ", " + objectRangeFromRefObject + "). Probably you can increase refObjectDistanceInPx (" + this.refObjectDistanceInPx + ") parameter value."));
                rect = nearestImageMatch.getRect();
                break;
            }
            case RIGHT: {
                int refObjCenterY = refObjY1 + (refObjY2 - refObjY1) / 2;
                int refObjXDistanceFromM1 = 999999999;
                Match nearestImageMatch = null;
                Iterator iterator = imgMatches.iterator();
                while (iterator.hasNext()) {
                    Match m1 = (Match)iterator.next();
                    int m1Y2 = m1.getY() + m1.getH();
                    if (refObjCenterY < m1.getY() || refObjCenterY > m1Y2 || refObjX2 < m1.getX() || refObjX2 - m1.getX() >= refObjXDistanceFromM1) continue;
                    refObjXDistanceFromM1 = refObjX2 - m1.getX();
                    nearestImageMatch = m1;
                }
                Assert.assertNotNull(nearestImageMatch, (String)("Failed to find nearest image '" + imageObject + "' relative to refernce object '" + this.refObject.getDisplayName() + "'."));
                int objectRangeFromRefObject = refObjX1 - this.refObjectDistanceInPx;
                Assert.assertTrue((nearestImageMatch.getX() >= objectRangeFromRefObject ? 1 : 0) != 0, (String)("Failed to find object within the horizontal range (" + refObjX1 + ", " + objectRangeFromRefObject + "). Probably you can increase refObjectDistanceInPx (" + this.refObjectDistanceInPx + ") parameter value."));
                rect = nearestImageMatch.getRect();
                break;
            }
            case TOP: {
                int refObjCenterY = refObjY2 + this.refObjectDistanceInPx;
                int leftObjX2 = refObjX1 - this.leftMarginOfRefObjectInPx;
                int refObjXDistanceFromM1 = 999999999;
                Match nearestImageMatch = null;
                Iterator iterator = imgMatches.iterator();
                while (iterator.hasNext()) {
                    Match m1 = (Match)iterator.next();
                    int m1Y2 = m1.getY() + m1.getH();
                    if (refObjCenterY < m1.getY() || refObjCenterY > m1Y2 || m1.getX() < leftObjX2 || m1.getX() - leftObjX2 >= refObjXDistanceFromM1) continue;
                    refObjXDistanceFromM1 = m1.getX() - leftObjX2;
                    nearestImageMatch = m1;
                }
                Assert.assertNotNull(nearestImageMatch, (String)("Failed to find nearest leftSideImage '" + imageObject + "' relative to refernce object '" + this.refObject.getDisplayName() + "'."));
                int objectRangeFromRefObject = leftObjX2 + Double.valueOf(refElemRect.getWidth()).intValue();
                Assert.assertTrue((nearestImageMatch.getX() <= objectRangeFromRefObject ? 1 : 0) != 0, (String)("Failed to find object within the horizontal range (" + leftObjX2 + ", " + objectRangeFromRefObject + "). Probably you can increase refObject size by taking the bigger horizontal snapshot."));
                rect = nearestImageMatch.getRect();
                break;
            }
            case BOTTOM: {
                int refObjCenterY = refObjY1 - this.refObjectDistanceInPx;
                int leftObjX2 = refObjX1 - this.leftMarginOfRefObjectInPx;
                int refObjXDistanceFromM1 = 999999999;
                Match nearestImageMatch = null;
                Iterator iterator = imgMatches.iterator();
                while (iterator.hasNext()) {
                    Match m1 = (Match)iterator.next();
                    int m1Y2 = m1.getY() + m1.getH();
                    if (refObjCenterY < m1.getY() || refObjCenterY > m1Y2 || m1.getX() < leftObjX2 || m1.getX() - leftObjX2 >= refObjXDistanceFromM1) continue;
                    refObjXDistanceFromM1 = m1.getX() - leftObjX2;
                    nearestImageMatch = m1;
                }
                Assert.assertNotNull(nearestImageMatch, (String)("Failed to find nearest leftSideImage '" + imageObject + "' relative to refernce object '" + this.refObject.getDisplayName() + "'."));
                int objectRangeFromRefObject = leftObjX2 + Double.valueOf(refElemRect.getWidth()).intValue();
                Assert.assertTrue((nearestImageMatch.getX() <= objectRangeFromRefObject ? 1 : 0) != 0, (String)("Failed to find object within the horizontal range (" + leftObjX2 + ", " + objectRangeFromRefObject + "). Probably you can increase refObject size by taking the bigger horizontal snapshot."));
                rect = nearestImageMatch.getRect();
            }
        }
        return rect;
    }

    public Rectangle getImageObjectMatch(SmartAppDriver appDriver, String imageObject) {
        switch (this.objLocType) {
            case WITHIN_CUSTOM_LIMIT: 
            case WITHIN_SCREEN_LIMIT: {
                Region region = null;
                region = this.objLocType == ObjectLocationType.WITHIN_SCREEN_LIMIT ? new Region(appDriver.getSikuliScreen().getRect()) : new Region(this.x, this.y, this.width, this.height);
                region.setAutoWaitTimeout(1.0);
                ImageObject obj = new ImageObject(UIObjectType.image, "Image Object", imageObject);
                Object m1 = obj.getValidator(appDriver, region).findElements(3);
                Rectangle objDim = ((Match)m1.get(0)).getRect();
                return objDim;
            }
            case RELATIVE_TO_REF_OBJ: {
                return this.calculateRectangleOfImgObjUsingRefObj(appDriver, imageObject);
            }
        }
        return null;
    }

    public Region getRegion(SmartAppDriver appDriver) {
        if (ObjectLocationType.WITHIN_CUSTOM_LIMIT == this.objLocType) {
            return new Region(this.x, this.y, this.width, this.height);
        }
        if (ObjectLocationType.WITHIN_SCREEN_LIMIT == this.objLocType) {
            return new Region(appDriver.getSikuliScreen().getRect());
        }
        Assert.fail((String)"getRegion() api is applicable only for absolute location.");
        return null;
    }

    public Region getRegionOfImageObject(SmartAppDriver appDriver, String leftSideImageOfImageObject, String rightSideImageOfImageObject) {
        return new Region(this.getRectangleOfImageObject(appDriver, leftSideImageOfImageObject, rightSideImageOfImageObject));
    }

    public Region getRegionOfImageObject(SmartAppDriver appDriver, int width, int height) {
        return new Region(this.getRectangleOfImageObject(appDriver, width, height));
    }

    public Region getRegionOfImageObject(SmartAppDriver appDriver, String imageObject) {
        return new Region(this.getImageObjectMatch(appDriver, imageObject));
    }
}

