/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.validator;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.LinkedList;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.ocr.TesseractOCRConfig;
import org.apache.tika.parser.pdf.PDFParserConfig;
import org.apache.tika.sax.BodyContentHandler;
import org.testng.Assert;
import org.xml.sax.ContentHandler;

public class FileContentsValidator {
    private String filePath;
    private String fileContents;
    private String ocrLanguage;

    public FileContentsValidator(String filePath, boolean shouldPrintFileContentsOnConsole) {
        this.filePath = filePath;
        this.ocrLanguage = "eng";
        this.fileContents = this.extractFileContents();
        if (shouldPrintFileContentsOnConsole) {
            System.out.println(this.fileContents);
        }
    }

    public FileContentsValidator(String filePath, boolean shouldPrintFileContentsOnConsole, String ocrLanguage) {
        this.filePath = filePath;
        this.ocrLanguage = ocrLanguage;
        this.fileContents = this.extractFileContents();
        if (shouldPrintFileContentsOnConsole) {
            System.out.println(this.fileContents);
        }
    }

    public FileContentsValidator validateAllKeywordsPresent(String ... keyWords) {
        this.validateAtLeastNKeywordPresent(keyWords.length, false, keyWords);
        return this;
    }

    public FileContentsValidator validateAllKeywordsPresentInOrder(String ... keyWords) {
        this.validateAtLeastNKeywordPresent(keyWords.length, true, keyWords);
        return this;
    }

    public FileContentsValidator validateAtLeastNKeywordPresent(int atLeastN, boolean inOrder, String ... keyWords) {
        Assert.assertNotNull((Object)keyWords);
        LinkedList<String> foundKeywords = new LinkedList<String>();
        int index = -1;
        int prevIndex = -1;
        for (String keyWord : keyWords) {
            if (foundKeywords.size() == atLeastN) break;
            index = this.fileContents.indexOf(keyWord);
            if (index < 0) continue;
            if (inOrder) {
                if (index <= prevIndex) continue;
                foundKeywords.add(keyWord);
                prevIndex = index;
                continue;
            }
            foundKeywords.add(keyWord);
        }
        if (foundKeywords.size() != atLeastN) {
            Assert.fail((String)("Expected at least " + atLeastN + " keywords to match" + (inOrder ? " in order" : "") + " but matched only " + foundKeywords.size() + " keywords. \nExpected keywords: " + Arrays.asList(keyWords) + ".\n Matched keywords: " + foundKeywords));
        }
        return this;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String extractFileContents() {
        try (InputStream fileIs = Files.newInputStream(Paths.get(this.filePath, new String[0]), new OpenOption[0]);){
            String string;
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                String s;
                TikaConfig config = TikaConfig.getDefaultConfig();
                BodyContentHandler handler = new BodyContentHandler((OutputStream)out);
                AutoDetectParser parser = new AutoDetectParser(config);
                Metadata meta = new Metadata();
                ParseContext parseContext = new ParseContext();
                PDFParserConfig pdfConfig = new PDFParserConfig();
                pdfConfig.setExtractInlineImages(true);
                pdfConfig.setExtractActions(false);
                pdfConfig.setExtractBookmarksText(false);
                pdfConfig.setExtractMarkedContent(true);
                TesseractOCRConfig tesserConfig = new TesseractOCRConfig();
                tesserConfig.setLanguage(this.ocrLanguage);
                tesserConfig.setEnableImagePreprocessing(true);
                parseContext.set(PDFParserConfig.class, (Object)pdfConfig);
                parseContext.set(TesseractOCRConfig.class, (Object)tesserConfig);
                parser.parse(fileIs, (ContentHandler)handler, meta, parseContext);
                string = s = new String(out.toByteArray(), Charset.defaultCharset());
            }
            return string;
        }
        catch (Exception e) {
            Assert.fail((String)("Failed to extract file contents of file '" + this.filePath + "'."), (Throwable)e);
            return "";
        }
    }

    public static void main(String[] args) {
    }
}

