/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk;

import java.util.Map;
import org.uitnet.testing.smartfwk.api.core.defaults.ApiTestManager;
import org.uitnet.testing.smartfwk.api.core.defaults.SmartApiTestManager;
import org.uitnet.testing.smartfwk.database.DatabaseManager;
import org.uitnet.testing.smartfwk.database.SmartDatabaseManager;
import org.uitnet.testing.smartfwk.ui.core.AbstractAppConnector;
import org.uitnet.testing.smartfwk.ui.core.SingletonAppConnectorMap;
import org.uitnet.testing.smartfwk.ui.core.config.TestConfigManager;

public class SmartRegistry {
    private SmartRegistry() {
    }

    public static DatabaseManager getDatabaseManager() {
        return SmartDatabaseManager.getInstance();
    }

    public static ApiTestManager getApiTestManager() {
        return SmartApiTestManager.getInstance();
    }

    public static TestConfigManager getTestConfigManager() {
        return TestConfigManager.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deregisterAll() {
        SmartRegistry.getDatabaseManager().deregisterAll();
        SmartRegistry.getApiTestManager().deregisterAll();
        Class<SmartRegistry> clazz = SmartRegistry.class;
        synchronized (SmartRegistry.class) {
            try {
                Map<String, AbstractAppConnector> appConnectors = SingletonAppConnectorMap.getInstance().getMap();
                if (appConnectors != null && !appConnectors.isEmpty()) {
                    for (AbstractAppConnector appConnector : appConnectors.values()) {
                        appConnector.logoutAndQuit();
                    }
                }
                appConnectors.clear();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return;
        }
    }
}

