/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.api.core;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Calendar;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.api.core.ApiAuthenticationProvider;
import org.uitnet.testing.smartfwk.api.core.defaults.ApiTestManager;
import org.uitnet.testing.smartfwk.api.core.support.FileSequenceNumberGenerator;
import org.uitnet.testing.smartfwk.api.core.support.HttpMultipartRequest;
import org.uitnet.testing.smartfwk.api.core.support.HttpRequest;
import org.uitnet.testing.smartfwk.api.core.support.HttpResponse;
import org.uitnet.testing.smartfwk.api.core.support.HttpSession;
import org.uitnet.testing.smartfwk.api.core.support.MultipartData;
import org.uitnet.testing.smartfwk.api.core.support.PayloadType;
import org.uitnet.testing.smartfwk.ui.core.config.TestConfigManager;
import org.uitnet.testing.smartfwk.ui.core.config.UserProfile;
import org.uitnet.testing.smartfwk.ui.core.utils.MimeTypeUtil;
import org.uitnet.testing.smartfwk.ui.core.utils.ObjectUtil;
import org.uitnet.testing.smartfwk.ui.core.utils.StringUtil;

public abstract class AbstractApiActionHandler
implements ApiAuthenticationProvider {
    protected String appName;
    protected String baseURL;
    protected HttpSession session;
    protected String activeProfileName;
    protected UserProfile activeUserProfile;
    protected int sessionExpiryDurationInSeconds;
    protected long lastRequestAccessTimeInMs;
    protected boolean logoutRequest = false;
    protected ApiTestManager apiTestManager;
    protected String targetServerName;

    public AbstractApiActionHandler(String appName, int sessionExpiryDurationInSeconds, String targetServerName) {
        this.appName = appName;
        this.sessionExpiryDurationInSeconds = sessionExpiryDurationInSeconds;
        this.targetServerName = targetServerName;
        this.baseURL = TestConfigManager.getInstance().getAppConfig(appName).getApiConfig().getTargetServer(targetServerName).getBaseURL();
    }

    public void setApiTestManager(ApiTestManager apiTestManager) {
        this.apiTestManager = apiTestManager;
    }

    public HttpSession setActiveProfileName(String profileName) {
        if (this.activeProfileName == null || "".equals(this.activeProfileName)) {
            this.authenticate(profileName);
            this.activeProfileName = profileName;
            this.activeUserProfile = TestConfigManager.getInstance().getUserProfile(this.appName, profileName);
            this.lastRequestAccessTimeInMs = Calendar.getInstance().getTimeInMillis();
        } else if (!this.activeProfileName.equals(profileName)) {
            if (this.apiTestManager == null) {
                this.logout();
            }
            this.authenticate(profileName);
            this.activeProfileName = profileName;
            this.activeUserProfile = TestConfigManager.getInstance().getUserProfile(this.appName, profileName);
            this.lastRequestAccessTimeInMs = Calendar.getInstance().getTimeInMillis();
        }
        return this.session;
    }

    protected void authenticate(String profileName) {
        if (this.apiTestManager != null) {
            ApiAuthenticationProvider authProvider = this.apiTestManager.getAuthenticationProvider(this.appName, this.targetServerName, profileName);
            this.session = authProvider.login(TestConfigManager.getInstance().getAppConfig(this.appName).getApiConfig(), TestConfigManager.getInstance().getUserProfile(this.appName, profileName));
        } else {
            this.session = this.login(TestConfigManager.getInstance().getAppConfig(this.appName).getApiConfig(), TestConfigManager.getInstance().getUserProfile(this.appName, profileName));
        }
    }

    public String getActiveProfileName() {
        return this.activeProfileName;
    }

    public HttpResponse httpGet(String relativeUrl, String responseContentType, Integer connectTimeoutInSeconds, Integer readTimeoutInSeconds) {
        OkHttpClient client = new OkHttpClient.Builder().readTimeout(readTimeoutInSeconds == null ? 60L : (long)readTimeoutInSeconds.intValue(), TimeUnit.SECONDS).connectTimeout(connectTimeoutInSeconds == null ? 30L : (long)connectTimeoutInSeconds.intValue(), TimeUnit.SECONDS).build();
        String targetURL = this.baseURL + "/" + relativeUrl;
        Request.Builder requestBuilder = new Request.Builder().get().url(targetURL);
        if (this.session != null && this.session.getParams() != null && this.session.getParams().size() > 0) {
            for (Map.Entry<String, String> kv : this.session.getParams().entrySet()) {
                requestBuilder.addHeader(kv.getKey(), kv.getValue());
            }
        }
        if (this.session != null && this.session.getCookies() != null && this.session.getCookies().size() > 0) {
            String cookie = null;
            for (Map.Entry<String, String> kv : this.session.getCookies().entrySet()) {
                if (cookie == null) {
                    cookie = kv.getKey() + "=" + kv.getValue();
                    continue;
                }
                cookie = kv + ";" + kv.getKey() + "=" + kv.getValue();
            }
            if (cookie != null) {
                requestBuilder.addHeader("Cookie", cookie);
            }
        }
        requestBuilder.removeHeader("Content-Type");
        if (responseContentType == null || "".equals(responseContentType.trim())) {
            requestBuilder.removeHeader("Accept");
        } else {
            requestBuilder.addHeader("Accept", responseContentType);
        }
        return this.prepareResponse(client, requestBuilder, responseContentType != null, targetURL);
    }

    public HttpResponse httpDelete(String relativeUrl, String responseContentType, Integer connectTimeoutInSeconds, Integer readTimeoutInSeconds) {
        OkHttpClient client = new OkHttpClient.Builder().readTimeout(readTimeoutInSeconds == null ? 60L : (long)readTimeoutInSeconds.intValue(), TimeUnit.SECONDS).connectTimeout(connectTimeoutInSeconds == null ? 30L : (long)connectTimeoutInSeconds.intValue(), TimeUnit.SECONDS).build();
        String targetURL = this.baseURL + "/" + relativeUrl;
        Request.Builder requestBuilder = new Request.Builder().delete().url(targetURL);
        if (this.session != null && this.session.getParams() != null && this.session.getParams().size() > 0) {
            for (Map.Entry<String, String> kv : this.session.getParams().entrySet()) {
                requestBuilder.addHeader(kv.getKey(), kv.getValue());
            }
        }
        if (this.session != null && this.session.getCookies() != null && this.session.getCookies().size() > 0) {
            String cookie = null;
            for (Map.Entry<String, String> kv : this.session.getCookies().entrySet()) {
                if (cookie == null) {
                    cookie = kv.getKey() + "=" + kv.getValue();
                    continue;
                }
                cookie = kv + ";" + kv.getKey() + "=" + kv.getValue();
            }
            if (cookie != null) {
                requestBuilder.addHeader("Cookie", cookie);
            }
        }
        requestBuilder.removeHeader("Content-Type");
        if (responseContentType == null || "".equals(responseContentType.trim())) {
            requestBuilder.removeHeader("Accept");
        } else {
            requestBuilder.addHeader("Accept", responseContentType);
        }
        return this.prepareResponse(client, requestBuilder, responseContentType != null, targetURL);
    }

    public HttpResponse httpPost(String relativeUrl, HttpRequest request, Integer connectTimeoutInSeconds, Integer readTimeoutInSeconds) {
        OkHttpClient client = new OkHttpClient.Builder().readTimeout(readTimeoutInSeconds == null ? 60L : (long)readTimeoutInSeconds.intValue(), TimeUnit.SECONDS).connectTimeout(connectTimeoutInSeconds == null ? 30L : (long)connectTimeoutInSeconds.intValue(), TimeUnit.SECONDS).build();
        String targetURL = this.baseURL + "/" + relativeUrl;
        Request.Builder requestBuilder = new Request.Builder().post(RequestBody.create((String)request.getPayload(), (MediaType)MediaType.parse((String)request.getPayloadType()))).url(targetURL);
        if (!StringUtil.isEmptyAfterTrim(request.getPayloadType())) {
            requestBuilder.addHeader("Content-Type", request.getPayloadType());
        }
        if (this.session != null && this.session.getParams() != null && this.session.getParams().size() > 0) {
            for (Map.Entry<String, String> kv : this.session.getParams().entrySet()) {
                requestBuilder.addHeader(kv.getKey(), kv.getValue());
            }
        }
        if (this.session != null && this.session.getCookies() != null && this.session.getCookies().size() > 0) {
            String cookie = null;
            for (Map.Entry<String, String> kv : this.session.getCookies().entrySet()) {
                if (cookie == null) {
                    cookie = kv.getKey() + "=" + kv.getValue();
                    continue;
                }
                cookie = kv + ";" + kv.getKey() + "=" + kv.getValue();
            }
            if (cookie != null) {
                requestBuilder.addHeader("Cookie", cookie);
            }
        }
        if (request.getResponseContentType() == null || "".equals(request.getResponseContentType().trim())) {
            requestBuilder.removeHeader("Accept");
        } else {
            requestBuilder.addHeader("Accept", request.getResponseContentType());
        }
        return this.prepareResponse(client, requestBuilder, request.getResponseContentType() != null, targetURL);
    }

    public HttpResponse httpPut(String relativeUrl, HttpRequest request, Integer connectTimeoutInSeconds, Integer readTimeoutInSeconds) {
        OkHttpClient client = new OkHttpClient.Builder().readTimeout(readTimeoutInSeconds == null ? 60L : (long)readTimeoutInSeconds.intValue(), TimeUnit.SECONDS).connectTimeout(connectTimeoutInSeconds == null ? 30L : (long)connectTimeoutInSeconds.intValue(), TimeUnit.SECONDS).build();
        String targetURL = this.baseURL + "/" + relativeUrl;
        Request.Builder requestBuilder = new Request.Builder().put(RequestBody.create((String)request.getPayload(), (MediaType)MediaType.parse((String)request.getPayloadType()))).url(targetURL);
        if (!StringUtil.isEmptyAfterTrim(request.getPayloadType())) {
            requestBuilder.addHeader("Content-Type", request.getPayloadType());
        }
        if (this.session != null && this.session.getParams() != null && this.session.getParams().size() > 0) {
            for (Map.Entry<String, String> kv : this.session.getParams().entrySet()) {
                requestBuilder.addHeader(kv.getKey(), kv.getValue());
            }
        }
        if (this.session != null && this.session.getCookies() != null && this.session.getCookies().size() > 0) {
            String cookie = null;
            for (Map.Entry<String, String> kv : this.session.getCookies().entrySet()) {
                if (cookie == null) {
                    cookie = kv.getKey() + "=" + kv.getValue();
                    continue;
                }
                cookie = kv + ";" + kv.getKey() + "=" + kv.getValue();
            }
            if (cookie != null) {
                requestBuilder.addHeader("Cookie", cookie);
            }
        }
        if (request.getResponseContentType() == null || "".equals(request.getResponseContentType().trim())) {
            requestBuilder.removeHeader("Accept");
        } else {
            requestBuilder.addHeader("Accept", request.getResponseContentType());
        }
        return this.prepareResponse(client, requestBuilder, request.getResponseContentType() != null, targetURL);
    }

    public HttpResponse httpUploadFormFiles(String relativeUrl, HttpMultipartRequest request, Integer connectTimeoutInSeconds, Integer readTimeoutInSeconds) {
        OkHttpClient client = new OkHttpClient.Builder().readTimeout(readTimeoutInSeconds == null ? 60L : (long)readTimeoutInSeconds.intValue(), TimeUnit.SECONDS).connectTimeout(connectTimeoutInSeconds == null ? 30L : (long)connectTimeoutInSeconds.intValue(), TimeUnit.SECONDS).build();
        MultipartBody.Builder multipartBodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        for (MultipartData part : request.getParts()) {
            if (part.getContentType() == null) {
                multipartBodyBuilder.addFormDataPart(part.getName(), part.getFileName());
                continue;
            }
            multipartBodyBuilder.addFormDataPart(part.getName(), part.getFileName(), RequestBody.create((File)new File(part.getFilePath()), (MediaType)MediaType.parse((String)part.getContentType())));
        }
        String targetURL = this.baseURL + "/" + relativeUrl;
        Request.Builder requestBuilder = new Request.Builder().post((RequestBody)multipartBodyBuilder.build()).url(targetURL);
        if (this.session != null && this.session.getParams() != null && this.session.getParams().size() > 0) {
            for (Map.Entry<String, String> kv : this.session.getParams().entrySet()) {
                requestBuilder.addHeader(kv.getKey(), kv.getValue());
            }
        }
        if (this.session != null && this.session.getCookies() != null && this.session.getCookies().size() > 0) {
            String cookie = null;
            for (Map.Entry<String, String> kv : this.session.getCookies().entrySet()) {
                if (cookie == null) {
                    cookie = kv.getKey() + "=" + kv.getValue();
                    continue;
                }
                cookie = kv + ";" + kv.getKey() + "=" + kv.getValue();
            }
            if (cookie != null) {
                requestBuilder.addHeader("Cookie", cookie);
            }
        }
        if (request.getResponseContentType() == null || "".equals(request.getResponseContentType().trim())) {
            requestBuilder.removeHeader("Accept");
        } else {
            requestBuilder.addHeader("Accept", request.getResponseContentType());
        }
        requestBuilder.addHeader("Content-Type", request.getContentType());
        return this.prepareResponse(client, requestBuilder, request.getResponseContentType() != null, targetURL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpResponse prepareResponse(OkHttpClient client, Request.Builder requestBuilder, boolean expectResponseBody, String targetURL) {
        if (this.session != null && !this.logoutRequest) {
            if (this.isSessionExpired()) {
                this.logout();
                this.setActiveProfileName(this.activeProfileName);
            } else {
                this.lastRequestAccessTimeInMs = Calendar.getInstance().getTimeInMillis();
            }
        }
        HttpResponse httpResponse = new HttpResponse();
        try (Response response = client.newCall(requestBuilder.build()).execute();){
            httpResponse.setCode(response.code());
            httpResponse.setMessage(response.message());
            Headers headers = response.headers();
            for (String key : headers.names()) {
                httpResponse.addHeader(key, headers.get(key));
            }
            String contentType = httpResponse.getHeader("Content-Type");
            String contentDisposition = httpResponse.getHeader("Content-Disposition");
            String binFileExtn = MimeTypeUtil.getBinaryFileExtension(contentType);
            if (contentDisposition != null && (contentDisposition.toLowerCase().contains("attachment") || contentDisposition.toLowerCase().contains("inline"))) {
                this.handleContentDisposition(httpResponse, response);
            } else if (binFileExtn != null) {
                httpResponse.setPayloadType(PayloadType.FILE);
                int nextSeq = FileSequenceNumberGenerator.getInstance().next();
                String filePath = TestConfigManager.getInstance().getDownloadLocation() + File.separator + "noname" + nextSeq + binFileExtn;
                httpResponse.setPayload("noname" + binFileExtn);
                httpResponse.setFilePath(filePath);
                this.downloadFile(response.body(), filePath);
            } else if (expectResponseBody) {
                ResponseBody body = response.body();
                httpResponse.setPayload(body.string());
            }
        }
        catch (Exception ex) {
            httpResponse.setCode(400);
            httpResponse.setMessage("Bad Request");
            Assert.fail((String)("Failed to make API call on target URL: " + targetURL), (Throwable)ex);
        }
        finally {
            if (this.logoutRequest) {
                this.logoutRequest = false;
                this.session = null;
            }
        }
        return httpResponse;
    }

    protected boolean isSessionExpired() {
        long currTimeInMs = Calendar.getInstance().getTimeInMillis();
        long durationInSeconds = (currTimeInMs - this.lastRequestAccessTimeInMs) / 1000L;
        return durationInSeconds >= (long)this.sessionExpiryDurationInSeconds;
    }

    public UserProfile getActiveUserProfile() {
        return this.activeUserProfile;
    }

    public int getSessionExpiryDurationInSeconds() {
        return this.sessionExpiryDurationInSeconds;
    }

    public long getLastRequestAccessTimeInMs() {
        return this.lastRequestAccessTimeInMs;
    }

    protected void handleContentDisposition(HttpResponse httpResponse, Response rawResponse) throws IOException {
        String contentDisposition = httpResponse.getHeader("Content-Disposition");
        if (contentDisposition != null && (contentDisposition.toLowerCase().contains("attachment") || contentDisposition.toLowerCase().contains("inline"))) {
            httpResponse.setPayloadType(PayloadType.FILE);
            String[] parts = contentDisposition.split(";");
            String fileToCreate = "noname";
            for (String part : parts) {
                String[] fileParts;
                if (!part.trim().contains("filename") || (fileParts = part.trim().split("=")).length != 2) continue;
                String fileName = fileParts[1].trim();
                fileToCreate = fileName.replace("\"", "").replace("'", "");
                break;
            }
            httpResponse.setPayload(fileToCreate);
            String filePath = TestConfigManager.getInstance().getDownloadLocation() + File.separator;
            int lastIndex = fileToCreate.lastIndexOf(".");
            int nextSeq = FileSequenceNumberGenerator.getInstance().next();
            filePath = lastIndex == 0 ? filePath + nextSeq + fileToCreate : (lastIndex > 0 ? fileToCreate.substring(0, lastIndex) + "-" + nextSeq + fileToCreate.substring(lastIndex, fileToCreate.length()) : filePath + fileToCreate + nextSeq);
            httpResponse.setFilePath(filePath);
            this.downloadFile(rawResponse.body(), filePath);
        }
    }

    protected void downloadFile(ResponseBody body, String filePath) throws IOException {
        if (body != null) {
            Files.copy(body.byteStream(), new File(filePath).toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public AbstractApiActionHandler clone() {
        try {
            AbstractApiActionHandler obj = (AbstractApiActionHandler)ObjectUtil.findClassConstructor(this.getClass(), new Class[]{String.class, Integer.TYPE, String.class}).newInstance(this.appName, this.sessionExpiryDurationInSeconds, this.targetServerName);
            return obj;
        }
        catch (Exception ex) {
            Assert.fail((String)("Failed to clone '" + this.getClass().getName() + "' class object."), (Throwable)ex);
            return null;
        }
    }
}

