/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.api.core.defaults;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.api.core.AbstractApiActionHandler;
import org.uitnet.testing.smartfwk.api.core.ApiAuthenticationProvider;
import org.uitnet.testing.smartfwk.api.core.defaults.ApiTestManager;
import org.uitnet.testing.smartfwk.ui.core.config.ApiConfig;
import org.uitnet.testing.smartfwk.ui.core.config.ApiTargetServer;
import org.uitnet.testing.smartfwk.ui.core.config.AppConfig;
import org.uitnet.testing.smartfwk.ui.core.config.TestConfigManager;
import org.uitnet.testing.smartfwk.ui.core.utils.ObjectUtil;
import org.uitnet.testing.smartfwk.ui.core.utils.StringUtil;

public class SmartApiTestManager
implements ApiTestManager {
    private static SmartApiTestManager instance;
    private Map<String, AbstractApiActionHandler> appActionHandlers = new HashMap<String, AbstractApiActionHandler>();
    private Map<String, ApiAuthenticationProvider> appAuthProviders = new HashMap<String, ApiAuthenticationProvider>();

    private SmartApiTestManager() {
        this.initActionHandlers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApiTestManager getInstance() {
        if (instance != null) {
            return instance;
        }
        Class<SmartApiTestManager> clazz = SmartApiTestManager.class;
        synchronized (SmartApiTestManager.class) {
            if (instance == null) {
                instance = new SmartApiTestManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void initActionHandlers() {
        Collection<AppConfig> appConfigs = TestConfigManager.getInstance().getAppConfigs();
        if (appConfigs != null) {
            List<ApiTargetServer> targetServers = null;
            for (AppConfig appConfig : appConfigs) {
                ApiConfig apiConfig = appConfig.getApiConfig();
                if (apiConfig == null || (targetServers = apiConfig.getTargetServers()) == null) continue;
                for (ApiTargetServer targetServer : targetServers) {
                    try {
                        if (StringUtil.isEmptyAfterTrim(targetServer.getActionHandlerClass()) || StringUtil.isEmptyAfterTrim(targetServer.getName())) continue;
                        Class<?> clazz = Class.forName(targetServer.getActionHandlerClass());
                        AbstractApiActionHandler obj = (AbstractApiActionHandler)ObjectUtil.findClassConstructor(clazz, new Class[]{String.class, Integer.TYPE, String.class}).newInstance(apiConfig.getAppName(), targetServer.getSessionExpiryDurationInSeconds(), targetServer.getName());
                        this.registerActionHandler(appConfig.getAppName(), targetServer.getName(), obj);
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                }
            }
        }
    }

    private void registerActionHandler(String appName, String targetServerName, AbstractApiActionHandler actionHandler) {
        this.appActionHandlers.put(this.prepareKey(appName, targetServerName), actionHandler);
    }

    @Override
    public AbstractApiActionHandler getActionHandler(String appName, String targetServerName) {
        AbstractApiActionHandler helper = this.getRegisteredActionHandler(appName, targetServerName);
        return helper;
    }

    private AbstractApiActionHandler getRegisteredActionHandler(String appName, String targetServerName) {
        AbstractApiActionHandler actionHandler = this.appActionHandlers.get(this.prepareKey(appName, targetServerName));
        Assert.assertNotNull((Object)actionHandler, (String)("No test helper registered with SmartApiTestManager class for appName = " + appName + " and targetServerName = " + targetServerName + ". This must be registered in cucumber step definition method that is annotated with @BeforeAll."));
        AbstractApiActionHandler newActionHandler = actionHandler.clone();
        newActionHandler.setApiTestManager(this);
        return newActionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApiAuthenticationProvider getAuthenticationProvider(String appName, String targetServerName, String userProfileName) {
        String mapKey = this.prepareAuthProviderMapKey(appName, targetServerName, userProfileName);
        ApiAuthenticationProvider authProvider = this.appAuthProviders.get(mapKey);
        if (authProvider != null) {
            return authProvider;
        }
        Class<SmartApiTestManager> clazz = SmartApiTestManager.class;
        synchronized (SmartApiTestManager.class) {
            authProvider = this.appAuthProviders.get(mapKey);
            if (authProvider != null) {
                // ** MonitorExit[var6_6] (shouldn't be in output)
                return authProvider;
            }
            authProvider = this.getRegisteredActionHandler(appName, targetServerName);
            this.appAuthProviders.put(mapKey, authProvider);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return authProvider;
        }
    }

    private String prepareAuthProviderMapKey(String appName, String targetServerName, String userProfileName) {
        return appName + ":" + targetServerName + ":" + userProfileName;
    }

    private String prepareKey(String appName, String targetServerName) {
        return appName + ":" + targetServerName;
    }

    @Override
    public synchronized void deregisterAll() {
        this.appActionHandlers.clear();
        for (ApiAuthenticationProvider aap : this.appAuthProviders.values()) {
            aap.logout();
        }
        this.appAuthProviders.clear();
    }
}

