/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.api.core.defaults;

import java.util.HashMap;
import java.util.Map;
import org.uitnet.testing.smartfwk.SmartCucumberScenarioContext;
import org.uitnet.testing.smartfwk.api.core.AbstractApiActionHandler;
import org.uitnet.testing.smartfwk.api.core.defaults.SingletonApiActionHandlerMap;
import org.uitnet.testing.smartfwk.api.core.defaults.SmartApiTestManager;
import org.uitnet.testing.smartfwk.ui.core.config.ApiConfig;

public class SmartCucumberApiScenarioContext
extends SmartCucumberScenarioContext {
    private Map<String, AbstractApiActionHandler> appActionHandlers = this.getTestConfigManager().isParallelMode() ? new HashMap<String, AbstractApiActionHandler>() : SingletonApiActionHandlerMap.getInstance().getMap();
    private String activeTargetServerName = null;

    public AbstractApiActionHandler getActionHandler(String appName, String targetServerName) {
        return this.appActionHandlers.get(this.prepareKey(appName, targetServerName));
    }

    public AbstractApiActionHandler switchTargetServer(String appName, String targetServerName, String userProfileName) {
        return this.login(appName, targetServerName, userProfileName);
    }

    public AbstractApiActionHandler login(String appName, String targetServerName, String userProfileName) {
        AbstractApiActionHandler actionHandler = this.getActionHandler(appName, targetServerName);
        if (actionHandler == null) {
            actionHandler = SmartApiTestManager.getInstance().getActionHandler(appName, targetServerName);
        }
        actionHandler.setActiveProfileName(userProfileName);
        this.activeAppName = appName;
        this.activeTargetServerName = targetServerName;
        this.appActionHandlers.put(this.prepareKey(appName, targetServerName), actionHandler);
        return actionHandler;
    }

    public AbstractApiActionHandler setActiveUserProfile(String appName, String targetServerName, String userProfileName) {
        return this.login(appName, targetServerName, userProfileName);
    }

    public AbstractApiActionHandler setActiveUserProfileOnActiveAppAndTargetServer(String userProfileName) {
        return this.login(this.activeAppName, this.activeTargetServerName, userProfileName);
    }

    public AbstractApiActionHandler getActiveActionHandler() {
        return this.appActionHandlers.get(this.prepareKey(this.activeAppName, this.activeTargetServerName));
    }

    public String getActiveUserProfileNameOfActiveActionHandler() {
        return this.getActiveActionHandler().getActiveProfileName();
    }

    public ApiConfig getActiveAppApiConfig() {
        return this.getTestConfigManager().getAppConfig(this.activeAppName).getApiConfig();
    }

    @Override
    public void close() {
        super.close();
        if (this.getTestConfigManager().isParallelMode()) {
            for (AbstractApiActionHandler actionHandlers : this.appActionHandlers.values()) {
                actionHandlers.logout();
            }
            this.appActionHandlers.clear();
        }
    }

    @Override
    public String applyParamsValueOnText(String text) {
        for (Map.Entry e : this.params.entrySet()) {
            text = text.replace((CharSequence)e.getKey(), "" + e.getValue());
        }
        return text;
    }

    private String prepareKey(String appName, String targetServerName) {
        return appName + ":" + targetServerName;
    }
}

