/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.database;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.uitnet.testing.smartfwk.database.AbstractDatabaseActionHandler;
import org.uitnet.testing.smartfwk.database.DatabaseConnectionProvider;
import org.uitnet.testing.smartfwk.database.DatabaseManager;
import org.uitnet.testing.smartfwk.ui.core.config.AppConfig;
import org.uitnet.testing.smartfwk.ui.core.config.DatabaseProfile;
import org.uitnet.testing.smartfwk.ui.core.config.TestConfigManager;
import org.uitnet.testing.smartfwk.ui.core.utils.ObjectUtil;

public class SmartDatabaseManager
implements DatabaseManager {
    private static SmartDatabaseManager instance;
    private Map<String, AbstractDatabaseActionHandler> dbActionHandlers = new HashMap<String, AbstractDatabaseActionHandler>();

    private SmartDatabaseManager() {
        this.initDatabaseProfiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatabaseManager getInstance() {
        if (instance != null) {
            return instance;
        }
        Class<SmartDatabaseManager> clazz = SmartDatabaseManager.class;
        synchronized (SmartDatabaseManager.class) {
            if (instance == null) {
                instance = new SmartDatabaseManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void initDatabaseProfiles() {
        Collection<AppConfig> appConfigs = TestConfigManager.getInstance().getAppConfigs();
        if (appConfigs != null) {
            Collection<DatabaseProfile> dbProfiles = null;
            for (AppConfig appConfig : appConfigs) {
                dbProfiles = appConfig.getDatabaseProfiles();
                if (dbProfiles == null) continue;
                for (DatabaseProfile profile : dbProfiles) {
                    try {
                        Class<?> clazz = Class.forName(profile.getDatabaseHandlerClass());
                        AbstractDatabaseActionHandler obj = (AbstractDatabaseActionHandler)ObjectUtil.findClassConstructor(clazz, new Class[]{String.class, Integer.TYPE, DatabaseProfile.class}).newInstance(profile.getAppName(), profile.getSessionExpiryDurationInSeconds(), profile);
                        this.registerActionHandler(appConfig.getAppName(), profile.getProfileName(), obj);
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                }
            }
        }
    }

    private void registerActionHandler(String appName, String profileName, AbstractDatabaseActionHandler actionHandler) {
        this.dbActionHandlers.put(this.prepareKey(appName, profileName), actionHandler);
    }

    @Override
    public synchronized void deregisterAll() {
        for (DatabaseConnectionProvider databaseConnectionProvider : this.dbActionHandlers.values()) {
            databaseConnectionProvider.disconnect();
        }
        this.dbActionHandlers.clear();
    }

    @Override
    public DatabaseProfile getDatabaseProfile(String appName, String profileName) {
        return TestConfigManager.getInstance().getDatabaseProfile(appName, profileName);
    }

    private String prepareKey(String appName, String profileName) {
        return appName + ":" + profileName;
    }

    @Override
    public AbstractDatabaseActionHandler getDatabaseActionHandler(String appName, String profileName) {
        AbstractDatabaseActionHandler actionHandler = this.dbActionHandlers.get(this.prepareKey(appName, profileName));
        return actionHandler;
    }
}

