/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.cache;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.SubmissionPublisher;
import org.uitnet.testing.smartfwk.ui.core.cache.SmartCacheSubscriber;
import org.uitnet.testing.smartfwk.ui.core.utils.ObjectUtil;

public abstract class SmartCache {
    private Map<String, Object> cache = new TreeMap(Collections.reverseOrder());
    private SubmissionPublisher<SmartCache> publisher = new SubmissionPublisher();

    public void add(String key, Object value) {
        this.cache.put(key, value);
    }

    public Object get(String key) {
        return this.cache.get(key);
    }

    public Object getNullAsKey(String key) {
        Object v = this.cache.get(key);
        if (v == null) {
            return key;
        }
        return v;
    }

    public Object removeAndGet(String key) {
        return this.cache.remove(key);
    }

    public Object removeAndGetNullAsKey(String key) {
        Object v = this.cache.remove(key);
        if (v == null) {
            return key;
        }
        return v;
    }

    public String getValueAsString(String key) {
        return ObjectUtil.valueAsString(this.cache.get(key));
    }

    public Integer getValueAsInteger(String key) {
        return ObjectUtil.valueAsInteger(this.cache.get(key));
    }

    public Long getValueAsLong(String key) {
        return ObjectUtil.valueAsLong(this.cache.get(key));
    }

    public Double getValueAsDouble(String key) {
        return ObjectUtil.valueAsDouble(this.cache.get(key));
    }

    public Boolean getValueAsBoolean(String key) {
        return ObjectUtil.valueAsBoolean(this.cache.get(key));
    }

    public String getMultiValueKeyValueAsString(String key, String delimitter, String valueEnclosingChars) {
        return ObjectUtil.listSetArrayValueAsString(this.cache.get(key), delimitter, valueEnclosingChars);
    }

    public Map<String, Object> getAll() {
        return this.cache;
    }

    public void clear() {
        this.cache.clear();
    }

    public Set<String> getKeysStartsWith(String startsWithStr) {
        HashSet<String> keys = new HashSet<String>();
        for (String k : this.cache.keySet()) {
            if (!k.startsWith(startsWithStr)) continue;
            keys.add(k);
        }
        return keys;
    }

    public Set<String> getKeysEndsWith(String endsWithStr) {
        HashSet<String> keys = new HashSet<String>();
        for (String k : this.cache.keySet()) {
            if (!k.endsWith(endsWithStr)) continue;
            keys.add(k);
        }
        return keys;
    }

    public Map<String, Object> getEntriesForKeyesEndsWithText(String text) {
        TreeMap<String, Object> fparams = new TreeMap<String, Object>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null && o2 != null) {
                    return o2.length();
                }
                if (o1 != null && o2 == null) {
                    return 0 - o1.length();
                }
                return o2.length() - o1.length();
            }
        });
        for (Map.Entry<String, Object> k : this.cache.entrySet()) {
            if (!k.getKey().endsWith(text)) continue;
            fparams.put(k.getKey(), k.getValue());
        }
        return fparams;
    }

    public Map<String, Object> getEntriesForKeysStartsWithText(String text) {
        TreeMap<String, Object> fparams = new TreeMap<String, Object>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null && o2 != null) {
                    return o2.length();
                }
                if (o1 != null && o2 == null) {
                    return 0 - o1.length();
                }
                return o2.length() - o1.length();
            }
        });
        for (Map.Entry<String, Object> k : this.cache.entrySet()) {
            if (!k.getKey().startsWith(text)) continue;
            fparams.put(k.getKey(), k.getValue());
        }
        return fparams;
    }

    public boolean isKeyPresent(String key) {
        return this.cache.get(key) != null;
    }

    public void subscribe(SmartCacheSubscriber subscriber) {
        this.publisher.subscribe(subscriber);
    }

    public void publish(SmartCache cache) {
        this.publisher.submit(cache);
    }
}

