/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.config;

import com.jayway.jsonpath.DocumentContext;
import java.io.File;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.api.core.reader.YamlDocumentReader;
import org.uitnet.testing.smartfwk.ui.core.commons.Locations;

public class EnvironmentConfig {
    private String name;
    private DocumentContext docContext;

    public EnvironmentConfig(String appName, String environmentName) {
        this.name = environmentName;
        if (environmentName != null && !"".equals(environmentName.trim())) {
            this.init(appName);
        } else {
            this.name = "Default";
        }
    }

    private void init(String appName) {
        String activeEnvConfigPath = Locations.getConfigDirPath() + File.separator + "apps-config" + File.separator + appName + File.separator + "environments" + File.separator + this.name + ".yaml";
        Assert.assertTrue((boolean)new File(activeEnvConfigPath).exists(), (String)("Missing '" + activeEnvConfigPath + "' environment file in '" + appName + "' application."));
        try {
            YamlDocumentReader reader = new YamlDocumentReader(new File(activeEnvConfigPath));
            this.docContext = reader.getDocumentContext();
        }
        catch (Exception ex) {
            Assert.fail((String)("Failed to read property file - " + activeEnvConfigPath + ". Going to exit..."), (Throwable)ex);
            System.exit(1);
        }
    }

    public String getName() {
        return this.name;
    }

    public DocumentContext getDocumentContext() {
        return this.docContext;
    }
}

