/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.Assert;

public class ObjectUtil {
    public static String valueAsString(Object obj) {
        if (obj == null) {
            return null;
        }
        Object strv = "";
        if (obj.getClass().isArray()) {
            Object[] objArr;
            for (Object o : objArr = (Object[])obj) {
                strv = ((String)strv).equals("") ? "" + o : (String)strv + ", " + o;
            }
        } else if (obj instanceof List) {
            List list = (List)obj;
            for (Object o : list) {
                if (((String)strv).equals("")) {
                    strv = "" + o;
                    continue;
                }
                strv = (String)strv + ", " + o;
            }
        } else if (obj instanceof Set) {
            Set list = (Set)obj;
            for (Object o : list) {
                if (((String)strv).equals("")) {
                    strv = "" + o;
                    continue;
                }
                strv = (String)strv + ", " + o;
            }
        } else if (obj instanceof Map) {
            Assert.fail((String)"Map to string conversion is not supported.");
        } else {
            strv = String.valueOf(obj);
        }
        return strv;
    }

    public static Integer valueAsInteger(Object obj) {
        if (obj == null) {
            return null;
        }
        return Integer.parseInt("" + obj);
    }

    public static Long valueAsLong(Object obj) {
        if (obj == null) {
            return null;
        }
        return Long.parseLong("" + obj);
    }

    public static Double valueAsDouble(Object obj) {
        if (obj == null) {
            return null;
        }
        return Double.parseDouble("" + obj);
    }

    public static Boolean valueAsBoolean(Object obj) {
        if (obj == null) {
            return null;
        }
        return Boolean.parseBoolean("" + obj);
    }

    public static String listSetArrayValueAsString(Object obj, String delimitter, String valueEnclosingChars) {
        if (obj == null) {
            return null;
        }
        valueEnclosingChars = valueEnclosingChars == null ? "" : valueEnclosingChars;
        delimitter = delimitter == null ? "," : delimitter;
        Object strv = "";
        if (obj.getClass().isArray()) {
            Object[] objArr;
            for (Object o : objArr = (Object[])obj) {
                strv = ((String)strv).equals("") ? (o == null ? "null" : valueEnclosingChars + o + valueEnclosingChars) : (String)strv + ", " + (String)(o == null ? "null" : valueEnclosingChars + o + valueEnclosingChars);
            }
        } else if (obj instanceof List) {
            List list = (List)obj;
            for (Object o : list) {
                if (((String)strv).equals("")) {
                    strv = o == null ? "null" : valueEnclosingChars + o + valueEnclosingChars;
                    continue;
                }
                strv = (String)strv + ", " + (String)(o == null ? "null" : valueEnclosingChars + o + valueEnclosingChars);
            }
        } else if (obj instanceof Set) {
            Set list = (Set)obj;
            for (Object o : list) {
                if (((String)strv).equals("")) {
                    strv = o == null ? "null" : valueEnclosingChars + o + valueEnclosingChars;
                    continue;
                }
                strv = (String)strv + ", " + (String)(o == null ? "null" : valueEnclosingChars + o + valueEnclosingChars);
            }
        } else if (obj instanceof Map) {
            Assert.fail((String)"Map to string conversion is not supported.");
        } else {
            strv = String.valueOf(valueEnclosingChars + obj + valueEnclosingChars);
        }
        return strv;
    }

    public static Constructor<?> findClassConstructor(Class<?> clazz, Class<?>[] argTypes) {
        Constructor<?> foundConstructor = null;
        try {
            Constructor<?>[] constructors = clazz.getConstructors();
            if (argTypes == null) {
                argTypes = new Class[]{};
            }
            boolean found = false;
            for (Constructor<?> m : constructors) {
                foundConstructor = null;
                if (m.getParameterCount() != argTypes.length) continue;
                Class<?>[] paramTypes = m.getParameterTypes();
                Class<?> paramType = null;
                found = true;
                for (int i = 0; i < paramTypes.length; ++i) {
                    paramType = paramTypes[i];
                    if (paramType.getTypeName().equals(argTypes[i].getTypeName())) continue;
                    found = false;
                    break;
                }
                if (!found) continue;
                foundConstructor = m;
                break;
            }
        }
        catch (Exception ex) {
            Assert.fail((String)("Failed to find constructor in class '" + clazz.getName() + "'."), (Throwable)ex);
        }
        if (foundConstructor == null) {
            Assert.fail((String)("Failed to find constructor in class '" + clazz.getName() + "'."));
        }
        return foundConstructor;
    }

    public static Method findClassMethod(Class<?> clazz, String methodName, Class<?>[] argTypes) {
        Method foundMethod = null;
        try {
            Method[] methods = clazz.getMethods();
            boolean found = false;
            for (Method m : methods) {
                foundMethod = null;
                if (!m.getName().equals(methodName) || m.getParameterCount() != argTypes.length) continue;
                Class<?>[] paramTypes = m.getParameterTypes();
                Class<?> paramType = null;
                found = true;
                for (int i = 0; i < paramTypes.length; ++i) {
                    paramType = paramTypes[i];
                    if (paramType.getTypeName().equals(argTypes[i].getTypeName())) continue;
                    found = false;
                    break;
                }
                if (!found) continue;
                foundMethod = m;
                break;
            }
        }
        catch (Exception ex) {
            Assert.fail((String)("Failed to find '" + methodName + "' method in class '" + clazz.getName() + "'."), (Throwable)ex);
        }
        if (foundMethod == null) {
            Assert.fail((String)("Failed to find '" + methodName + "' method in class '" + clazz.getName() + "'."));
        }
        return foundMethod;
    }

    public static Object invokeMethod(Object clazzObj, Method m, Object[] argValues) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object out = null;
        out = m.invoke(clazzObj, argValues);
        return out;
    }

    public static void main(String[] args) {
        System.out.println(ObjectUtil.listSetArrayValueAsString(new Integer[]{null, 55, 78}, null, "\""));
    }
}

