/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.utils;

import com.jayway.jsonpath.DocumentContext;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import org.sikuli.script.Region;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.api.core.reader.JsonDocumentReader;
import org.uitnet.testing.smartfwk.api.core.support.PageObjectInfo;
import org.uitnet.testing.smartfwk.ui.core.SmartCucumberUiScenarioContext;
import org.uitnet.testing.smartfwk.ui.core.commons.FieldValue;
import org.uitnet.testing.smartfwk.ui.core.utils.ObjectUtil;
import org.uitnet.testing.smartfwk.ui.core.utils.StringUtil;

public class PageObjectUtil {
    private PageObjectUtil() {
    }

    public static PageObjectInfo getPageObjectInfo(String pageObject) {
        int firstIndexOfLeftBrace = pageObject.indexOf("{");
        DocumentContext jsonParams = null;
        if (firstIndexOfLeftBrace >= 0) {
            String jsonParamStr = pageObject.substring(firstIndexOfLeftBrace, pageObject.length());
            pageObject = pageObject.substring(0, firstIndexOfLeftBrace);
            JsonDocumentReader jsonDocReader = new JsonDocumentReader(jsonParamStr);
            jsonParams = jsonDocReader.getDocumentContext();
        }
        int lastIndexOfDot = pageObject.lastIndexOf(".");
        String clazzName = pageObject.substring(0, lastIndexOfDot).trim();
        String qualifiedClazzName = "page_objects." + clazzName;
        String objectName = pageObject.substring(lastIndexOfDot + 1, pageObject.length()).trim();
        return new PageObjectInfo(qualifiedClazzName, objectName, jsonParams);
    }

    public static FieldValue getPageObject(PageObjectInfo poInfo) {
        Field f = null;
        Object value = null;
        try {
            Class<?> clazz = Class.forName(poInfo.getPoClassName());
            f = clazz.getField(poInfo.getPoObjectName());
            value = f.get(clazz);
        }
        catch (Exception ex) {
            Assert.fail((String)("Failed to load the page object '" + poInfo.getPoClassName() + "." + poInfo.getPoObjectName() + "'. Reason: " + ex.getCause().getLocalizedMessage()), (Throwable)ex);
        }
        return new FieldValue(f, value);
    }

    public static Object getPageObjectValidator(PageObjectInfo poInfo, SmartCucumberUiScenarioContext scenarioContext) {
        FieldValue fv = PageObjectUtil.getPageObject(poInfo);
        Object validatorObj = null;
        try {
            PageObjectUtil.applyParamsToLocator(fv, poInfo.getLocatorParams(), scenarioContext);
            Method method = fv.getField().getType().getMethod("getValidator", SmartCucumberUiScenarioContext.class, Region.class);
            validatorObj = method.invoke(fv.getValue(), scenarioContext, null);
        }
        catch (Exception ex) {
            Assert.fail((String)("Failed to get validator for the page object '" + poInfo.getPoClassName() + "." + poInfo.getPoObjectName() + "'. Reason: " + ex.getCause().getLocalizedMessage()), (Throwable)ex);
        }
        return validatorObj;
    }

    public static Object invokeValidatorMethod(String methodName, Class<?>[] methodArgTypes, Object[] methodArgValues, PageObjectInfo poInfo, SmartCucumberUiScenarioContext scenarioContext) {
        Object validatorObj = PageObjectUtil.getPageObjectValidator(poInfo, scenarioContext);
        Method method = ObjectUtil.findClassMethod(validatorObj.getClass(), methodName, methodArgTypes);
        try {
            return ObjectUtil.invokeMethod(validatorObj, method, methodArgValues);
        }
        catch (Error | Exception ex) {
            Assert.fail((String)("'" + methodName + "' operation is failed for page object '" + poInfo.getPoClassName() + "." + poInfo.getPoObjectName() + "'. Reason: " + ex.getCause().getLocalizedMessage()), (Throwable)ex);
            return null;
        }
    }

    protected static void applyParamsToLocator(FieldValue fv, Map<String, String> locatorParams, SmartCucumberUiScenarioContext scenarioContext) {
        if (!locatorParams.isEmpty()) {
            try {
                for (Map.Entry<String, String> param : locatorParams.entrySet()) {
                    Method method = fv.getField().getType().getMethod("updateLocatorParameterWithValue", String.class, String.class);
                    Object newObj = method.invoke(fv.getValue(), param.getKey(), PageObjectUtil.prepareParamValue(param.getValue(), scenarioContext));
                    fv.setValue(newObj);
                }
            }
            catch (Error | Exception ex) {
                Assert.fail((String)"Failed to update locator input parameters.", (Throwable)ex);
            }
        }
    }

    public static String prepareParamValue(String paramValue, SmartCucumberUiScenarioContext scenarioContext) {
        if (paramValue != null) {
            if (StringUtil.startsWithText(paramValue.trim(), "${") && StringUtil.endsWithText(paramValue.trim(), "}")) {
                paramValue = paramValue.trim();
                paramValue = paramValue.substring(2, paramValue.length() - 1).trim();
                return String.valueOf(scenarioContext.getParamValue(paramValue));
            }
            if (StringUtil.startsWithText(paramValue.trim(), "\\${") && StringUtil.endsWithText(paramValue.trim(), "}")) {
                return paramValue.replaceFirst("\\", "");
            }
        }
        return paramValue;
    }
}

