/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.standard.domobj;

import java.util.LinkedList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.sikuli.script.Region;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.appdriver.SmartAppDriver;
import org.uitnet.testing.smartfwk.ui.core.commons.ItemList;
import org.uitnet.testing.smartfwk.ui.core.objects.DOMObject;
import org.uitnet.testing.smartfwk.ui.core.objects.DOMObjectValidator;
import org.uitnet.testing.smartfwk.ui.core.objects.NewTextLocation;
import org.uitnet.testing.smartfwk.ui.core.objects.listbox.ListBoxValidator;
import org.uitnet.testing.smartfwk.ui.core.objects.scrollbar.Scrollbar;
import org.uitnet.testing.smartfwk.ui.core.objects.validator.mechanisms.TextMatchMechanism;
import org.uitnet.testing.smartfwk.ui.core.utils.PageScrollUtil;
import org.uitnet.testing.smartfwk.ui.standard.domobj.ListBoxSD;

public class ListBoxValidatorSD
extends ListBoxValidator {
    protected DOMObjectValidator domObjValidator;

    public ListBoxValidatorSD(SmartAppDriver appDriver, ListBoxSD uiObject, Region region) {
        super(appDriver, uiObject, region);
        this.domObjValidator = new DOMObjectValidator(appDriver, new DOMObject(uiObject.getType(), uiObject.getDisplayName(), uiObject.getPlatformLocators()), region);
    }

    public DOMObjectValidator getDOMObjectValidator() {
        return this.domObjValidator;
    }

    @Override
    public boolean isDisabled(int maxIterationsToLocateElements) {
        return this.domObjValidator.isDisabled(maxIterationsToLocateElements);
    }

    @Override
    public ListBoxValidatorSD validateDisabled(int maxIterationsToLocateElements) {
        Assert.assertTrue((boolean)this.domObjValidator.isDisabled(maxIterationsToLocateElements), (String)("'" + this.uiObject.getDisplayName() + "' element is not disabled."));
        return this;
    }

    @Override
    public ListBoxValidatorSD validateEnabled(int maxIterationsToLocateElements) {
        Assert.assertFalse((boolean)this.domObjValidator.isDisabled(maxIterationsToLocateElements), (String)("'" + this.uiObject.getDisplayName() + "' element is not enabled."));
        return this;
    }

    @Override
    public boolean isDisabledButNotReadonly(int maxIterationsToLocateElements) {
        return this.domObjValidator.isDisabledButNotReadonly(maxIterationsToLocateElements);
    }

    @Override
    public ListBoxValidatorSD validateDisabledButNotReadonly(int maxIterationsToLocateElements) {
        Assert.assertTrue((boolean)this.domObjValidator.isDisabledButNotReadonly(maxIterationsToLocateElements), (String)("'" + this.uiObject.getDisplayName() + "' element is not disabled."));
        return this;
    }

    @Override
    public ListBoxValidatorSD validateEnabledButNotReadonly(int maxIterationsToLocateElements) {
        Assert.assertFalse((boolean)this.domObjValidator.isDisabledButNotReadonly(maxIterationsToLocateElements), (String)("'" + this.uiObject.getDisplayName() + "' element is not enabled."));
        return this;
    }

    @Override
    public ListBoxValidatorSD typeText(String textToType, NewTextLocation location, int maxIterationsToLocateElements) {
        this.domObjValidator.typeText(textToType, location, maxIterationsToLocateElements);
        return this;
    }

    @Override
    public boolean isPresent(int maxIterationsToLocateElements) {
        return this.domObjValidator.isPresent(maxIterationsToLocateElements);
    }

    @Override
    public boolean isVisible(int maxIterationsToLocateElements) {
        return this.domObjValidator.isVisible(maxIterationsToLocateElements);
    }

    @Override
    public ListBoxValidatorSD click(int maxIterationsToLocateElements) {
        this.domObjValidator.click(maxIterationsToLocateElements);
        return this;
    }

    @Override
    public ListBoxValidatorSD doubleClick(int maxIterationsToLocateElements) {
        this.domObjValidator.doubleClick(maxIterationsToLocateElements);
        return this;
    }

    @Override
    public ListBoxValidatorSD rightClick(int maxIterationsToLocateElements) {
        this.domObjValidator.rightClick(maxIterationsToLocateElements);
        return this;
    }

    @Override
    public ListBoxValidatorSD clickAndHold(int maxIterationsToLocateElements) {
        this.domObjValidator.clickAndHold(maxIterationsToLocateElements);
        return this;
    }

    @Override
    public ListBoxValidatorSD release(int maxIterationsToLocateElements) {
        this.domObjValidator.release(maxIterationsToLocateElements);
        return this;
    }

    @Override
    public ListBoxValidatorSD performKeyDown(Keys keys, int maxIterationsToLocateElements) {
        this.domObjValidator.performKeyDown(keys, maxIterationsToLocateElements);
        return this;
    }

    @Override
    public ListBoxValidatorSD performKeyUp(Keys keys, int maxIterationsToLocateElements) {
        this.domObjValidator.performKeyUp(keys, maxIterationsToLocateElements);
        return this;
    }

    @Override
    public ListBoxValidatorSD performKeyPressed(Keys keys, int maxIterationsToLocateElements) {
        this.domObjValidator.performKeyPressed(keys, maxIterationsToLocateElements);
        return this;
    }

    @Override
    public ListBoxValidatorSD scrollElementOnViewport(Scrollbar scrollbar) {
        this.domObjValidator.scrollElementOnViewport(scrollbar);
        return this;
    }

    @Override
    public ListBoxValidatorSD validateSelectedItem(String expectedSelectedValue, TextMatchMechanism validationMechanism, int maxIterationsToLocateElements) {
        try {
            for (int i = 0; i <= maxIterationsToLocateElements; ++i) {
                try {
                    WebElement selectElement = this.domObjValidator.findElement(0);
                    List options = selectElement.findElements(By.xpath((String)"./option"));
                    Assert.assertNotNull((Object)options, (String)("Failed to find items for Choices '" + this.uiObject.getDisplayName() + "'."));
                    Assert.assertTrue((options.size() > 0 ? 1 : 0) != 0, (String)("Failed to find items in Choices '" + this.uiObject.getDisplayName() + "'. Found 0 items."));
                    boolean found = false;
                    for (WebElement option : options) {
                        String optionTextValue = option.getText();
                        if (optionTextValue == null || !option.isSelected() || !this.matchTextValue(optionTextValue.trim(), expectedSelectedValue, validationMechanism)) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        Assert.fail((String)("Failed to find selected item '" + expectedSelectedValue + "' in Choices '" + this.uiObject.getDisplayName() + "'."));
                    }
                    return this;
                }
                catch (Throwable th) {
                    if (i == maxIterationsToLocateElements) {
                        throw th;
                    }
                    this.appDriver.waitForSeconds(2);
                    continue;
                }
            }
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to validate selected item '" + expectedSelectedValue + "' for element '" + this.uiObject.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    @Override
    public String getSelectedItem(int maxIterationsToLocateElements) {
        WebElement selectElement = this.domObjValidator.findElement(maxIterationsToLocateElements);
        List options = selectElement.findElements(By.xpath((String)"./option"));
        Assert.assertNotNull((Object)options, (String)("Failed to find items for Choices '" + this.uiObject.getDisplayName() + "'."));
        Assert.assertTrue((options.size() > 0 ? 1 : 0) != 0, (String)("Failed to find items in Choices '" + this.uiObject.getDisplayName() + "'. Found 0 items."));
        for (WebElement option : options) {
            String optionTextValue = option.getText();
            if (optionTextValue == null || !option.isSelected()) continue;
            return optionTextValue;
        }
        return null;
    }

    @Override
    public List<String> getSelectedItems(int maxIterationsToLocateElements) {
        WebElement selectElement = this.domObjValidator.findElement(maxIterationsToLocateElements);
        List options = selectElement.findElements(By.xpath((String)"./option"));
        Assert.assertNotNull((Object)options, (String)("Failed to find items for Choices '" + this.uiObject.getDisplayName() + "'."));
        Assert.assertTrue((options.size() > 0 ? 1 : 0) != 0, (String)("Failed to find items in Choices '" + this.uiObject.getDisplayName() + "'. Found 0 items."));
        LinkedList<String> selectedItems = new LinkedList<String>();
        for (WebElement option : options) {
            String optionTextValue = option.getText();
            if (optionTextValue == null || !option.isSelected()) continue;
            selectedItems.add(optionTextValue);
        }
        return selectedItems;
    }

    @Override
    public ListBoxValidatorSD selectFirstItem(int maxIterationsToLocateElements) {
        try {
            for (int i = 0; i <= maxIterationsToLocateElements; ++i) {
                try {
                    WebElement selectElement = this.domObjValidator.findElement(0);
                    List options = selectElement.findElements(By.xpath((String)"./option"));
                    Assert.assertNotNull((Object)options, (String)("Failed to find items for Choices '" + this.uiObject.getDisplayName() + "'."));
                    Assert.assertTrue((options.size() > 0 ? 1 : 0) != 0, (String)("Failed to find items in Choices '" + this.uiObject.getDisplayName() + "'. Found 0 items."));
                    PageScrollUtil.mouseClick(this.appDriver, (WebElement)options.get(0));
                    return this;
                }
                catch (Throwable th) {
                    if (i == maxIterationsToLocateElements) {
                        throw th;
                    }
                    this.appDriver.waitForSeconds(2);
                    continue;
                }
            }
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to select first item for element '" + this.uiObject.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    @Override
    public ListBoxValidatorSD selectLastItem(int maxIterationsToLocateElements) {
        try {
            for (int i = 0; i <= maxIterationsToLocateElements; ++i) {
                try {
                    WebElement selectElement = this.domObjValidator.findElement(0);
                    List options = selectElement.findElements(By.xpath((String)"./option"));
                    Assert.assertNotNull((Object)options, (String)("Failed to find items for Choices '" + this.uiObject.getDisplayName() + "'."));
                    Assert.assertTrue((options.size() > 0 ? 1 : 0) != 0, (String)("Failed to find items in Choices '" + this.uiObject.getDisplayName() + "'. Found 0 items."));
                    PageScrollUtil.mouseClick(this.appDriver, (WebElement)options.get(options.size() - 1));
                    return this;
                }
                catch (Throwable th) {
                    if (i == maxIterationsToLocateElements) {
                        throw th;
                    }
                    this.appDriver.waitForSeconds(2);
                    continue;
                }
            }
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to select last item for element '" + this.uiObject.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    @Override
    public ListBoxValidatorSD selectItem(String itemName, int maxIterationsToLocateElements) {
        try {
            for (int i = 0; i <= maxIterationsToLocateElements; ++i) {
                try {
                    WebElement selectElement = this.domObjValidator.findElement(0);
                    List options = selectElement.findElements(By.xpath((String)"./option"));
                    Assert.assertNotNull((Object)options, (String)("Failed to find items for Choices '" + this.uiObject.getDisplayName() + "'."));
                    boolean found = false;
                    for (WebElement option : options) {
                        String optionTextValue = option.getText();
                        if (optionTextValue != null && itemName.equals(optionTextValue.trim())) {
                            if (!option.isSelected()) {
                                PageScrollUtil.mouseClick(this.appDriver, option);
                            }
                            found = true;
                            continue;
                        }
                        if (!option.isSelected()) continue;
                        PageScrollUtil.mouseClick(this.appDriver, option);
                    }
                    if (!found) {
                        Assert.fail((String)("Failed to find item '" + itemName + "' in Choices '" + this.uiObject.getDisplayName() + "'."));
                    }
                    return this;
                }
                catch (Throwable th) {
                    if (i == maxIterationsToLocateElements) {
                        throw th;
                    }
                    this.appDriver.waitForSeconds(2);
                    continue;
                }
            }
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to select item '" + itemName + "' for element '" + this.uiObject.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    @Override
    public ListBoxValidatorSD selectItems(ItemList<String> itemsToBeSelected, int maxIterationsToLocateElements) {
        try {
            for (int i = 0; i <= maxIterationsToLocateElements; ++i) {
                try {
                    WebElement selectElement = this.domObjValidator.findElement(0);
                    List options = selectElement.findElements(By.xpath((String)"./option"));
                    Assert.assertNotNull((Object)options, (String)("Failed to find items for Choices '" + this.uiObject.getDisplayName() + "'."));
                    LinkedList<String> foundItemList = new LinkedList<String>();
                    for (WebElement option : options) {
                        String optionTextValue = option.getText();
                        if (optionTextValue == null || !itemsToBeSelected.getItems().contains(optionTextValue.trim())) continue;
                        PageScrollUtil.mouseClick(this.appDriver, option);
                        foundItemList.add(optionTextValue.trim());
                    }
                    if (foundItemList.size() != itemsToBeSelected.size()) {
                        itemsToBeSelected.removeAll(foundItemList);
                        Assert.fail((String)("Failed to find item(s) '" + itemsToBeSelected + "' in Choices '" + this.uiObject.getDisplayName() + "'."));
                    }
                    return this;
                }
                catch (Throwable th) {
                    if (i == maxIterationsToLocateElements) {
                        throw th;
                    }
                    this.appDriver.waitForSeconds(2);
                    continue;
                }
            }
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to select item for element '" + this.uiObject.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    @Override
    public ListBoxValidatorSD validateItemsPresent(ItemList<String> items, int maxIterationsToLocateElements) {
        try {
            for (int i = 0; i <= maxIterationsToLocateElements; ++i) {
                try {
                    WebElement selectElement = this.domObjValidator.findElement(0);
                    List options = selectElement.findElements(By.xpath((String)"./option"));
                    Assert.assertNotNull((Object)options, (String)("Failed to find items for Choices '" + this.uiObject.getDisplayName() + "'."));
                    Assert.assertTrue((options.size() > 0 ? 1 : 0) != 0, (String)("Failed to find items in Choices '" + this.uiObject.getDisplayName() + "'. Found 0 items."));
                    for (String item : items.getItems()) {
                        boolean found = false;
                        for (WebElement option : options) {
                            String optionTextValue = option.getText();
                            if (optionTextValue == null || !this.matchTextValue(optionTextValue.trim(), item, TextMatchMechanism.exactMatchWithExpectedValue)) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        Assert.fail((String)("Failed to find item '" + item + "' in Choices '" + this.uiObject.getDisplayName() + "'."));
                    }
                    return this;
                }
                catch (Throwable th) {
                    if (i == maxIterationsToLocateElements) {
                        throw th;
                    }
                    this.appDriver.waitForSeconds(2);
                    continue;
                }
            }
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to validate item presence for element '" + this.uiObject.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    @Override
    public ListBoxValidatorSD validateItemsNotPresent(ItemList<String> items, int maxIterationsToLocateElements) {
        try {
            for (int i = 0; i <= maxIterationsToLocateElements; ++i) {
                try {
                    WebElement selectElement = this.domObjValidator.findElement(0);
                    List options = selectElement.findElements(By.xpath((String)"./option"));
                    Assert.assertNotNull((Object)options, (String)("Failed to find items for Choices '" + this.uiObject.getDisplayName() + "'."));
                    Assert.assertTrue((options.size() > 0 ? 1 : 0) != 0, (String)("Failed to find items in Choices '" + this.uiObject.getDisplayName() + "'. Found 0 items."));
                    for (String item : items.getItems()) {
                        boolean found = false;
                        for (WebElement option : options) {
                            String optionTextValue = option.getText();
                            if (optionTextValue == null || !this.matchTextValue(optionTextValue.trim(), item, TextMatchMechanism.exactMatchWithExpectedValue)) continue;
                            found = true;
                            break;
                        }
                        if (!found) continue;
                        Assert.fail((String)("Item '" + item + "' is present in Choices '" + this.uiObject.getDisplayName() + "'."));
                    }
                    return this;
                }
                catch (Throwable th) {
                    if (i == maxIterationsToLocateElements) {
                        throw th;
                    }
                    this.appDriver.waitForSeconds(2);
                    continue;
                }
            }
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to validate eitem absence for element '" + this.uiObject.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    public WebElement findElement(int maxIterationsToLocateElements) {
        return this.domObjValidator.findElement(maxIterationsToLocateElements);
    }

    public WebElement findElementNoException(int maxIterationsToLocateElements) {
        return this.domObjValidator.findElementNoException(maxIterationsToLocateElements);
    }

    @Override
    public List<WebElement> findElements(int maxIterationsToLocateElements) {
        return this.domObjValidator.findElements(maxIterationsToLocateElements);
    }

    @Override
    public Actions getNewSeleniumActions() {
        return this.domObjValidator.getNewSeleniumActions();
    }
}

