/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.standard.imgobj;

import java.util.List;
import org.openqa.selenium.Keys;
import org.openqa.selenium.interactions.Actions;
import org.sikuli.script.Button;
import org.sikuli.script.Location;
import org.sikuli.script.Match;
import org.sikuli.script.Region;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.appdriver.SmartAppDriver;
import org.uitnet.testing.smartfwk.ui.core.commons.ImageSection;
import org.uitnet.testing.smartfwk.ui.core.commons.UIObjectType;
import org.uitnet.testing.smartfwk.ui.core.objects.ImageObject;
import org.uitnet.testing.smartfwk.ui.core.objects.NewTextLocation;
import org.uitnet.testing.smartfwk.ui.core.objects.label.LabelValidator;
import org.uitnet.testing.smartfwk.ui.core.objects.scrollbar.Scrollbar;
import org.uitnet.testing.smartfwk.ui.core.objects.validator.mechanisms.TextMatchMechanism;
import org.uitnet.testing.smartfwk.ui.standard.imgobj.LabelSI;

public class LabelValidatorSI
extends LabelValidator {
    protected LabelSI labelObj;

    public LabelValidatorSI(SmartAppDriver appDriver, LabelSI uiObject, Region region) {
        super(appDriver, uiObject, region);
        this.labelObj = uiObject;
    }

    @Override
    public LabelValidatorSI validateValue(String expectedName, TextMatchMechanism validationMechanism, int maxIterationsToLocateElements) {
        Match match = this.findElement(maxIterationsToLocateElements);
        this.validateTextValue(match.text(), expectedName, validationMechanism);
        return this;
    }

    @Override
    public String getValue(int maxIterationsToLocateElements) {
        return this.findElement(maxIterationsToLocateElements).text();
    }

    @Override
    public boolean isPresent(int maxIterationsToLocateElements) {
        Match m = this.findElementNoException(maxIterationsToLocateElements);
        return m != null;
    }

    @Override
    public boolean isVisible(int maxIterationsToLocateElements) {
        return this.isPresent(maxIterationsToLocateElements);
    }

    @Override
    public LabelValidatorSI click(int maxIterationsToLocateElements) {
        try {
            Match match = this.findElement(maxIterationsToLocateElements);
            match.click();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse click on Label '" + this.labelObj.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    public LabelValidatorSI click(ImageSection imageSection, int maxIterationsToLocateElements) {
        try {
            Match match = this.findElement(maxIterationsToLocateElements);
            this.getImageSection(match, imageSection).click();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse click on Label '" + this.labelObj.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    @Override
    public LabelValidatorSI doubleClick(int maxIterationsToLocateElements) {
        try {
            Match match = this.findElement(maxIterationsToLocateElements);
            match.doubleClick();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse double click on Label '" + this.labelObj.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    public LabelValidatorSI doubleClick(ImageSection imageSection, int maxIterationsToLocateElements) {
        try {
            Match match = this.findElement(maxIterationsToLocateElements);
            this.getImageSection(match, imageSection).doubleClick();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse double click on Label '" + this.labelObj.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    @Override
    public LabelValidatorSI rightClick(int maxIterationsToLocateElements) {
        try {
            Match match = this.findElement(maxIterationsToLocateElements);
            match.rightClick();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse right click on Label '" + this.labelObj.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    public LabelValidatorSI rightClick(ImageSection imageSection, int maxIterationsToLocateElements) {
        try {
            Match match = this.findElement(maxIterationsToLocateElements);
            this.getImageSection(match, imageSection).rightClick();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse right click on Label '" + this.labelObj.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    @Override
    public LabelValidatorSI clickAndHold(int maxIterationsToLocateElements) {
        try {
            Match match = this.findElement(maxIterationsToLocateElements);
            match.mouseDown(Button.LEFT);
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse clickAndHold on Label '" + this.labelObj.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    @Override
    public LabelValidatorSI release(int maxIterationsToLocateElements) {
        try {
            Match match = this.findElement(maxIterationsToLocateElements);
            match.mouseDown(Button.LEFT);
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse clickAndHold on Label '" + this.labelObj.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    @Override
    public LabelValidatorSI performKeyDown(Keys keys, int maxIterationsToLocateElements) {
        try {
            Match match = this.findElement(maxIterationsToLocateElements);
            match.click();
            match.keyDown(this.seleniumToSikuliKeyConverter(keys));
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform keyDown on Label '" + this.labelObj.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    @Override
    public LabelValidatorSI performKeyUp(Keys keys, int maxIterationsToLocateElements) {
        try {
            Match match = this.findElement(maxIterationsToLocateElements);
            match.click();
            match.keyUp(this.seleniumToSikuliKeyConverter(keys));
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform keyUp ('" + this.seleniumToSikuliKeyConverter(keys) + "') on Label '" + this.labelObj.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    @Override
    public LabelValidatorSI performKeyPressed(Keys keys, int maxIterationsToLocateElements) {
        try {
            Match match = this.findElement(maxIterationsToLocateElements);
            match.click();
            match.keyDown(this.seleniumToSikuliKeyConverter(keys));
            match.keyUp(this.seleniumToSikuliKeyConverter(keys));
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform keyPressed ('" + this.seleniumToSikuliKeyConverter(keys) + "') on Label '" + this.labelObj.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    @Override
    @Deprecated
    public LabelValidatorSI typeText(String text, NewTextLocation location, int maxIterationsToLocateElements) {
        Assert.fail((String)"typeText() API is not supported for Label element.");
        return this;
    }

    @Override
    public LabelValidatorSI scrollElementOnViewport(Scrollbar scrollbar) {
        return this;
    }

    public Match findElement(int maxIterationsToLocateElements) {
        Match match = null;
        for (int i = 0; i <= maxIterationsToLocateElements; ++i) {
            try {
                Region region = this.labelObj.getLabelImageLocation().getRegionOfImageObject(this.appDriver, this.labelObj.getLabelImage(this.appDriver.getAppConfig().getTestPlatformType(), this.appDriver.getAppConfig().getAppType(), this.appDriver.getAppConfig().getAppWebBrowser()));
                Assert.assertNotNull((Object)region, (String)("Failed to find Label '" + this.labelObj.getDisplayName() + "'."));
                match = new Match(region, 1.0);
                break;
            }
            catch (Throwable th) {
                if (i == maxIterationsToLocateElements) {
                    Assert.fail((String)("Unable to find Label '" + this.labelObj.getDisplayName() + "'. Reason timeout(waited for " + maxIterationsToLocateElements * 2 + " seconds)."), (Throwable)th);
                    break;
                }
                this.appDriver.waitForSeconds(2);
                continue;
            }
        }
        return match;
    }

    public Match findElementNoException(int maxIterationsToLocateElements) {
        Match match = null;
        try {
            match = this.findElement(maxIterationsToLocateElements);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return match;
    }

    @Override
    public List<Match> findElements(int maxIterationsToLocateElements) {
        Region r = this.labelObj.getLabelImageLocation().getRegion(this.appDriver);
        return new ImageObject(UIObjectType.label, this.labelObj.getDisplayName(), this.labelObj.getLabelImage(this.appDriver.getAppConfig().getTestPlatformType(), this.appDriver.getAppConfig().getAppType(), this.appDriver.getAppConfig().getAppWebBrowser())).getValidator(this.appDriver, r).findElements(maxIterationsToLocateElements);
    }

    public LabelValidatorSI dragAndDrop(ImageObject target, Region targetRegion, int maxIterationsToLocateElements) {
        try {
            Match sourceElem = this.findElement(maxIterationsToLocateElements);
            Match targetElem = target.getValidator(this.appDriver, targetRegion).findElement(maxIterationsToLocateElements);
            Assert.assertNotNull((Object)sourceElem, (String)("Failed to find Label '" + this.labelObj.getDisplayName() + "'."));
            Assert.assertNotNull((Object)targetElem, (String)("Failed to find element '" + target.getDisplayName() + "'."));
            sourceElem.drag((Object)targetElem);
            sourceElem.dropAt((Object)targetElem);
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform dragAndDrop from source '" + this.labelObj.getDisplayName() + "' to target '" + target.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    protected Location getImageSection(Match imageMatch, ImageSection imageSection) {
        switch (imageSection) {
            case topLeft: {
                return imageMatch.getTopLeft();
            }
            case topRight: {
                return imageMatch.getTopRight();
            }
            case bottomLeft: {
                return imageMatch.getBottomLeft();
            }
            case bottomRight: {
                return imageMatch.getBottomRight();
            }
            case center: {
                return imageMatch.getCenter();
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public Actions getNewSeleniumActions() {
        Assert.fail((String)"getNewSeleniumActions() API is not supported by Button component.");
        return null;
    }
}

