/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.standard.imgobj;

import java.util.Iterator;
import java.util.List;
import org.openqa.selenium.Keys;
import org.openqa.selenium.interactions.Actions;
import org.sikuli.script.Button;
import org.sikuli.script.FindFailed;
import org.sikuli.script.Location;
import org.sikuli.script.Match;
import org.sikuli.script.Region;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.appdriver.SmartAppDriver;
import org.uitnet.testing.smartfwk.ui.core.commons.ImageSection;
import org.uitnet.testing.smartfwk.ui.core.commons.ItemList;
import org.uitnet.testing.smartfwk.ui.core.objects.ImageObject;
import org.uitnet.testing.smartfwk.ui.core.objects.NewTextLocation;
import org.uitnet.testing.smartfwk.ui.core.objects.listbox.ListBoxValidator;
import org.uitnet.testing.smartfwk.ui.core.objects.scrollbar.Scrollbar;
import org.uitnet.testing.smartfwk.ui.core.objects.validator.mechanisms.TextMatchMechanism;
import org.uitnet.testing.smartfwk.ui.core.utils.ClipboardUtil;
import org.uitnet.testing.smartfwk.ui.standard.imgobj.ListBoxSI;

public class ListBoxValidatorSI
extends ListBoxValidator {
    protected ListBoxSI listBoxObj;

    public ListBoxValidatorSI(SmartAppDriver appDriver, ListBoxSI uiObject, Region region) {
        super(appDriver, uiObject, region);
        this.listBoxObj = uiObject;
    }

    @Override
    @Deprecated
    public ListBoxValidatorSI validateDisabled(int maxIterationsToLocateElements) {
        Assert.fail((String)"validateDisabled() API is not supported by ListBoxSI.");
        return this;
    }

    @Override
    @Deprecated
    public ListBoxValidatorSI validateEnabled(int maxIterationsToLocateElements) {
        Assert.fail((String)"validateEnabled() API is not supported by ListBoxSI.");
        return this;
    }

    @Override
    public boolean isPresent(int maxIterationsToLocateElements) {
        Match m = this.findElementNoException(maxIterationsToLocateElements);
        return m != null;
    }

    @Override
    public boolean isVisible(int maxIterationsToLocateElements) {
        return this.isPresent(maxIterationsToLocateElements);
    }

    @Override
    public ListBoxValidatorSI click(int maxIterationsToLocateElements) {
        try {
            Match match = this.findElement(maxIterationsToLocateElements);
            match.click();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse click on Choices '" + this.listBoxObj.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    public ListBoxValidatorSI click(ImageSection imageSection, int maxIterationsToLocateElements) {
        try {
            Match match = this.findElement(maxIterationsToLocateElements);
            this.getImageSection(match, imageSection).click();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse click on Choices '" + this.listBoxObj.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    @Override
    public ListBoxValidatorSI doubleClick(int maxIterationsToLocateElements) {
        try {
            Match match = this.findElement(maxIterationsToLocateElements);
            match.doubleClick();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse double click on Choices '" + this.listBoxObj.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    public ListBoxValidatorSI doubleClick(ImageSection imageSection, int maxIterationsToLocateElements) {
        try {
            Match match = this.findElement(maxIterationsToLocateElements);
            this.getImageSection(match, imageSection).doubleClick();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse double click on Choices '" + this.listBoxObj.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    @Override
    public ListBoxValidatorSI rightClick(int maxIterationsToLocateElements) {
        try {
            Match match = this.findElement(maxIterationsToLocateElements);
            match.rightClick();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse right click on Choices '" + this.listBoxObj.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    public ListBoxValidatorSI rightClick(ImageSection imageSection, int maxIterationsToLocateElements) {
        try {
            Match match = this.findElement(maxIterationsToLocateElements);
            this.getImageSection(match, imageSection).rightClick();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse right click on Choices '" + this.listBoxObj.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    @Override
    public ListBoxValidatorSI clickAndHold(int maxIterationsToLocateElements) {
        try {
            Match match = this.findElement(maxIterationsToLocateElements);
            match.mouseDown(Button.LEFT);
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse clickAndHold on Choices '" + this.listBoxObj.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    @Override
    public ListBoxValidatorSI release(int maxIterationsToLocateElements) {
        try {
            Match match = this.findElement(maxIterationsToLocateElements);
            match.mouseDown(Button.LEFT);
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse clickAndHold on Choices '" + this.listBoxObj.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    @Override
    public ListBoxValidatorSI performKeyDown(Keys keys, int maxIterationsToLocateElements) {
        try {
            Match match = this.findElement(maxIterationsToLocateElements);
            match.click();
            match.keyDown(this.seleniumToSikuliKeyConverter(keys));
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform keyDown on Choices '" + this.listBoxObj.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    @Override
    public ListBoxValidatorSI performKeyUp(Keys keys, int maxIterationsToLocateElements) {
        try {
            Match match = this.findElement(maxIterationsToLocateElements);
            match.click();
            match.keyUp(this.seleniumToSikuliKeyConverter(keys));
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform keyUp ('" + this.seleniumToSikuliKeyConverter(keys) + "') on Choices '" + this.listBoxObj.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    @Override
    public ListBoxValidatorSI performKeyPressed(Keys keys, int maxIterationsToLocateElements) {
        try {
            Match match = this.findElement(maxIterationsToLocateElements);
            match.click();
            match.type(this.seleniumToSikuliKeyConverter(keys));
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform keyPressed ('" + this.seleniumToSikuliKeyConverter(keys) + "') on Choices '" + this.listBoxObj.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    @Override
    public ListBoxValidatorSI typeText(String text, NewTextLocation location, int maxIterationsToLocateElements) {
        Match match = this.findElement(maxIterationsToLocateElements);
        try {
            match.click();
            switch (location) {
                case start: {
                    match.type("\ue008");
                    break;
                }
                case end: {
                    match.type("\ue007");
                    break;
                }
                case replace: {
                    match.type("a", 2);
                }
            }
            match.type(text);
        }
        catch (Throwable th) {
            Assert.fail((String)("Fail to type text '" + text + "' in Choices '" + this.listBoxObj.getDisplayName() + "'."));
        }
        return this;
    }

    @Override
    public ListBoxValidatorSI scrollElementOnViewport(Scrollbar scrollbar) {
        return this;
    }

    public Match findElement(int maxIterationsToLocateElements) {
        Match match = null;
        for (int i = 0; i <= maxIterationsToLocateElements; ++i) {
            try {
                Region region = this.listBoxObj.getLocation().getRegionOfImageObject(this.appDriver, this.listBoxObj.getWidth(), this.listBoxObj.getHeight());
                Assert.assertNotNull((Object)region, (String)("Failed to find Choices '" + this.listBoxObj.getDisplayName() + "'."));
                match = new Match(region, 1.0);
                break;
            }
            catch (Throwable th) {
                if (i == maxIterationsToLocateElements) {
                    Assert.fail((String)("Unable to find Choices '" + this.listBoxObj.getDisplayName() + "'. Reason timeout(waited for " + maxIterationsToLocateElements * 2 + " seconds)."), (Throwable)th);
                    break;
                }
                this.appDriver.waitForSeconds(2);
                continue;
            }
        }
        return match;
    }

    public Match findElementNoException(int maxIterationsToLocateElements) {
        Match match = null;
        try {
            match = this.findElement(maxIterationsToLocateElements);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return match;
    }

    @Override
    public List<Match> findElements(int maxIterationsToLocateElements) {
        Assert.fail((String)"findElements() api for ListBoxSI element is not implemented.");
        return null;
    }

    public ListBoxValidatorSI dragAndDrop(ImageObject target, Region targetRegion, int maxIterationsToLocateElements) {
        try {
            Match sourceElem = this.findElement(maxIterationsToLocateElements);
            Match targetElem = target.getValidator(this.appDriver, targetRegion).findElement(maxIterationsToLocateElements);
            Assert.assertNotNull((Object)sourceElem, (String)("Failed to find Choices '" + this.listBoxObj.getDisplayName() + "'."));
            Assert.assertNotNull((Object)targetElem, (String)("Failed to find element '" + target.getDisplayName() + "'."));
            sourceElem.drag((Object)targetElem);
            sourceElem.dropAt((Object)targetElem);
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform dragAndDrop from source '" + this.listBoxObj.getDisplayName() + "' to target '" + target.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    protected Location getImageSection(Match imageMatch, ImageSection imageSection) {
        switch (imageSection) {
            case topLeft: {
                return imageMatch.getTopLeft();
            }
            case topRight: {
                return imageMatch.getTopRight();
            }
            case bottomLeft: {
                return imageMatch.getBottomLeft();
            }
            case bottomRight: {
                return imageMatch.getBottomRight();
            }
            case center: {
                return imageMatch.getCenter();
            }
        }
        return null;
    }

    @Override
    public ListBoxValidatorSI validateSelectedItem(String expectedValue, TextMatchMechanism validationMechanism, int maxIterationsToLocateElements) {
        if (this.listBoxObj.isDisabled()) {
            Match match = this.findElement(maxIterationsToLocateElements);
            this.validateTextValue(match.text(), expectedValue, validationMechanism);
        } else {
            this.validateTextValue(this.getSelectedItem(maxIterationsToLocateElements), expectedValue, validationMechanism);
        }
        return this;
    }

    @Override
    public String getSelectedItem(int maxIterationsToLocateElements) {
        Match match = this.findElement(maxIterationsToLocateElements);
        if (this.listBoxObj.isDisabled()) {
            return match.text();
        }
        match.click();
        match.type("ac", 2);
        String contents = ClipboardUtil.getContents();
        ClipboardUtil.clearContents();
        match.click();
        return contents;
    }

    @Override
    public List<String> getSelectedItems(int maxIterationsToLocateElements) {
        Assert.fail((String)"getSelectedItems() API is not implemented.");
        return null;
    }

    @Override
    public ListBoxValidatorSI selectFirstItem(int maxIterationsToLocateElements) {
        Assert.fail((String)"selectFirstItem() API is not implemented.");
        return this;
    }

    @Override
    public ListBoxValidatorSI selectLastItem(int maxIterationsToLocateElements) {
        Assert.fail((String)"selectLastItem() API is not implemented.");
        return this;
    }

    @Override
    public ListBoxValidatorSI selectItem(String itemName, int maxIterationsToLocateElements) {
        Match match = this.findElement(maxIterationsToLocateElements);
        try {
            Match menuItemMatch = match.findBest(new Object[]{itemName});
            Assert.assertNotNull((Object)menuItemMatch, (String)("Failed to find item '" + itemName + "' in Choices '" + this.listBoxObj.getDisplayName() + "'."));
            menuItemMatch.click();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to find item '" + itemName + "' in Choices '" + this.listBoxObj.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    public ListBoxValidatorSI selectItemByImage(String imageItem, int maxIterationsToLocateElements) {
        Match match = this.findElement(maxIterationsToLocateElements);
        try {
            Match menuItemMatch = match.findBest(new Object[]{imageItem});
            Assert.assertNotNull((Object)menuItemMatch, (String)("Failed to find item '" + imageItem + "' in Choices '" + this.listBoxObj.getDisplayName() + "'."));
            menuItemMatch.click();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to find item '" + imageItem + "' in pull down menu of Choices '" + this.listBoxObj.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    @Override
    public ListBoxValidatorSI selectItems(ItemList<String> itemsToBeSelected, int maxIterationsToLocateElements) {
        Match match = this.findElement(maxIterationsToLocateElements);
        String currentItemName = "";
        try {
            Iterator<String> iterator = itemsToBeSelected.getItems().iterator();
            while (iterator.hasNext()) {
                String itemName;
                currentItemName = itemName = iterator.next();
                Match menuItemMatch = match.find((Object)itemName);
                Assert.assertNotNull((Object)menuItemMatch, (String)("Failed to find item '" + itemName + "' in Choices '" + this.listBoxObj.getDisplayName() + "'."));
                menuItemMatch.keyDown("\ue021");
                menuItemMatch.click();
                menuItemMatch.keyUp("\ue021");
            }
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to find item '" + currentItemName + "' in Choices '" + this.listBoxObj.getDisplayName() + "'."));
        }
        return this;
    }

    public ListBoxValidatorSI selectItemsByImage(ItemList<String> imageItemsToBeSelected, int maxIterationsToLocateElements) {
        Match match = this.findElement(maxIterationsToLocateElements);
        String currentImageItem = "";
        try {
            Iterator<String> iterator = imageItemsToBeSelected.getItems().iterator();
            while (iterator.hasNext()) {
                String imageItem;
                currentImageItem = imageItem = iterator.next();
                Match menuItemMatch = match.find((Object)imageItem);
                Assert.assertNotNull((Object)menuItemMatch, (String)("Failed to find item '" + imageItem + "' in Choices '" + this.listBoxObj.getDisplayName() + "'."));
                menuItemMatch.keyDown("\ue021");
                menuItemMatch.click();
                menuItemMatch.keyUp("\ue021");
            }
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to find item '" + currentImageItem + "' in Choices '" + this.listBoxObj.getDisplayName() + "'."));
        }
        return this;
    }

    @Override
    public ListBoxValidatorSI validateItemsPresent(ItemList<String> items, int maxIterationsToLocateElements) {
        Match match = this.findElement(maxIterationsToLocateElements);
        String currentItemName = "";
        try {
            Iterator<String> iterator = items.getItems().iterator();
            while (iterator.hasNext()) {
                String itemName;
                currentItemName = itemName = iterator.next();
                Match menuItemMatch = match.find((Object)itemName);
                if (menuItemMatch != null) continue;
                throw new FindFailed("Found no match.");
            }
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to find item '" + currentItemName + "' in Choices '" + this.listBoxObj.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    public ListBoxValidatorSI validateItemsPresentByImage(ItemList<String> imageItems, int maxIterationsToLocateElements) {
        Match match = this.findElement(maxIterationsToLocateElements);
        String currentImageItem = "";
        try {
            Iterator<String> iterator = imageItems.getItems().iterator();
            while (iterator.hasNext()) {
                String imageItem;
                currentImageItem = imageItem = iterator.next();
                Match menuItemMatch = match.find((Object)imageItem);
                if (menuItemMatch != null) continue;
                throw new FindFailed("Found no match.");
            }
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to find item '" + currentImageItem + "' in Choices '" + this.listBoxObj.getDisplayName() + "'."), (Throwable)th);
        }
        return this;
    }

    @Override
    public ListBoxValidatorSI validateItemsNotPresent(ItemList<String> items, int maxIterationsToLocateElements) {
        Match match = this.findElement(maxIterationsToLocateElements);
        for (String itemName : items.getItems()) {
            try {
                Match menuItemMatch = match.find((Object)itemName);
                Assert.assertNull((Object)menuItemMatch, (String)("Item '" + itemName + "' in Choices '" + this.listBoxObj.getDisplayName() + "' is already present."));
            }
            catch (FindFailed findFailed) {}
        }
        return this;
    }

    public ListBoxValidatorSI validateItemsNotPresentByImage(ItemList<String> imageItems, int maxIterationsToLocateElements) {
        Match match = this.findElement(maxIterationsToLocateElements);
        for (String imageItem : imageItems.getItems()) {
            try {
                Match menuItemMatch = match.find((Object)imageItem);
                Assert.assertNull((Object)menuItemMatch, (String)("Item '" + imageItem + "' in Choices '" + this.listBoxObj.getDisplayName() + "' is already present."));
            }
            catch (FindFailed findFailed) {}
        }
        return this;
    }

    @Override
    @Deprecated
    public boolean isDisabled(int maxIterationsToLocateElements) {
        Assert.fail((String)"isDisabled() API is not supported by ListBox component.");
        return false;
    }

    @Override
    @Deprecated
    public Actions getNewSeleniumActions() {
        Assert.fail((String)"getNewSeleniumActions() API is not supported by ListBox component.");
        return null;
    }

    @Override
    public boolean isDisabledButNotReadonly(int maxIterationsToLocateElements) {
        Assert.fail((String)"isDisabledButNotReadonly() API is not supported by ListBox component.");
        return false;
    }

    @Override
    public ListBoxValidatorSI validateDisabledButNotReadonly(int maxIterationsToLocateElements) {
        Assert.fail((String)"validateDisabledButNotReadonly() API is not supported by ListBox component.");
        return this;
    }

    @Override
    public ListBoxValidatorSI validateEnabledButNotReadonly(int maxIterationsToLocateElements) {
        Assert.fail((String)"validateEnabledButNotReadonly() API is not supported by ListBox component.");
        return this;
    }
}

