/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.api.core.validator.yaml;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.TypeRef;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.api.core.reader.YamlDocumentReader;
import org.uitnet.testing.smartfwk.ui.core.utils.JsonYamlUtil;

public class YamlDocumentValidator {
    protected YamlDocumentReader yamlDocReader;

    public YamlDocumentValidator(String yamlAsString) {
        this.yamlDocReader = new YamlDocumentReader(yamlAsString);
    }

    public YamlDocumentValidator(File yamlFilePath) {
        this.yamlDocReader = new YamlDocumentReader(yamlFilePath);
    }

    public DocumentContext prepareDocumentContext(Object obj) {
        return this.yamlDocReader.prepareDocumentContext(obj);
    }

    public DocumentContext getDocumentContext() {
        return this.yamlDocReader.getDocumentContext();
    }

    public <T> List<T> readValuesAsList(String yamlPath) {
        return this.yamlDocReader.readValuesAsList(yamlPath);
    }

    public <T> Set<T> readValuesAsSet(String yamlPath) {
        return this.yamlDocReader.readValuesAsSet(yamlPath);
    }

    public <T> T readSingleValue(String yamlPath) {
        return this.yamlDocReader.readSingleValue(yamlPath);
    }

    public <T> T readValueAsObject(String yamlPath, Class<T> clazz) {
        return this.yamlDocReader.readValueAsObject(yamlPath, clazz);
    }

    public void validatePathPresent(String elementName, String yamlPath) {
        List elems = (List)this.yamlDocReader.getDocumentContext().read(yamlPath, new Predicate[0]);
        Assert.assertTrue((elems != null && elems.size() > 0 ? 1 : 0) != 0, (String)("Element '" + elementName + "' does not exist on YAML Path '" + yamlPath + "'."));
    }

    public void validateExpectedNRecordsPresent(String elementName, String yamlPath, int expectedN) {
        List result = null;
        try {
            result = (List)this.yamlDocReader.getDocumentContext().read(yamlPath, new Predicate[0]);
        }
        catch (Exception e) {
            Assert.fail((String)("Element '" + elementName + "' has incorrect YAML Path '" + yamlPath + "'."), (Throwable)e);
        }
        Assert.assertNotNull((Object)result, (String)("Element '" + elementName + "' does not exist on YAML Path '" + yamlPath + "'."));
        Assert.assertTrue((result.size() == expectedN ? 1 : 0) != 0, (String)("Element '" + elementName + "' does not have exact '" + expectedN + "' records on YAML Path '" + yamlPath + "'. Found: " + result.size()));
    }

    public void validateAtleastNRecordsPresent(String elementName, String yamlPath, int atleastN) {
        List result = null;
        try {
            result = (List)this.yamlDocReader.getDocumentContext().read(yamlPath, new Predicate[0]);
        }
        catch (Exception e) {
            Assert.fail((String)("Element '" + elementName + "' has incorrect YAML Path '" + yamlPath + "'."), (Throwable)e);
        }
        Assert.assertNotNull((Object)result, (String)("Element '" + elementName + "' does not exist on YAML Path '" + yamlPath + "'."));
        Assert.assertTrue((result.size() >= atleastN ? 1 : 0) != 0, (String)("Element '" + elementName + "' does not have atleast '" + atleastN + "' records on YAML Path '" + yamlPath + "'. Found: " + result.size()));
    }

    public <T> void validateValuesPresent(String elementName, String yamlPath, T[] values) {
        TypeRef typeRef = new TypeRef<Set<T>>(){};
        Set elems = (Set)this.yamlDocReader.getDocumentContext().read(yamlPath, typeRef);
        Assert.assertFalse((elems.size() == 0 ? 1 : 0) != 0, (String)("No record found for Element '" + elementName + "' on YAML path '" + yamlPath + "'. Expects records with values: " + Arrays.asList(values) + "."));
        HashSet<T> valuesAsSet = new HashSet<T>(Arrays.asList(values));
        valuesAsSet.removeAll(elems);
        Assert.assertTrue((valuesAsSet.size() == 0 ? 1 : 0) != 0, (String)("Following values " + valuesAsSet + " do not exist for Element '" + elementName + "' on YAML Path '" + yamlPath + "'. YAML element values: " + elems));
    }

    public <T> void validateExactMatchForValues(String elementName, String yamlPath, T[] values) {
        TypeRef typeRef = new TypeRef<Set<T>>(){};
        Set elems = (Set)this.yamlDocReader.getDocumentContext().read(yamlPath, typeRef);
        Assert.assertFalse((elems.size() == 0 ? 1 : 0) != 0, (String)("No record found for Element '" + elementName + "' on YAML path '" + yamlPath + "'. Expects records with values: " + Arrays.asList(values) + "."));
        HashSet<T> valuesAsSet1 = new HashSet<T>(Arrays.asList(values));
        HashSet<T> valuesAsSet2 = new HashSet<T>(Arrays.asList(values));
        valuesAsSet1.removeAll(elems);
        elems.removeAll(valuesAsSet2);
        Assert.assertTrue((valuesAsSet1.size() == 0 ? 1 : 0) != 0, (String)("Values " + valuesAsSet1 + " are not present for Element '" + elementName + "' on YAML Path '" + yamlPath + "'. Expecting YAML path values: " + valuesAsSet2 + "."));
        Assert.assertTrue((elems.size() == 0 ? 1 : 0) != 0, (String)("Values " + elems + " are extra for Element '" + elementName + "' on YAML Path '" + yamlPath + "'. Expecting YAML path values: " + valuesAsSet2 + "."));
    }

    public <T> void validateSingleValueMatch(String elementName, String yamlPath, Class<T> valueClazz, T value) {
        Object elemValue = this.yamlDocReader.getDocumentContext().read(yamlPath, valueClazz, new Predicate[0]);
        Assert.assertEquals((Object)elemValue, value, (String)("Element '" + elementName + "' value does not match at YAML path '" + yamlPath + "'."));
    }

    public static void main(String[] args) {
        String yamlString = YamlDocumentValidator.sampleJson();
        YamlDocumentValidator validator = new YamlDocumentValidator(yamlString);
        DocumentContext docCtx = validator.getDocumentContext();
        TypeRef<HashMap<String, Object>> tRef = new TypeRef<HashMap<String, Object>>(){};
        HashMap additionalProps = (HashMap)docCtx.read("$.additionalProps", (TypeRef)tRef);
        System.out.println("additionalProps: " + additionalProps);
        System.out.println("TTT:" + JsonYamlUtil.readNoException("$.text", String.class, docCtx));
        System.out.println("TTT:" + JsonYamlUtil.readNoException("$.additionalPropsNone", new TypeRef<Map<String, Object>>(){}, docCtx));
    }

    private static String sampleJson() {
        String yaml = "profileName: test\nappName: test-app\nhostName: uitnet.org\nport: 1921\ndatabaseName: test-db\nusername: test username\npassword: test password\nadditionalPropsNone:\nadditionalProps:\n  prop1:\n    cprop1: false\n  prop2.prop3: 98.5\n  prop2.prop4: 98.5";
        return yaml;
    }
}

