/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.local_machine;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.objects.validator.mechanisms.TextMatchMechanism;
import org.uitnet.testing.smartfwk.ui.core.utils.StringUtil;

public class LocalMachineFileSystem {
    private LocalMachineFileSystem() {
    }

    public static List<String> listFiles(String absoluteLocalPath, TextMatchMechanism fileNameMatchMechanism, String expectedValue) {
        LinkedList<String> fileNames = new LinkedList<String>();
        try (Stream<Path> fs = Files.list(Path.of(absoluteLocalPath, new String[0]));){
            fs.forEach(path -> {
                if (StringUtil.isTextMatchedWithExpectedValue(path.toFile().getName(), expectedValue, fileNameMatchMechanism)) {
                    fileNames.add(path.toFile().getAbsolutePath());
                }
            });
        }
        catch (Exception e) {
            Assert.fail((String)("Failed to list files from local '" + absoluteLocalPath + "' directory. Reason: " + e.getMessage()), (Throwable)e);
        }
        return fileNames;
    }

    public static List<String> deleteFiles(String absoluteLocalPath, TextMatchMechanism fileNameMatchMechanism, String expectedValue) {
        LinkedList<String> fileNames = new LinkedList<String>();
        try (Stream<Path> fs = Files.list(Path.of(absoluteLocalPath, new String[0]));){
            fs.forEach(path -> {
                if (StringUtil.isTextMatchedWithExpectedValue(path.toFile().getName(), expectedValue, fileNameMatchMechanism)) {
                    fileNames.add(path.toFile().getAbsolutePath());
                    try {
                        Files.delete(path);
                    }
                    catch (Exception e1) {
                        throw new RuntimeException(e1.getMessage());
                    }
                }
            });
        }
        catch (Exception e) {
            Assert.fail((String)("Failed to delete files from local '" + absoluteLocalPath + "' directory. Reason: " + e.getMessage()), (Throwable)e);
        }
        return fileNames;
    }

    public static String copyFileAsNewName(String absoluteLocalFilePath, String newFileName) {
        try {
            String fileParentDir = LocalMachineFileSystem.extractFileParentDirectory(absoluteLocalFilePath);
            String newFilePath = fileParentDir + File.separator + newFileName;
            Files.copy(Path.of(absoluteLocalFilePath, new String[0]), Path.of(newFilePath, new String[0]), StandardCopyOption.REPLACE_EXISTING);
            return newFilePath;
        }
        catch (Exception e) {
            Assert.fail((String)("Fail to copy '" + absoluteLocalFilePath + "' file to new name as '" + newFileName + "'"), (Throwable)e);
            return null;
        }
    }

    public static void validateFilePresent(String absoluteLocalPath, TextMatchMechanism fileNameMatchMechanism, String expectedValue) {
        try (Stream<Path> fs = Files.list(Path.of(absoluteLocalPath, new String[0]));){
            boolean found = false;
            Iterator itr = fs.iterator();
            while (itr.hasNext()) {
                Path path = (Path)itr.next();
                if (!StringUtil.isTextMatchedWithExpectedValue(path.toFile().getName(), expectedValue, fileNameMatchMechanism)) continue;
                found = true;
                break;
            }
            if (!found) {
                Assert.fail((String)("No file match found at '" + absoluteLocalPath + "' location using FileNameMatchMechanism: " + fileNameMatchMechanism + " and expectedFileName: " + expectedValue));
            }
        }
        catch (Exception e) {
            Assert.fail((String)("Failed to check file presence at '" + absoluteLocalPath + "' location. Reason: " + e.getMessage()), (Throwable)e);
        }
    }

    public static String extractFileName(String filePath) {
        if (filePath == null) {
            return "";
        }
        int lastIndex = (filePath = filePath.replace("\\", "/")).lastIndexOf("/");
        if (lastIndex >= 0 && filePath.length() > lastIndex + 1) {
            return filePath.substring(lastIndex + 1);
        }
        return null;
    }

    public static String extractFileParentDirectory(String filePath) {
        if (filePath == null) {
            return "";
        }
        int lastIndex = (filePath = filePath.replace("\\", "/")).lastIndexOf("/");
        if (lastIndex >= 0 && filePath.length() > lastIndex + 1) {
            return filePath.substring(0, lastIndex);
        }
        return null;
    }
}

