/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.remote_machine;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.Session;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.testng.Assert;
import org.testng.collections.Lists;
import org.uitnet.testing.smartfwk.local_machine.LocalMachineFileSystem;
import org.uitnet.testing.smartfwk.remote_machine.RemoteMachineConfig;
import org.uitnet.testing.smartfwk.remote_machine.RemoteMachineConnection;
import org.uitnet.testing.smartfwk.remote_machine.RemoteMachineConnectionProvider;
import org.uitnet.testing.smartfwk.remote_machine.RemoteMachineManager;
import org.uitnet.testing.smartfwk.ui.core.objects.validator.mechanisms.TextMatchMechanism;
import org.uitnet.testing.smartfwk.ui.core.utils.ObjectUtil;
import org.uitnet.testing.smartfwk.ui.core.utils.StringUtil;

public abstract class AbstractRemoteMachineActionHandler
implements RemoteMachineConnectionProvider {
    protected RemoteMachineManager remoteMachineManager;
    protected String appName;
    protected String remoteMachineName;
    protected RemoteMachineConfig remoteMachineConfig;
    protected int sessionExpiryDurationInSeconds;
    protected RemoteMachineConnection connection;
    protected long lastRequestAccessTimeInMs;

    public AbstractRemoteMachineActionHandler(String remoteMachineName, String appName, int sessionExpiryDurationInSeconds, RemoteMachineConfig remoteMachineConfig) {
        this.remoteMachineName = remoteMachineName;
        this.appName = appName;
        this.sessionExpiryDurationInSeconds = sessionExpiryDurationInSeconds;
        this.remoteMachineConfig = remoteMachineConfig;
    }

    public void setRemoteMachineManager(RemoteMachineManager remoteMachineManager) {
        this.remoteMachineManager = remoteMachineManager;
    }

    public void connect() {
        this.connection = this.connect(this.remoteMachineConfig);
    }

    private synchronized void verifyConnection() {
        if (this.connection == null || this.isSessionExpired()) {
            this.disconnect();
            this.connection = this.connect(this.remoteMachineConfig);
        }
        this.lastRequestAccessTimeInMs = Calendar.getInstance().getTimeInMillis();
    }

    protected boolean isSessionExpired() {
        long currTimeInMs = Calendar.getInstance().getTimeInMillis();
        long durationInSeconds = (currTimeInMs - this.lastRequestAccessTimeInMs) / 1000L;
        return durationInSeconds >= (long)this.sessionExpiryDurationInSeconds;
    }

    public List<String> getFileList(String absolutePath) {
        String cmd = "cd " + absolutePath + " && find . -maxdepth 1 ! -type d";
        String result = this.executeCommand(cmd);
        return this.prepareFileList(result);
    }

    public List<String> getFolderList(String absolutePath) {
        String cmd = "cd " + absolutePath + " && find . -maxdepth 1 -type d";
        String result = this.executeCommand(cmd);
        return this.prepareFileList(result);
    }

    public AbstractRemoteMachineActionHandler validateFileExists(String absolutePath, TextMatchMechanism fileNameMatchMechanism, String expectedValue) {
        List<String> files = this.getFileList(absolutePath);
        for (String file : files) {
            if (!StringUtil.isTextMatchedWithExpectedValue(file, expectedValue, fileNameMatchMechanism)) continue;
            return this;
        }
        Assert.fail((String)("No file found on '" + absolutePath + "' location using TextMatchMechanism: " + fileNameMatchMechanism + " that matches expected value '" + expectedValue + "'. AppName: " + this.appName + ", TargetServerName: " + this.remoteMachineName));
        return this;
    }

    public AbstractRemoteMachineActionHandler validateFilesExist(String absolutePath, List<String> files) {
        List<String> remoteFiles = this.getFileList(absolutePath);
        List newList = Lists.newArrayList(files);
        newList.removeAll(remoteFiles);
        if (newList.size() > 0) {
            Assert.fail((String)("Following files are not found on '" + absolutePath + "' location'. AppName: " + this.appName + ", TargetServerName: " + this.remoteMachineName + ". Not found files: " + newList));
        }
        return this;
    }

    public AbstractRemoteMachineActionHandler validateFolderExists(String absolutePath, TextMatchMechanism directoryNameMatchMechanism, String expectedValue) {
        List<String> files = this.getFolderList(absolutePath);
        for (String file : files) {
            if (!StringUtil.isTextMatchedWithExpectedValue(file, expectedValue, directoryNameMatchMechanism)) continue;
            return this;
        }
        Assert.fail((String)("No folder found on '" + absolutePath + "' location using TextMatchMechanism: " + directoryNameMatchMechanism + " that matches expected value '" + expectedValue + "'. AppName: " + this.appName + ", TargetServerName: " + this.remoteMachineName));
        return this;
    }

    public AbstractRemoteMachineActionHandler validateFolderExist(String absolutePath, List<String> folders) {
        List<String> remoteFiles = this.getFolderList(absolutePath);
        List newList = Lists.newArrayList(folders);
        newList.removeAll(remoteFiles);
        if (newList.size() > 0) {
            Assert.fail((String)("Following folders are not found on '" + absolutePath + "' location'. AppName: " + this.appName + ", TargetServerName: " + this.remoteMachineName + ". Not found folders: " + newList));
        }
        return this;
    }

    public AbstractRemoteMachineActionHandler deleteFiles(String absolutePath, TextMatchMechanism fileNameMatchMechanism, String expectedValue) {
        List<String> files = this.getFileList(absolutePath);
        for (String file : files) {
            if (StringUtil.isEmptyAfterTrim(file) || !StringUtil.isTextMatchedWithExpectedValue(file, expectedValue, fileNameMatchMechanism)) continue;
            this.executeCommand("cd " + absolutePath + " && rm " + file);
        }
        return this;
    }

    public List<String> downloadFiles(String absoluteRemotePath, TextMatchMechanism fileNameMatchMechanism, String expectedValue, String absoluteLocalPath) {
        List<String> files = this.getFileList(absoluteRemotePath);
        LinkedList<String> dowloadedFiles = new LinkedList<String>();
        for (String file : files) {
            if (StringUtil.isEmptyAfterTrim(file) || !StringUtil.isTextMatchedWithExpectedValue(file, expectedValue, fileNameMatchMechanism)) continue;
            String downloadedFileName = this.downloadFile(absoluteRemotePath, file, absoluteLocalPath);
            dowloadedFiles.add(downloadedFileName);
        }
        return dowloadedFiles;
    }

    public List<String> uploadFiles(String absoluteLocalPath, TextMatchMechanism fileNameMatchMechanism, String expectedValue, String absoluteRemotePath) {
        List<String> files = LocalMachineFileSystem.listFiles(absoluteLocalPath, fileNameMatchMechanism, expectedValue);
        LinkedList<String> uploadedFiles = new LinkedList<String>();
        for (String file : files) {
            if (StringUtil.isEmptyAfterTrim(file)) continue;
            String downloadedFileName = this.uploadFile(file, absoluteRemotePath);
            uploadedFiles.add(downloadedFileName);
        }
        return uploadedFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommand(String command) {
        this.verifyConnection();
        ChannelExec channel = null;
        try {
            channel = (ChannelExec)((Session)this.connection.getConnection()).openChannel("exec");
            channel.setCommand(command);
            ByteArrayOutputStream responseStream = new ByteArrayOutputStream();
            channel.setOutputStream((OutputStream)responseStream);
            InputStream dataStream = channel.getInputStream();
            InputStream errorStream = channel.getErrStream();
            channel.connect(10000);
            String result = IOUtils.toString((InputStream)dataStream, (Charset)StandardCharsets.UTF_8);
            String error = null;
            if (channel.getExitStatus() != 0) {
                error = IOUtils.toString((InputStream)errorStream, (Charset)StandardCharsets.UTF_8);
                throw new RuntimeException("Remote machine command failed. Command: " + command + ". Error: " + error);
            }
            String string = result;
            return string;
        }
        catch (Exception e) {
            Assert.fail((String)("Remote machine command failed. Command: " + command + ". Reason: " + e.getMessage()), (Throwable)e);
        }
        finally {
            if (channel != null) {
                try {
                    channel.disconnect();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String downloadFile(String absoluteRemotePath, String remoteFileName, String absoluteLocalPath) {
        this.verifyConnection();
        ChannelSftp channel = null;
        try {
            channel = (ChannelSftp)((Session)this.connection.getConnection()).openChannel("sftp");
            channel.connect(10000);
            channel.get(absoluteRemotePath + "/" + remoteFileName, absoluteLocalPath + "/" + remoteFileName);
        }
        catch (Exception e) {
            Assert.fail((String)("Failed to download '" + absoluteRemotePath + "/" + remoteFileName + "' file. Reason: " + e.getMessage()), (Throwable)e);
        }
        finally {
            if (channel != null) {
                try {
                    channel.disconnect();
                }
                catch (Exception exception) {}
            }
        }
        return absoluteLocalPath + File.separator + remoteFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String downloadFileAsDifferentName(String absoluteRemotePath, String remoteFileName, String absoluteLocalPath, String newFileName) {
        this.verifyConnection();
        ChannelSftp channel = null;
        try {
            channel = (ChannelSftp)((Session)this.connection.getConnection()).openChannel("sftp");
            channel.connect(10000);
            channel.get(absoluteRemotePath + "/" + remoteFileName, absoluteLocalPath + "/" + newFileName);
        }
        catch (Exception e) {
            Assert.fail((String)("Failed to download '" + absoluteRemotePath + "/" + remoteFileName + "' file. Reason: " + e.getMessage()), (Throwable)e);
        }
        finally {
            if (channel != null) {
                try {
                    channel.disconnect();
                }
                catch (Exception exception) {}
            }
        }
        return absoluteLocalPath + File.separator + newFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String downloadFile(String absoluteRemoteFilePath, String absoluteLocalPath) {
        this.verifyConnection();
        ChannelSftp channel = null;
        String fileName = null;
        try {
            fileName = LocalMachineFileSystem.extractFileName(absoluteRemoteFilePath);
            channel = (ChannelSftp)((Session)this.connection.getConnection()).openChannel("sftp");
            channel.connect(10000);
            File localPath = new File(absoluteLocalPath);
            if (!localPath.exists()) {
                localPath.mkdirs();
            }
            channel.get(absoluteRemoteFilePath, absoluteLocalPath);
        }
        catch (Exception e) {
            Assert.fail((String)("Failed to download '" + absoluteRemoteFilePath + "' file to local location '" + absoluteLocalPath + "'. Reason: " + e.getMessage()), (Throwable)e);
        }
        finally {
            if (channel != null) {
                try {
                    channel.disconnect();
                }
                catch (Exception exception) {}
            }
        }
        return absoluteLocalPath + File.separator + fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String downloadFileAsDifferentName(String absoluteRemoteFilePath, String absoluteLocalPath, String newFileName) {
        this.verifyConnection();
        ChannelSftp channel = null;
        try {
            channel = (ChannelSftp)((Session)this.connection.getConnection()).openChannel("sftp");
            channel.connect(10000);
            File localPath = new File(absoluteLocalPath);
            if (!localPath.exists()) {
                localPath.mkdirs();
            }
            channel.get(absoluteRemoteFilePath, absoluteLocalPath + File.separator + newFileName);
        }
        catch (Exception e) {
            Assert.fail((String)("Failed to download '" + absoluteRemoteFilePath + "' file to local location '" + absoluteLocalPath + "'. Reason: " + e.getMessage()), (Throwable)e);
        }
        finally {
            if (channel != null) {
                try {
                    channel.disconnect();
                }
                catch (Exception exception) {}
            }
        }
        return absoluteLocalPath + File.separator + newFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String uploadFile(String absoluteLocalPath, String localFileName, String absoluteRemotePath) {
        this.verifyConnection();
        ChannelSftp channel = null;
        try {
            channel = (ChannelSftp)((Session)this.connection.getConnection()).openChannel("sftp");
            channel.connect(10000);
            channel.put(absoluteLocalPath + File.separator + localFileName, absoluteRemotePath);
        }
        catch (Exception e) {
            Assert.fail((String)("Failed to upload '" + absoluteLocalPath + File.separator + localFileName + "' file at location '" + absoluteRemotePath + "'. Reason: " + e.getMessage()), (Throwable)e);
        }
        finally {
            if (channel != null) {
                try {
                    channel.disconnect();
                }
                catch (Exception exception) {}
            }
        }
        return absoluteRemotePath + "/" + localFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String uploadFileAsDifferentName(String absoluteLocalPath, String localFileName, String absoluteRemotePath, String newRemoteFileName) {
        this.verifyConnection();
        ChannelSftp channel = null;
        try {
            channel = (ChannelSftp)((Session)this.connection.getConnection()).openChannel("sftp");
            channel.connect(10000);
            channel.put(absoluteLocalPath + File.separator + localFileName, absoluteRemotePath + "/" + newRemoteFileName);
        }
        catch (Exception e) {
            Assert.fail((String)("Failed to upload '" + absoluteLocalPath + File.separator + localFileName + "' file at location '" + absoluteRemotePath + "'. Reason: " + e.getMessage()), (Throwable)e);
        }
        finally {
            if (channel != null) {
                try {
                    channel.disconnect();
                }
                catch (Exception exception) {}
            }
        }
        return absoluteRemotePath + "/" + newRemoteFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String uploadFile(String absoluteLocalFilePath, String absoluteRemotePath) {
        this.verifyConnection();
        ChannelSftp channel = null;
        try {
            channel = (ChannelSftp)((Session)this.connection.getConnection()).openChannel("sftp");
            channel.connect(10000);
            channel.put(absoluteLocalFilePath, absoluteRemotePath);
        }
        catch (Exception e) {
            Assert.fail((String)("Failed to upload '" + absoluteLocalFilePath + "' file at location '" + absoluteRemotePath + "'. Reason: " + e.getMessage()), (Throwable)e);
        }
        finally {
            if (channel != null) {
                try {
                    channel.disconnect();
                }
                catch (Exception exception) {}
            }
        }
        return absoluteRemotePath + "/" + new File(absoluteLocalFilePath).getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String uploadFileAsDifferentName(String absoluteLocalFilePath, String absoluteRemotePath, String newRemoteFileName) {
        this.verifyConnection();
        ChannelSftp channel = null;
        try {
            channel = (ChannelSftp)((Session)this.connection.getConnection()).openChannel("sftp");
            channel.connect(10000);
            channel.put(absoluteLocalFilePath, absoluteRemotePath + "/" + newRemoteFileName);
        }
        catch (Exception e) {
            Assert.fail((String)("Failed to upload '" + absoluteLocalFilePath + "' file at location '" + absoluteRemotePath + "'. Reason: " + e.getMessage()), (Throwable)e);
        }
        finally {
            if (channel != null) {
                try {
                    channel.disconnect();
                }
                catch (Exception exception) {}
            }
        }
        return absoluteRemotePath + "/" + newRemoteFileName;
    }

    private List<String> prepareFileList(String cmdOutput) {
        LinkedList<String> files = new LinkedList<String>();
        if (StringUtil.isEmptyAfterTrim(cmdOutput)) {
            return files;
        }
        try (StringReader sr = new StringReader(cmdOutput);
             BufferedReader br = new BufferedReader(sr);){
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.length() <= 2) continue;
                files.add(line.substring(2));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return files;
    }

    @Override
    public synchronized void disconnect() {
        if (this.connection != null) {
            this.disconnect(this.connection);
            this.connection = null;
        }
    }

    public AbstractRemoteMachineActionHandler clone() {
        try {
            AbstractRemoteMachineActionHandler obj = (AbstractRemoteMachineActionHandler)ObjectUtil.findClassConstructor(this.getClass(), new Class[]{String.class, String.class, Integer.TYPE, RemoteMachineConfig.class}).newInstance(this.remoteMachineName, this.appName, this.sessionExpiryDurationInSeconds, this.remoteMachineConfig);
            return obj;
        }
        catch (Exception ex) {
            Assert.fail((String)("Failed to clone '" + this.getClass().getName() + "' class object."), (Throwable)ex);
            return null;
        }
    }

    protected abstract void disconnect(RemoteMachineConnection var1);
}

