/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.remote_machine;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.TypeRef;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.remote_machine.RemoteMachineConfig;

public class RemoteMachinesConfig {
    private String appName;
    private String configFilePath;
    private List<RemoteMachineConfig> remoteMachines;
    private Map<String, Object> additionalProps;

    public RemoteMachinesConfig(String appName, String remoteMachinesConfigFilePath, DocumentContext yamlDoc) {
        this.appName = appName;
        this.configFilePath = remoteMachinesConfigFilePath;
        this.additionalProps = (Map)yamlDoc.read("$.additionalProps", (TypeRef)new TypeRef<HashMap<String, Object>>(){});
        this.remoteMachines = (List)yamlDoc.read("$.remoteMachines", (TypeRef)new TypeRef<List<RemoteMachineConfig>>(){});
    }

    public String getAppName() {
        return this.appName;
    }

    public String getConfigFilePath() {
        return this.configFilePath;
    }

    public List<RemoteMachineConfig> getRemoteMachines() {
        return this.remoteMachines;
    }

    public RemoteMachineConfig getRemoteMachine(String name) {
        if (this.remoteMachines == null) {
            Assert.fail((String)("Remote machine '" + name + "' is not configured with application '" + this.appName + "'. You can configure in '" + this.configFilePath + "' file."));
        }
        for (RemoteMachineConfig remoteMachine : this.remoteMachines) {
            if (!remoteMachine.getName().equals(name)) continue;
            return remoteMachine;
        }
        Assert.fail((String)("Remote machine '" + name + "' is not configured with application '" + this.appName + "'. You can configure in '" + this.configFilePath + "' file."));
        return null;
    }

    public <T> T getAdditionalPropertyValue(String propName, Class<T> clazz) {
        Assert.assertTrue((boolean)this.additionalProps.containsKey(propName), (String)("Please specify the additional property '" + propName + "' in application '" + this.appName + "' '" + this.configFilePath + "' file."));
        return clazz.cast(this.additionalProps.get(propName));
    }
}

