/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.remote_machine;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.ProxyHTTP;
import com.jcraft.jsch.Session;
import java.io.File;
import java.util.Map;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.remote_machine.AbstractRemoteMachineActionHandler;
import org.uitnet.testing.smartfwk.remote_machine.RemoteMachineConfig;
import org.uitnet.testing.smartfwk.remote_machine.RemoteMachineConnection;
import org.uitnet.testing.smartfwk.ui.core.commons.Locations;
import org.uitnet.testing.smartfwk.ui.core.config.ProxyConfigurationType;
import org.uitnet.testing.smartfwk.ui.core.utils.StringUtil;

public class SmartRemoteMachineActionHandler
extends AbstractRemoteMachineActionHandler {
    public SmartRemoteMachineActionHandler(String remoteMachineName, String appName, int sessionExpiryDurationInSeconds, RemoteMachineConfig remoteMachineConfig) {
        super(remoteMachineName, appName, sessionExpiryDurationInSeconds, remoteMachineConfig);
    }

    @Override
    public RemoteMachineConnection connect(RemoteMachineConfig remoteMachineConfig) {
        Session session = null;
        RemoteMachineConnection connection = null;
        try {
            JSch jsch = new JSch();
            if (!StringUtil.isEmptyAfterTrim(remoteMachineConfig.getPrivateKeyPath())) {
                jsch.addIdentity(Locations.getProjectRootDir() + File.separator + remoteMachineConfig.getPrivateKeyPath(), StringUtil.isEmptyAfterTrim(remoteMachineConfig.getPublicKeyPath()) ? null : Locations.getProjectRootDir() + File.separator + remoteMachineConfig.getPublicKeyPath(), StringUtil.isEmptyAfterTrim(remoteMachineConfig.getPrivateKeyPassphrase()) ? null : remoteMachineConfig.getPrivateKeyPassphrase().getBytes());
            }
            session = jsch.getSession(remoteMachineConfig.getUserName(), remoteMachineConfig.getHostNameOrIpAddress(), remoteMachineConfig.getPort());
            if (!StringUtil.isEmptyAfterTrim(remoteMachineConfig.getPassword())) {
                session.setPassword(remoteMachineConfig.getPassword());
            }
            if (remoteMachineConfig.getSshConfigs() != null) {
                for (Map.Entry<String, String> config : remoteMachineConfig.getSshConfigs().entrySet()) {
                    session.setConfig(config.getKey(), config.getValue());
                }
            }
            if (remoteMachineConfig.getProxyConfig() != null && remoteMachineConfig.getProxyConfig().getProxyConfigType() != null && remoteMachineConfig.getProxyConfig().getProxyConfigType() == ProxyConfigurationType.MANUAL_PROXY) {
                ProxyHTTP proxy = new ProxyHTTP(remoteMachineConfig.getProxyConfig().getHttpProxyHostname(), Integer.parseInt(remoteMachineConfig.getProxyConfig().getHttpProxyPort()));
                proxy.setUserPasswd(remoteMachineConfig.getProxyConfig().getSocksUsername(), remoteMachineConfig.getProxyConfig().getSocksPassword());
                session.setProxy((Proxy)proxy);
            }
            session.connect();
            connection = new RemoteMachineConnection(session);
        }
        catch (Exception e) {
            if (session != null) {
                try {
                    session.disconnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Assert.fail((String)("Failed to connect to the remote server (AppName: " + this.appName + ", RemoteMachineName: " + this.remoteMachineName + ", HostNameOrIpAddress: " + remoteMachineConfig.getHostNameOrIpAddress() + "). Reason: " + e.getMessage()), (Throwable)e);
        }
        return connection;
    }

    @Override
    protected void disconnect(RemoteMachineConnection connection) {
        try {
            if (connection != null) {
                ((Session)connection.getConnection()).disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

